/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.JavaImportsFormatter;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaConstructor;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaStaticBlock;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import com.liferay.source.formatter.parser.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaClassParser {
    private static final Pattern _anonymousClassPattern = Pattern.compile("\\snew [\\w\\.\t\n]+(\\(|\\<)");
    private static final Pattern _implementsPattern = Pattern.compile("(\\A|\\s)implements\\s");
    private static final Pattern _javaTermEndPattern = Pattern.compile("[;}]\\s*?\n");
    private static final Pattern _javaTermStartLinePattern = Pattern.compile(".*?[{;]\\s*?\n", 32);

    public static List<JavaClass> parseAnonymousClasses(String content) throws IOException, ParseException {
        return JavaClassParser.parseAnonymousClasses(content, null, Collections.emptyList());
    }

    public static List<JavaClass> parseAnonymousClasses(String content, String packageName, List<String> importNames) throws IOException, ParseException {
        ArrayList<JavaClass> anonymousClasses = new ArrayList<JavaClass>();
        Matcher matcher = _anonymousClassPattern.matcher(content);
        while (matcher.find()) {
            String anonymousClassContent = JavaClassParser._getAnonymousClassContent(content, matcher.start() + 1, StringUtil.equals(matcher.group(1), "<"));
            if (anonymousClassContent == null) continue;
            anonymousClasses.add(JavaClassParser._parseJavaClass("", packageName, importNames, anonymousClassContent, SourceUtil.getLineNumber(content, matcher.start()), "private", false, false, false, false, false, true));
        }
        return anonymousClasses;
    }

    public static JavaClass parseJavaClass(String fileName, String content) throws IOException, ParseException {
        String[] importLines;
        String className = JavaSourceUtil.getClassName(fileName);
        Pattern pattern = Pattern.compile(StringBundler.concat("\n(public\\s+)?(abstract\\s+)?(final\\s+)?@?", "(class|enum|interface)\\s+", className, "([<|\\s][^\\{]*)\\{"));
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            throw new ParseException("Parsing error");
        }
        int x = matcher.start() + 1;
        int y = x + 1;
        do {
            if ((y = content.lastIndexOf("\n\n", y - 1)) != -1) continue;
            throw new ParseException("Parsing error");
        } while (ToolsUtil.getLevel(content.substring(y, x)) != 0);
        int lineNumber = SourceUtil.getLineNumber(content, y + 2);
        String classContent = content.substring(y + 2);
        boolean isAbstract = false;
        if (matcher.group(2) != null) {
            isAbstract = true;
        }
        boolean isEnum = false;
        boolean isFinal = false;
        if (matcher.group(3) != null) {
            isFinal = true;
        }
        boolean isInterface = false;
        if (matcher.group(4) != null) {
            String token = matcher.group(4);
            if (token.equals("enum")) {
                isEnum = true;
            } else if (token.equals("interface")) {
                isInterface = true;
            }
        }
        ArrayList<String> importNames = new ArrayList<String>();
        for (String importLine : importLines = StringUtil.splitLines(JavaImportsFormatter.getImports(content))) {
            if (!Validator.isNotNull(importLine)) continue;
            importNames.add(importLine.substring(7, importLine.length() - 1));
        }
        JavaClass javaClass = JavaClassParser._parseJavaClass(className, JavaSourceUtil.getPackageName(content), importNames, classContent, lineNumber, "public", isAbstract, isFinal, false, isEnum, isInterface, false);
        return JavaClassParser._parseExtendsImplements(javaClass, StringUtil.trim(matcher.group(5)));
    }

    private static String _getAnonymousClassContent(String content, int start, boolean genericClass) {
        String anonymousClassContent;
        int x = start;
        if (genericClass) {
            int level;
            do {
                if ((x = content.indexOf(62, x + 1)) != -1) continue;
                return null;
            } while ((level = ToolsUtil.getLevel(content.substring(start, x + 1), "<", ">")) != 0);
            if (!Objects.equals(Character.valueOf(content.charAt(x + 1)), Character.valueOf('('))) {
                return null;
            }
        }
        do {
            if ((x = content.indexOf(41, x + 1)) != -1) continue;
            return null;
        } while (ToolsUtil.getLevel(content.substring(start, x + 1), "(", ")") != 0);
        String s = StringUtil.trim(content.substring(x + 1));
        if (!s.startsWith("{\n")) {
            return null;
        }
        do {
            if ((x = content.indexOf(125, x + 1)) != -1) continue;
            return null;
        } while (ToolsUtil.getLevel(anonymousClassContent = content.substring(start, x + 1), "{", "}") != 0);
        return anonymousClassContent;
    }

    private static String _getClassName(String line) {
        int pos = line.indexOf(" extends ");
        if (pos == -1) {
            pos = line.indexOf(" implements ");
        }
        if (pos == -1) {
            pos = line.indexOf(123);
        }
        if (pos != -1) {
            line = line.substring(0, pos);
        }
        if ((pos = line.indexOf(60)) != -1) {
            line = line.substring(0, pos);
        }
        line = line.trim();
        pos = line.lastIndexOf(32);
        return line.substring(pos + 1);
    }

    private static int _getCommentEndLineNumber(String classContent, int lineNumber) {
        String line;
        while (!(line = SourceUtil.getLine(classContent, lineNumber)).endsWith("*/")) {
            ++lineNumber;
        }
        return lineNumber;
    }

    private static String _getConstructorOrMethodName(String line) {
        int x = line.lastIndexOf(32);
        return line.substring(x + 1);
    }

    private static JavaTerm _getJavaTerm(String packageName, List<String> importNames, String metadata, String javaTermContent, int lineNumber) throws IOException, ParseException {
        Matcher matcher1 = _javaTermStartLinePattern.matcher(javaTermContent);
        if (!matcher1.find()) {
            return null;
        }
        String startLine = StringUtil.trim(matcher1.group());
        int x = startLine.indexOf(40);
        if (x != -1) {
            startLine = startLine.substring(0, x);
        }
        startLine = StringUtil.replace(startLine, new String[]{"\t", "\n", " synchronized "}, new String[]{"", " ", " "});
        javaTermContent = metadata + javaTermContent;
        if (startLine.startsWith("static {")) {
            return new JavaStaticBlock(javaTermContent, lineNumber);
        }
        String accessModifier = "default";
        for (String curAccessModifier : JavaTerm.ACCESS_MODIFIERS) {
            if (!startLine.startsWith(curAccessModifier)) continue;
            accessModifier = curAccessModifier;
            break;
        }
        boolean isAbstract = SourceUtil.containsUnquoted(startLine, " abstract ");
        boolean isEnum = SourceUtil.containsUnquoted(startLine, " enum ");
        boolean isFinal = SourceUtil.containsUnquoted(startLine, " final ");
        boolean isInterface = SourceUtil.containsUnquoted(startLine, " interface ");
        boolean isStatic = SourceUtil.containsUnquoted(startLine, " static ");
        int y = startLine.indexOf(61);
        if (SourceUtil.containsUnquoted(startLine, " @interface ") || SourceUtil.containsUnquoted(startLine, " class ") || SourceUtil.containsUnquoted(startLine, " enum ") || SourceUtil.containsUnquoted(startLine, " interface ")) {
            JavaClass javaClass = JavaClassParser._parseJavaClass(JavaClassParser._getClassName(startLine), packageName, importNames, javaTermContent, lineNumber, accessModifier, isAbstract, isFinal, isStatic, isEnum, isInterface, false);
            Pattern pattern = Pattern.compile(StringBundler.concat("\\s(class|enum|interface)\\s+", javaClass.getName(), "([<|\\s][^\\{]*)\\{"));
            Matcher matcher2 = pattern.matcher(javaTermContent);
            if (matcher2.find()) {
                javaClass = JavaClassParser._parseExtendsImplements(javaClass, matcher2.group(2));
            }
            return javaClass;
        }
        if (y > 0 && (x == -1 || x > y) || startLine.endsWith(";") && x == -1) {
            return new JavaVariable(JavaClassParser._getVariableName(startLine), javaTermContent, accessModifier, lineNumber, isAbstract, isFinal, isStatic);
        }
        if (x == -1) {
            return null;
        }
        int spaceCount = StringUtil.count(startLine, ' ');
        if (isStatic || spaceCount > 1 || accessModifier.equals("default") && spaceCount > 0) {
            return new JavaMethod(JavaClassParser._getConstructorOrMethodName(startLine), javaTermContent, accessModifier, lineNumber, isAbstract, isFinal, isStatic);
        }
        if (spaceCount == 1 || accessModifier.equals("default") && spaceCount == 0) {
            return new JavaConstructor(JavaClassParser._getConstructorOrMethodName(startLine), javaTermContent, accessModifier, lineNumber, isAbstract, isFinal, isStatic);
        }
        return null;
    }

    private static int _getJavaTermEndLineNumber(String classContent, int lineNumber) {
        int x = SourceUtil.getLineStartPos(classContent, lineNumber);
        String s = classContent.substring(x);
        Matcher matcher = _javaTermEndPattern.matcher(s);
        while (matcher.find()) {
            String javaTermContent = s.substring(0, matcher.end());
            if (ToolsUtil.getLevel(javaTermContent, "(", ")") != 0 || ToolsUtil.getLevel(javaTermContent, "{", "}") != 0) continue;
            return lineNumber + StringUtil.count(javaTermContent, "\n") - 1;
        }
        return -1;
    }

    private static int _getMatchingEndLineNumber(String classContent, int lineNumber, String increaseLevelString, String decreaseLevelString) {
        int level = 0;
        while ((level += ToolsUtil.getLevel(SourceUtil.getLine(classContent, lineNumber), increaseLevelString, decreaseLevelString)) != 0) {
            ++lineNumber;
        }
        return lineNumber;
    }

    private static String _getVariableName(String line) {
        int x = line.indexOf(61);
        int y = line.lastIndexOf(32);
        if (x != -1) {
            line = line.substring(0, x);
            line = StringUtil.trim(line);
            y = line.lastIndexOf(32);
            return line.substring(y + 1);
        }
        if (line.endsWith(";")) {
            return line.substring(y + 1, line.length() - 1);
        }
        return "";
    }

    private static JavaClass _parseExtendsImplements(JavaClass javaClass, String s) throws ParseException {
        int x;
        if (ToolsUtil.getLevel(s, "<", ">") != 0) {
            throw new ParseException("Parsing error around class declaration");
        }
        while ((x = s.indexOf("<")) != -1) {
            int y = x;
            while (ToolsUtil.getLevel(s.substring(x, (y = s.indexOf(">", y + 1)) + 1), "<", ">") != 0) {
            }
            s = StringUtil.trim(s.substring(0, x) + s.substring(y + 1));
        }
        Matcher matcher = _implementsPattern.matcher(s);
        if (matcher.find()) {
            javaClass.addImplementedClassNames(StringUtil.split(s.substring(matcher.end())));
            s = StringUtil.trim(s.substring(0, matcher.start()));
        }
        if ((s = StringUtil.trim(s)).startsWith("extends")) {
            javaClass.addExtendedClassNames(StringUtil.split(s.substring(7)));
        }
        return javaClass;
    }

    private static JavaClass _parseJavaClass(String className, String packageName, List<String> importNames, String classContent, int classLineNumber, String accessModifier, boolean isAbstract, boolean isFinal, boolean isStatic, boolean isEnum, boolean isInterface, boolean anonymous) throws IOException, ParseException {
        String line;
        JavaClass javaClass = new JavaClass(className, packageName, importNames, classContent, accessModifier, classLineNumber, isAbstract, isFinal, isStatic, isInterface, anonymous);
        int lineNumber = 0;
        int annotationLevel = 0;
        int level = 0;
        if (classContent.startsWith("/*")) {
            while (!(line = SourceUtil.getLine(classContent, ++lineNumber)).endsWith("*/")) {
            }
        }
        while ((annotationLevel += ToolsUtil.getLevel(line = SourceUtil.getLine(classContent, ++lineNumber))) != 0 || (level += ToolsUtil.getLevel(line, "{", "}")) == 0) {
        }
        if (isEnum) {
            do {
                if ((level += ToolsUtil.getLevel(line = StringUtil.trim(SourceUtil.getLine(classContent, ++lineNumber)), "{", "}")) != 0) continue;
                return javaClass;
            } while (!line.endsWith(";") || level != 1);
        }
        int javaTermLineNumber = -1;
        String line2;
        while ((line2 = StringUtil.trim(SourceUtil.getLine(classContent, ++lineNumber))) != null && !line2.equals("}")) {
            if (line2.equals("") || line2.startsWith("//")) continue;
            if (line2.equals("/*") || line2.matches("/\\*[^*].*")) {
                lineNumber = JavaClassParser._getCommentEndLineNumber(classContent, lineNumber);
                continue;
            }
            if (line2.equals("{")) {
                lineNumber = JavaClassParser._getMatchingEndLineNumber(classContent, lineNumber, "{", "}");
                continue;
            }
            if (javaTermLineNumber == -1) {
                javaTermLineNumber = lineNumber;
            }
            if (line2.startsWith("@")) {
                lineNumber = JavaClassParser._getMatchingEndLineNumber(classContent, lineNumber, "(", ")");
                continue;
            }
            if (line2.startsWith("/**")) {
                lineNumber = JavaClassParser._getCommentEndLineNumber(classContent, lineNumber);
                continue;
            }
            int x = SourceUtil.getLineStartPos(classContent, javaTermLineNumber);
            int y = SourceUtil.getLineStartPos(classContent, lineNumber);
            String metadata = classContent.substring(x, y);
            int javaTermEndLineNumber = JavaClassParser._getJavaTermEndLineNumber(classContent, lineNumber);
            if (javaTermEndLineNumber == -1) {
                throw new ParseException("Parsing error at line '" + StringUtil.trim(line2) + "'");
            }
            int z = SourceUtil.getLineStartPos(classContent, javaTermEndLineNumber + 1);
            String javaTermContent = classContent.substring(y, z);
            JavaTerm javaTerm = JavaClassParser._getJavaTerm(packageName, importNames, metadata, javaTermContent, classLineNumber + javaTermLineNumber - 1);
            if (javaTerm == null) {
                throw new ParseException("Parsing error at line '" + StringUtil.trim(line2) + "'");
            }
            javaClass.addChildJavaTerm(javaTerm);
            javaTermLineNumber = -1;
            lineNumber = javaTermEndLineNumber;
        }
        return javaClass;
    }
}

