/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.log;

import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.util.Validator;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Properties;

public class LogUtil {
    public static final boolean REMOVE_UNKNOWN_SOURCE = true;
    public static final int STACK_TRACE_LENGTH = 20;

    public static void debug(Log log, Properties props) {
        if (log.isDebugEnabled()) {
            UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter(props.size() + 1);
            props.list((PrintWriter)UnsyncPrintWriterPool.borrow((Writer)unsyncStringWriter));
            log.debug(unsyncStringWriter.toString());
        }
    }

    public static void log(Log log, Throwable throwable) {
        LogUtil.log(log, throwable, null);
    }

    public static void log(Log log, Throwable throwable, String message) {
        if (throwable == null) {
            if (Validator.isNotNull(message)) {
                log.error(message);
                return;
            }
            throw new IllegalArgumentException("Throwable or message must be set");
        }
        Throwable causeThrowable = throwable;
        while (causeThrowable.getCause() != null) {
            causeThrowable = causeThrowable.getCause();
        }
        StackTraceElement[] stackTraceElements = causeThrowable.getStackTrace();
        if (stackTraceElements.length <= 20) {
            if (Validator.isNotNull(message)) {
                log.error(message, causeThrowable);
            } else {
                log.error(causeThrowable);
            }
            return;
        }
        int count = 0;
        ArrayList<StackTraceElement> stackTraceElementsList = new ArrayList<StackTraceElement>();
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            String className = stackTraceElement.getClassName();
            boolean addElement = true;
            if (stackTraceElement.getLineNumber() < 0) {
                addElement = false;
            }
            if (className.startsWith("$") || className.startsWith("java.lang.reflect.") || className.startsWith("org.springframework.") || className.startsWith("sun.reflect.")) {
                addElement = false;
            }
            if (addElement) {
                stackTraceElementsList.add(stackTraceElement);
                ++count;
            }
            if (count >= 20) break;
        }
        stackTraceElements = stackTraceElementsList.toArray(new StackTraceElement[0]);
        causeThrowable.setStackTrace(stackTraceElements);
        if (Validator.isNotNull(message)) {
            log.error(message, causeThrowable);
        } else {
            log.error(causeThrowable);
        }
    }
}

