/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.EnvPropertiesUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.SystemEnv;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class SystemProperties {
    public static final String SYSTEM_ENV_OVERRIDE_PREFIX = "SYSTEM_LIFERAY_";
    public static final String SYSTEM_PROPERTIES_QUIET = "system.properties.quiet";
    public static final String SYSTEM_PROPERTIES_SET = "system.properties.set";
    public static final String SYSTEM_PROPERTIES_SET_OVERRIDE = "system.properties.set.override";
    public static final String TMP_DIR = "java.io.tmpdir";
    private static final Map<String, String> _properties = new ConcurrentHashMap<String, String>();

    public static void clear(String key) {
        System.clearProperty(key);
        _properties.remove(key);
    }

    public static String get(String key) {
        String value = _properties.get(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    public static Properties getProperties() {
        return PropertiesUtil.fromMap(_properties);
    }

    public static void load(ClassLoader classLoader) {
        Throwable throwable;
        Enumeration<URL> enumeration;
        Properties properties = new Properties();
        ArrayList<Object> urls = null;
        if (!GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_QUIET))) {
            urls = new ArrayList<Object>();
        }
        try {
            enumeration = classLoader.getResources("system.properties");
            while (enumeration.hasMoreElements()) {
                URL url2 = enumeration.nextElement();
                throwable = null;
                try (InputStream inputStream = url2.openStream();){
                    properties.load(inputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                if (urls == null) continue;
                urls.add(url2);
            }
        }
        catch (IOException ioException) {
            throw new ExceptionInInitializerError(ioException);
        }
        try {
            enumeration = classLoader.getResources("system-ext.properties");
            while (enumeration.hasMoreElements()) {
                Object url = enumeration.nextElement();
                throwable = null;
                try (InputStream inputStream = ((URL)url).openStream();){
                    properties.load(inputStream);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                if (urls == null) continue;
                urls.add(url);
            }
        }
        catch (IOException ioException) {
            throw new ExceptionInInitializerError(ioException);
        }
        SystemEnv.setProperties(properties);
        if (GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_SET), true)) {
            boolean systemPropertiesSetOverride = GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_SET_OVERRIDE), true);
            for (Map.Entry entry : properties.entrySet()) {
                String key = String.valueOf(entry.getKey());
                if (!systemPropertiesSetOverride && !Validator.isNull(System.getProperty(key))) continue;
                System.setProperty(key, String.valueOf(entry.getValue()));
            }
            if (!systemPropertiesSetOverride) {
                Properties systemProperties = System.getProperties();
                for (Map.Entry<Object, Object> entry : systemProperties.entrySet()) {
                    String key = String.valueOf(entry.getKey());
                    if (!Validator.isNotNull(properties.get(key))) continue;
                    properties.put(key, entry.getValue());
                }
            }
        }
        PropertiesUtil.fromProperties(properties, _properties);
        EnvPropertiesUtil.loadEnvOverrides(SYSTEM_ENV_OVERRIDE_PREFIX, SystemProperties::set);
        if (urls != null) {
            for (Object url : urls) {
                System.out.println("Loading " + url);
            }
        }
    }

    public static void set(String key, String value) {
        System.setProperty(key, value);
        _properties.put(key, value);
    }

    static {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        SystemProperties.load(classLoader);
    }
}

