/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.prose;

import com.liferay.poshi.core.prose.BasePoshiProse;
import com.liferay.poshi.core.prose.PoshiProseStatement;
import com.liferay.poshi.core.util.Dom4JUtil;
import com.liferay.poshi.core.util.StringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.dom4j.tree.DefaultAttribute;

public class PoshiProseScenario
extends BasePoshiProse {
    protected static final String[] KEYWORDS = new String[]{"Setup", "Scenario", "Teardown"};
    protected String scenarioDescription;
    private static final Pattern _scenarioPattern = Pattern.compile("(?s)Scenario:\\s*(?<name>\\w([ \\w]*\\w)?)\\s*(?<tags>(@.*?\".*?\"\\s*)+)*(?<content>[^\\s].*)");
    private static final Pattern _setupPattern = Pattern.compile("(?s)Setup:\\s*(?<tags>(@.*?\".*?\"\\s*)+)*(?<content>[^\\s].*)");
    private static final Pattern _teardownPattern = Pattern.compile("(?s)Teardown:\\s*(?<tags>(@.*?\".*?\"\\s*)+)*(?<content>[^\\s].*)");
    private final List<PoshiProseStatement> _poshiProseStatements = new ArrayList<PoshiProseStatement>();
    private final String _scenarioContent;
    private final String _scenarioName;
    private final Map<String, String> _tagMap = new LinkedHashMap<String, String>();
    private final Type _type;

    public PoshiProseScenario(String poshiProseScenarioString) {
        poshiProseScenarioString = this.filterCommentLines(poshiProseScenarioString);
        Matcher setupMatcher = _setupPattern.matcher(poshiProseScenarioString);
        String tags = null;
        if (setupMatcher.find()) {
            this._scenarioContent = setupMatcher.group("content");
            this._scenarioName = null;
            this._type = Type.Setup;
            tags = setupMatcher.group("tags");
        } else {
            Matcher teardownMatcher = _teardownPattern.matcher(poshiProseScenarioString);
            if (teardownMatcher.find()) {
                this._scenarioContent = teardownMatcher.group("content");
                this._scenarioName = null;
                this._type = Type.Teardown;
                tags = teardownMatcher.group("tags");
            } else {
                Matcher scenarioMatcher = _scenarioPattern.matcher(poshiProseScenarioString);
                if (!scenarioMatcher.find()) {
                    throw new RuntimeException("Prose scenario does not match pattern " + _scenarioPattern.pattern() + "\n" + poshiProseScenarioString);
                }
                this._scenarioContent = scenarioMatcher.group("content");
                this._scenarioName = scenarioMatcher.group("name");
                this._type = Type.Scenario;
                tags = scenarioMatcher.group("tags");
            }
        }
        if (tags != null) {
            Matcher tagMatcher = this.tagPattern.matcher(tags);
            while (tagMatcher.find()) {
                this._tagMap.put(tagMatcher.group("tagName"), tagMatcher.group("tagValue"));
            }
        }
        List<String> poshiProseStatementStrings = StringUtil.split(this._scenarioContent, PoshiProseStatement.KEYWORDS);
        for (String poshiProseStatementString : poshiProseStatementStrings) {
            if (this.scenarioDescription == null && !this._startsWithProseStatementKeyword(poshiProseStatementString)) {
                this.scenarioDescription = poshiProseStatementString;
                continue;
            }
            this._poshiProseStatements.add(new PoshiProseStatement(poshiProseStatementString));
        }
    }

    @Override
    public Element toElement() {
        Element commandElement = this._type == Type.Setup ? Dom4JUtil.getNewElement("set-up") : (this._type == Type.Teardown ? Dom4JUtil.getNewElement("tear-down") : Dom4JUtil.getNewElement("command", null, new DefaultAttribute("name", this._scenarioName)));
        for (Map.Entry<String, String> entry : this._tagMap.entrySet()) {
            commandElement.add(Dom4JUtil.getNewElement("property", null, new DefaultAttribute("name", entry.getKey()), new DefaultAttribute("value", entry.getValue())));
        }
        for (PoshiProseStatement poshiProseStatement : this._poshiProseStatements) {
            commandElement.add(poshiProseStatement.toElement());
        }
        return commandElement;
    }

    private boolean _startsWithProseStatementKeyword(String poshiProseStatement) {
        for (String statementKeyWord : PoshiProseStatement.KEYWORDS) {
            if (!poshiProseStatement.startsWith(statementKeyWord)) continue;
            return true;
        }
        return false;
    }

    protected static enum Type {
        Scenario,
        Setup,
        Teardown;

    }
}

