/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.script;

import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.script.UnbalancedCodeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiScriptParserUtil {
    private static final Map<Character, Character> _codeBoundariesMap = new HashMap<Character, Character>(){
        {
            this.put(Character.valueOf('('), Character.valueOf(')'));
            this.put(Character.valueOf('['), Character.valueOf(']'));
            this.put(Character.valueOf('\"'), Character.valueOf('\"'));
            this.put(Character.valueOf('\''), Character.valueOf('\''));
            this.put(Character.valueOf('{'), Character.valueOf('}'));
        }
    };

    public static List<String> getMethodParameterValues(String content) {
        try {
            return PoshiScriptParserUtil.getMethodParameterValues(content, null);
        }
        catch (PoshiScriptParserException poshiScriptParserException) {
            poshiScriptParserException.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public static List<String> getMethodParameterValues(String content, Pattern pattern) throws PoshiScriptParserException {
        Matcher matcher;
        ArrayList<String> methodParameterValues = new ArrayList<String>();
        if (content.length() == 0) {
            return methodParameterValues;
        }
        StringBuilder sb = new StringBuilder();
        String methodParameterValue = sb.toString();
        for (char c : content.toCharArray()) {
            if (c == ',' && PoshiScriptParserUtil.isBalancedPoshiScript(methodParameterValue)) {
                Matcher matcher2;
                if (pattern != null && !(matcher2 = pattern.matcher(methodParameterValue)).matches()) {
                    sb.append(c);
                    continue;
                }
                methodParameterValues.add(methodParameterValue);
                sb.setLength(0);
                continue;
            }
            sb.append(c);
            methodParameterValue = sb.toString();
        }
        if (pattern != null && !(matcher = pattern.matcher(methodParameterValue)).matches()) {
            throw new PoshiScriptParserException("Invalid Poshi Script parameter syntax");
        }
        methodParameterValues.add(methodParameterValue);
        return methodParameterValues;
    }

    public static boolean isBalancedPoshiScript(String poshiScript) {
        try {
            return PoshiScriptParserUtil.isBalancedPoshiScript(poshiScript, false);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isBalancedPoshiScript(String poshiScript, boolean throwException) throws UnbalancedCodeException {
        poshiScript = PoshiScriptParserUtil._fixPoshiScript(poshiScript);
        Stack<Integer> stack = new Stack<Integer>();
        for (int i = 0; i < poshiScript.length(); ++i) {
            char c = poshiScript.charAt(i);
            if (!stack.isEmpty()) {
                int topIndex = (Integer)stack.peek();
                Character topCodeBoundary = Character.valueOf(poshiScript.charAt(topIndex));
                if (c == _codeBoundariesMap.get(topCodeBoundary).charValue() && i > 0 && poshiScript.charAt(i - 1) != '\\') {
                    stack.pop();
                    continue;
                }
                if (topCodeBoundary.charValue() == '\"' || topCodeBoundary.charValue() == '\'') continue;
            }
            if (_codeBoundariesMap.containsKey(Character.valueOf(c))) {
                stack.push(i);
                continue;
            }
            if (!_codeBoundariesMap.containsValue(Character.valueOf(c))) continue;
            if (throwException) {
                throw new UnbalancedCodeException("Unexpected closing boundary", i, poshiScript);
            }
            return false;
        }
        boolean balanced = stack.isEmpty();
        if (!balanced && throwException) {
            throw new UnbalancedCodeException("Unmatched opening boundary", (Integer)stack.peek(), poshiScript);
        }
        return balanced;
    }

    private static String _fixPoshiScript(String poshiScript) {
        if (poshiScript.contains("/*") && poshiScript.contains("*/")) {
            poshiScript = poshiScript.replaceAll("(?s)/\\*.*?\\*/", "/\\*\\*/");
        }
        if (poshiScript.contains("'''")) {
            poshiScript = poshiScript.replaceAll("(?s)'''.*?'''", "''''''");
        }
        if (poshiScript.contains("//")) {
            poshiScript = poshiScript.replaceAll("(?m)\n[\\s]*//.*?$", "//\n");
        }
        return poshiScript.trim();
    }
}

