/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseEmptyLinesCheck;
import java.io.IOException;

public class HTMLEmptyLinesCheck
extends BaseEmptyLinesCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = this.fixEmptyLinesInMultiLineTags(content);
        content = this.fixEmptyLinesInNestedTags(content);
        content = this.fixEmptyLinesBetweenTags(content);
        content = this.fixMissingEmptyLineAfterDoctype(content);
        content = this._fixMissingEmptyLineAroundSingleLineComment(content);
        return content;
    }

    private String _fixMissingEmptyLineAroundSingleLineComment(String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String trimmedLine = StringUtil.trim(line);
                if (trimmedLine.startsWith("<!--") && trimmedLine.endsWith("-->") && Validator.isNotNull(previousLine) || previousLine.startsWith("<!--") && previousLine.endsWith("-->") && Validator.isNotNull(line)) {
                    sb.append("\n");
                }
                sb.append(line);
                sb.append("\n");
                previousLine = trimmedLine;
            }
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

