/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CamelCaseNameCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_FOLLOWING_UNDERSCORE = "following.underscore.incorrect";
    private static final String _MSG_INCORRECT_FOLLOWING_UPPERCASE = "following.uppercase.incorrect";
    private static final String _MSG_REQUIRED_PRECEDING_UNDERSCORE = "preceding.underscore.required";
    private static final String _MSG_REQUIRED_STARTING_UPPERCASE = "starting.uppercase.required";

    public int[] getDefaultTokens() {
        return new int[]{9, 21, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Deprecated") || AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"DisplayName") || AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Meta.AD") || detailAST.getType() == 9 && AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Override")) {
            return;
        }
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        this._checkIncorrectCamelCase(detailAST, nameDetailAST, "non", "nonProxyHost", "nonSerializableObjectHandler", "nonSpringServlet");
        this._checkIncorrectCamelCase(detailAST, nameDetailAST, "re", "reCaptcha");
        this._checkIncorrectCamelCase(detailAST, nameDetailAST, "sub", "subSelect");
        this._checkRequiredCamelCase(detailAST, nameDetailAST, "name", "filenameFilter", "hostname", "nickname", "rename", "subname");
    }

    private void _checkIncorrectCamelCase(DetailAST detailAST, DetailAST nameDetailAST, String s, String ... allowedNames) {
        String name = nameDetailAST.getText();
        if (this._isAllowedName(name, allowedNames)) {
            return;
        }
        Pattern pattern = Pattern.compile(StringBundler.concat("(^_?", s, "|", TextFormatter.format(s, 6), ")([A-Z]([a-z]*|[A-Z]*))"));
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            if (this._containsNameInAssignStatement(detailAST, s + matcher.group(2)) || this._containsMatchingTypeName(detailAST, name, pattern)) {
                return;
            }
            if (detailAST.getType() == 9) {
                this.log(nameDetailAST, _MSG_INCORRECT_FOLLOWING_UPPERCASE, new Object[]{s, "method", name});
            } else if (detailAST.getType() == 21) {
                this.log(nameDetailAST, _MSG_INCORRECT_FOLLOWING_UPPERCASE, new Object[]{s, "parameter", name});
            } else {
                this.log(nameDetailAST, _MSG_INCORRECT_FOLLOWING_UPPERCASE, new Object[]{s, "variable", name});
            }
        }
        if (detailAST.getType() != 10) {
            return;
        }
        pattern = Pattern.compile(StringBundler.concat("(\\A|_)(", StringUtil.toUpperCase(s), "_[A-Z]+)"));
        matcher = pattern.matcher(name);
        if (matcher.find() && !this._containsNameInAssignStatement(detailAST, matcher.group(2))) {
            this.log(nameDetailAST, _MSG_INCORRECT_FOLLOWING_UNDERSCORE, new Object[]{StringUtil.toUpperCase(s), name});
        }
    }

    private void _checkRequiredCamelCase(DetailAST detailAST, DetailAST nameDetailAST, String s, String ... allowedNames) {
        String name = nameDetailAST.getText();
        if (this._isAllowedName(name, allowedNames)) {
            return;
        }
        Pattern pattern = Pattern.compile("(((\\A|_)[a-z]+|[A-Z]([A-Z]+|[a-z]+))" + s + ")");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            if (this._containsNameInAssignStatement(detailAST, matcher.group(1)) || this._containsMatchingTypeName(detailAST, name, pattern)) {
                return;
            }
            if (detailAST.getType() == 9) {
                this.log(nameDetailAST, _MSG_REQUIRED_STARTING_UPPERCASE, new Object[]{s, "method", name});
            } else if (detailAST.getType() == 21) {
                this.log(nameDetailAST, _MSG_REQUIRED_STARTING_UPPERCASE, new Object[]{s, "parameter", name});
            } else {
                this.log(nameDetailAST, _MSG_REQUIRED_STARTING_UPPERCASE, new Object[]{s, "variable", name});
            }
        }
        if (detailAST.getType() != 10) {
            return;
        }
        pattern = Pattern.compile(StringBundler.concat("(\\A|_)([A-Z]+", StringUtil.toUpperCase(s), ").*"));
        matcher = pattern.matcher(name);
        if (matcher.find() && !this._containsNameInAssignStatement(detailAST, matcher.group(2))) {
            this.log(nameDetailAST, _MSG_REQUIRED_PRECEDING_UNDERSCORE, new Object[]{StringUtil.toUpperCase(s), name});
        }
    }

    private boolean _containsMatchingTypeName(DetailAST detailAST, String name, Pattern pattern) {
        Matcher matcher;
        if (detailAST.getType() == 21 || detailAST.getType() == 10) {
            Matcher matcher2 = pattern.matcher(this.getVariableTypeName(detailAST, name, false));
            return matcher2.find();
        }
        String returnTypeName = this.getTypeName(detailAST, false);
        if (!returnTypeName.equals("void") && (matcher = pattern.matcher(returnTypeName)).find()) {
            return true;
        }
        DetailAST parametersDetailAST = detailAST.findFirstToken(20);
        List<DetailAST> parameterDetailASTList = this.getAllChildTokens(parametersDetailAST, false, 21);
        for (DetailAST parameterDetailAST : parameterDetailASTList) {
            Matcher matcher3 = pattern.matcher(this.getTypeName(parameterDetailAST, false));
            if (!matcher3.find()) continue;
            return true;
        }
        return false;
    }

    private boolean _containsNameInAssignStatement(DetailAST detailAST, String name) {
        DetailAST assignDetailAST = detailAST.findFirstToken(80);
        if (assignDetailAST == null) {
            return false;
        }
        String constantFormatName = this._getConstantFormatName(name);
        String lowerCaseCamelCaseFormatName = this._getCamelCaseFormatName(name);
        String upperCaseCamelCaseFormatName = TextFormatter.format(lowerCaseCamelCaseFormatName, 6);
        List<DetailAST> stringLiteralDetailASTlist = this.getAllChildTokens(assignDetailAST, true, 139);
        if (!stringLiteralDetailASTlist.isEmpty()) {
            if (lowerCaseCamelCaseFormatName == null) {
                return false;
            }
            String propertyFormatName = this._getPropertyFormatName(lowerCaseCamelCaseFormatName);
            for (DetailAST stringLiteralDetailAST : stringLiteralDetailASTlist) {
                String text = stringLiteralDetailAST.getText();
                if (!text.contains(constantFormatName) && !text.contains(lowerCaseCamelCaseFormatName) && !text.contains(name) && !text.contains(propertyFormatName) && !text.contains(upperCaseCamelCaseFormatName)) continue;
                return true;
            }
        }
        for (String text : this.getNames(assignDetailAST, true)) {
            if (!text.contains(constantFormatName) && !text.contains(lowerCaseCamelCaseFormatName) && !text.contains(name) && !text.contains(upperCaseCamelCaseFormatName)) continue;
            return true;
        }
        return false;
    }

    private String _getCamelCaseFormatName(String name) {
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        if (!StringUtil.isUpperCase(name)) {
            return TextFormatter.format(name, 8);
        }
        name = TextFormatter.format(name, 14);
        name = StringUtil.toLowerCase(name);
        return TextFormatter.format(name, 12);
    }

    private String _getConstantFormatName(String name) {
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        if (StringUtil.isUpperCase(name)) {
            return name;
        }
        name = TextFormatter.format(name, 10);
        name = TextFormatter.format(name, 13);
        return StringUtil.toUpperCase(name);
    }

    private String _getPropertyFormatName(String camelCaseName) {
        String propertyFormatName = TextFormatter.format(camelCaseName, 10);
        return StringUtil.replace(propertyFormatName, '-', '.');
    }

    private boolean _isAllowedName(String name, String[] allowedNames) {
        for (String allowedName : allowedNames) {
            if (name.startsWith(allowedName) || name.startsWith("_" + allowedName) || name.contains(TextFormatter.format(allowedName, 6))) {
                return true;
            }
            String constantFormatName = this._getConstantFormatName(allowedName);
            if (!name.startsWith(constantFormatName) && !name.contains("_" + constantFormatName)) continue;
            return true;
        }
        return false;
    }
}

