/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPExpressionTagCheck
extends BaseFileCheck {
    private static final Pattern _jspExpressionTagPattern = Pattern.compile("(?<!')<%=(.+?)%>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _jspExpressionTagPattern.matcher(content);
        while (matcher.find()) {
            String jspExpressionTag = matcher.group();
            if (jspExpressionTag.contains(":") && jspExpressionTag.contains("?") || this.getLevel(jspExpressionTag, "(", ")") != 0) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(this._formatJspExpressionTag(matcher.group(1))));
        }
        if (sb.length() > 0) {
            matcher.appendTail(sb);
            return sb.toString();
        }
        return content;
    }

    private String _formatJspExpressionTag(String expression) {
        int startPosition;
        ArrayList<String> operandList = new ArrayList<String>();
        int x = startPosition = 0;
        while ((x = expression.indexOf("+", x)) != -1) {
            char c;
            if (ToolsUtil.isInsideQuotes(expression, x)) {
                ++x;
                continue;
            }
            if (x < expression.length() - 1 && (c = expression.charAt(x + 1)) == '+') {
                ++x;
                continue;
            }
            if (x > 0 && (c = expression.charAt(x - 1)) == '+') {
                ++x;
                continue;
            }
            String operand = expression.substring(startPosition, x);
            if (this.getLevel(operand, "(", ")") != 0) {
                ++x;
                continue;
            }
            operandList.add(operand.trim());
            startPosition = ++x;
        }
        operandList.add(StringUtil.trim(expression.substring(startPosition)));
        StringBundler sb = new StringBundler();
        String previousOperand = null;
        for (String operand : operandList) {
            if (operand.startsWith("\"")) {
                if (Validator.isNotNull(previousOperand) && !previousOperand.startsWith("\"")) {
                    sb.append(" %>");
                }
                sb.append(StringUtil.unquote(operand));
            } else {
                if (Validator.isNotNull(previousOperand)) {
                    if (!previousOperand.startsWith("\"")) {
                        sb.append(" + ");
                    } else {
                        sb.append("<%= ");
                    }
                } else {
                    sb.append("<%= ");
                }
                sb.append(operand);
            }
            previousOperand = operand;
        }
        if (!previousOperand.startsWith("\"")) {
            sb.append(" %>");
        }
        return sb.toString();
    }
}

