/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSwitchCheck
extends BaseFileCheck {
    private static final Pattern _switchStatementPattern = Pattern.compile("\tswitch \\(.*\\) \\{");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _switchStatementPattern.matcher(content);
        while (matcher.find()) {
            this.addMessage(fileName, "Use 'if/else' statement instead of 'switch'", this.getLineNumber(content, matcher.start()));
        }
        return content;
    }
}

