/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesFeatureFlagsCheck
extends BaseFileCheck {
    private static final Pattern _featureFlagPattern1 = Pattern.compile("\"feature\\.flag\\.(.+?)\"");
    private static final Pattern _featureFlagPattern2 = Pattern.compile("\\.feature\\.flag=(.+?)\"");
    private static final Pattern _featureFlagsPattern = Pattern.compile("(\n|\\A)##\n## Feature Flag\n##(\n\n[\\s\\S]*?)(?=(\n\n##|\\Z))");
    private List<String> _allFileNames;

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("portal.properties")) {
            return content;
        }
        return this._generateFeatureFlags(content);
    }

    private String _generateFeatureFlags(String content) throws IOException {
        ArrayList<String> featureFlags = new ArrayList<String>();
        List<String> fileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, new String[]{"**/test/**"}, new String[]{"**/bnd.bnd", "**/*.java"}, this.getSourceFormatterExcludes(), true);
        for (String fileName : fileNames) {
            fileName = StringUtil.replace(fileName, '\\', '/');
            String fileContent = FileUtil.read(new File(fileName));
            if (fileName.endsWith("bnd.bnd")) {
                String liferaySiteInitializerFeatureFlag = BNDSourceUtil.getDefinitionValue(fileContent, "Liferay-Site-Initializer-Feature-Flag");
                if (liferaySiteInitializerFeatureFlag == null) continue;
                featureFlags.add(liferaySiteInitializerFeatureFlag);
                continue;
            }
            if (!fileContent.contains("feature.flag")) continue;
            featureFlags.addAll(this._getFeatureFlags(fileContent, _featureFlagPattern1));
            featureFlags.addAll(this._getFeatureFlags(fileContent, _featureFlagPattern2));
        }
        ListUtil.distinct(featureFlags, new NaturalOrderStringComparator());
        Matcher matcher = _featureFlagsPattern.matcher(content);
        if (matcher.find()) {
            String matchedFeatureFlags = matcher.group(2);
            if (featureFlags.isEmpty()) {
                if (matchedFeatureFlags.contains("feature.flag.")) {
                    return StringUtil.replaceFirst(content, matchedFeatureFlags, "", matcher.start(2));
                }
                return content;
            }
            StringBundler sb = new StringBundler(featureFlags.size() * 14);
            for (String featureFlag : featureFlags) {
                featureFlag = "feature.flag." + featureFlag;
                String environmentVariable = ToolsUtil.encodeEnvironmentProperty(featureFlag);
                sb.append("\n");
                sb.append("\n");
                sb.append("    ");
                sb.append("#");
                sb.append("\n");
                sb.append("    # Env: ");
                sb.append(environmentVariable);
                sb.append("\n");
                sb.append("    ");
                sb.append("#");
                sb.append("\n");
                sb.append("    ");
                sb.append(featureFlag);
                sb.append("=false");
            }
            content = matchedFeatureFlags.contains("feature.flag.") ? StringUtil.replaceFirst(content, matchedFeatureFlags, sb.toString(), matcher.start(2)) : StringUtil.insert(content, sb.toString(), matcher.start(2));
        }
        return content;
    }

    private List<String> _getFeatureFlags(String content, Pattern pattern) {
        ArrayList<String> featureFlags = new ArrayList<String>();
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            featureFlags.add(matcher.group(1));
        }
        return featureFlags;
    }
}

