/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.processor;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.tools.java.parser.JavaParser;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checkstyle.util.CheckstyleLogger;
import com.liferay.source.formatter.checkstyle.util.CheckstyleUtil;
import com.liferay.source.formatter.processor.BaseSourceProcessor;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.PortalJSONObjectUtil;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class JavaSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.java"};
    private Configuration _checkstyleConfiguration;
    private CheckstyleLogger _checkstyleLogger;
    private final Set<SourceFormatterMessage> _sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
    private final List<File> _ungeneratedFiles = new ArrayList<File>();

    @Override
    protected List<String> doGetFileNames() throws IOException {
        Object[] includes = this.getIncludes();
        if (ArrayUtil.isEmpty(includes)) {
            return new ArrayList<String>();
        }
        Collection<String> fileNames = null;
        fileNames = this.isPortalSource() || this.isSubrepository() ? this._getPortalJavaFiles((String[])includes) : this._getPluginJavaFiles((String[])includes);
        return new ArrayList<String>(fileNames);
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected File format(File file, String fileName, String absolutePath, String content) throws Exception {
        file = super.format(file, fileName, absolutePath, content);
        this._processCheckstyle(file);
        return file;
    }

    @Override
    protected String parse(File file, String fileName, String content, Set<String> modifiedMessages) throws Exception {
        SourceFormatterArgs sourceFormatterArgs = this.getSourceFormatterArgs();
        String newContent = JavaParser.parse(file, content, sourceFormatterArgs.getMaxLineLength(), false);
        if (!content.equals(newContent)) {
            modifiedMessages.add(file.toString() + " (JavaParser)");
            if (sourceFormatterArgs.isShowDebugInformation()) {
                DebugUtil.printContentModifications("JavaParser", fileName, content, newContent);
            }
        }
        return newContent;
    }

    @Override
    protected void postFormat() throws Exception {
        this._processCheckstyle(this._ungeneratedFiles.toArray(new File[0]));
        this._ungeneratedFiles.clear();
        for (SourceFormatterMessage sourceFormatterMessage : this._sourceFormatterMessages) {
            String fileName = sourceFormatterMessage.getFileName();
            this.processMessage(fileName, sourceFormatterMessage);
            this.printError(fileName, sourceFormatterMessage.toString());
        }
        PortalJSONObjectUtil.deleteTempPortalJSONObjectFile();
    }

    @Override
    protected void preFormat() throws CheckstyleException {
        SourceFormatterArgs sourceFormatterArgs = this.getSourceFormatterArgs();
        this._checkstyleLogger = new CheckstyleLogger(sourceFormatterArgs.getBaseDirName());
        this._checkstyleConfiguration = CheckstyleUtil.getConfiguration("checkstyle.xml", this.getPropertiesMap(), sourceFormatterArgs);
    }

    private String[] _getPluginExcludes(String pluginDirectoryName) {
        return new String[]{pluginDirectoryName + "**/model/*Clp.java", pluginDirectoryName + "**/model/impl/*BaseImpl.java", pluginDirectoryName + "**/model/impl/*Model.java", pluginDirectoryName + "**/model/impl/*ModelImpl.java", pluginDirectoryName + "**/service/**/service/*Service.java", pluginDirectoryName + "**/service/**/service/*ServiceClp.java", pluginDirectoryName + "**/service/**/service/*ServiceFactory.java", pluginDirectoryName + "**/service/**/service/*ServiceUtil.java", pluginDirectoryName + "**/service/**/service/*ServiceWrapper.java", pluginDirectoryName + "**/service/**/service/ClpSerializer.java", pluginDirectoryName + "**/service/**/service/messaging/*ClpMessageListener.java", pluginDirectoryName + "**/service/**/service/persistence/*Finder.java", pluginDirectoryName + "**/service/**/service/persistence/*Util.java", pluginDirectoryName + "**/service/base/*ServiceBaseImpl.java", pluginDirectoryName + "**/service/base/*ServiceClpInvoker.java", pluginDirectoryName + "**/service/http/*JSONSerializer.java", pluginDirectoryName + "**/service/http/*ServiceHttp.java", pluginDirectoryName + "**/service/http/*ServiceJSON.java", pluginDirectoryName + "**/service/http/*ServiceSoap.java", pluginDirectoryName + "**/tools/templates/**"};
    }

    private Collection<String> _getPluginJavaFiles(String[] includes) throws IOException {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = this._getPluginExcludes("");
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    private Collection<String> _getPortalJavaFiles(String[] includes) throws IOException {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = new String[]{"**/*_IW.java", "**/*_jsp.java", "**/counter/service/**", "**/model/impl/*Model.java", "**/model/impl/*ModelImpl.java", "**/portal/service/**", "**/portal-web/test/**/*Test.java", "**/test/*-generated/**"};
        for (String directoryName : this.getPluginsInsideModulesDirectoryNames()) {
            excludes = ArrayUtil.append(excludes, this._getPluginExcludes("**" + directoryName));
        }
        fileNames.addAll(this.getFileNames(excludes, includes));
        excludes = new String[]{"**/tools/ext_tmpl/**", "**/*_IW.java", "**/test/**/*PersistenceTest.java"};
        includes = new String[]{"**/com/liferay/portal/kernel/service/ServiceContext*.java", "**/model/BaseModel.java", "**/model/impl/BaseModelImpl.java", "**/portal-test/**/portal/service/**/*.java", "**/portal-test-integration/**/portal/service/**/*.java", "**/service/*.java", "**/service/configuration/**/*.java", "**/service/http/*HttpTest.java", "**/service/http/*SoapTest.java", "**/service/http/TunnelUtil.java", "**/service/impl/*.java", "**/service/jms/*.java", "**/service/permission/*.java", "**/service/persistence/BasePersistence.java", "**/service/persistence/BatchSession*.java", "**/service/persistence/*FinderImpl.java", "**/service/persistence/*Query.java", "**/service/persistence/impl/*.java", "**/portal-impl/test/**/*.java", "**/util-bridges/**/*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    private synchronized void _processCheckstyle(File file) throws Exception {
        this._ungeneratedFiles.add(file);
        if (this._ungeneratedFiles.size() == 1000) {
            this._processCheckstyle(this._ungeneratedFiles.toArray(new File[0]));
            this._ungeneratedFiles.clear();
        }
    }

    private void _processCheckstyle(File[] files) throws Exception {
        if (ArrayUtil.isEmpty(files)) {
            return;
        }
        this._sourceFormatterMessages.addAll(this.processCheckstyle(this._checkstyleConfiguration, this._checkstyleLogger, files));
    }
}

