/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.upgrade;

import com.liferay.source.formatter.upgrade.GradleBuildFileVisitor;
import com.liferay.source.formatter.upgrade.GradleDependency;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.control.CompilePhase;

public class GradleBuildFile {
    private String _source;

    public GradleBuildFile(String source) {
        this._source = source;
    }

    public void deleteGradleDependencies(List<GradleDependency> gradleDependencies) {
        List<String> sourceLines = this.getSourceLines();
        gradleDependencies.sort(GradleDependency.COMPARATOR_LAST_LINE_NUMBER_DESC);
        for (GradleDependency gradleDependency : gradleDependencies) {
            int lastLineNumber;
            int lineNumber = gradleDependency.getLineNumber();
            for (int i = lastLineNumber = gradleDependency.getLastLineNumber(); i >= lineNumber; --i) {
                sourceLines.remove(i - 1);
            }
        }
        this._saveSource(sourceLines);
    }

    public void deleteGradleDependency(String group, String name) {
        this.deleteGradleDependency(null, group, name);
    }

    public void deleteGradleDependency(String configuration, String group, String name) {
        List<String> sourceLines = this.getSourceLines();
        List<GradleDependency> gradleDependencies = this.getGradleDependencies();
        ListIterator<GradleDependency> listIterator = gradleDependencies.listIterator(gradleDependencies.size());
        while (listIterator.hasPrevious()) {
            GradleDependency gradleDependency = listIterator.previous();
            if (configuration != null && !Objects.equals(configuration, gradleDependency.getConfiguration()) || !Objects.equals(group, gradleDependency.getGroup()) || !Objects.equals(name, gradleDependency.getName())) continue;
            for (int i = gradleDependency.getLastLineNumber(); i >= gradleDependency.getLineNumber(); --i) {
                sourceLines.remove(i - 1);
            }
        }
        this._saveSource(sourceLines);
    }

    public List<GradleDependency> getGradleDependencies() {
        GradleBuildFileVisitor gradleBuildFileVisitor = this._walkAST();
        return gradleBuildFileVisitor.getGradleDependencies();
    }

    public List<GradleDependency> getGradleDependencies(String configuration) {
        GradleBuildFileVisitor gradleBuildFileVisitor = this._walkAST();
        List<GradleDependency> gradleDependencies = gradleBuildFileVisitor.getGradleDependencies();
        Stream stream = gradleDependencies.stream();
        return stream.filter(gradleDependency -> Objects.equals(configuration, gradleDependency.getConfiguration())).collect(Collectors.toList());
    }

    public String getSource() {
        return this._source;
    }

    public List<String> getSourceLines() {
        return Stream.of(this._source.split(System.lineSeparator())).collect(Collectors.toList());
    }

    public void insertGradleDependency(GradleDependency gradleDependency) {
        GradleBuildFileVisitor gradleBuildFileVisitor = this._walkAST();
        for (GradleDependency currentGradleDependency : gradleBuildFileVisitor.getGradleDependencies()) {
            if (!currentGradleDependency.equals(gradleDependency)) continue;
            return;
        }
        List<String> sourceLines = this.getSourceLines();
        int dependenciesLastLineNumber = gradleBuildFileVisitor.getDependenciesLastLineNumber();
        if (dependenciesLastLineNumber == -1) {
            sourceLines.add("");
            sourceLines.add("dependencies {");
            sourceLines.add("\t" + gradleDependency.toString());
            sourceLines.add("}");
        } else {
            sourceLines.add(dependenciesLastLineNumber - 1, "\t" + gradleDependency.toString());
        }
        this._saveSource(sourceLines);
    }

    public void insertGradleDependency(String configuration, String group, String name) {
        this.insertGradleDependency(configuration, group, name, null);
    }

    public void insertGradleDependency(String configuration, String group, String name, String version) {
        this.insertGradleDependency(new GradleDependency(configuration, group, name, version));
    }

    private void _saveSource(List<String> lines) {
        Stream stream = lines.stream();
        this._source = stream.collect(Collectors.joining(System.lineSeparator()));
    }

    private GradleBuildFileVisitor _walkAST() {
        AstBuilder astBuilder = new AstBuilder();
        GradleBuildFileVisitor gradleBuildFileVisitor = new GradleBuildFileVisitor();
        for (ASTNode astNode : astBuilder.buildFromString(CompilePhase.CONVERSION, this._source)) {
            if (astNode instanceof ClassNode) continue;
            astNode.visit(gradleBuildFileVisitor);
        }
        return gradleBuildFileVisitor;
    }
}

