/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.upgrade;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Objects;

public class GradleDependency
implements Comparable<GradleDependency> {
    public static final Comparator<GradleDependency> COMPARATOR_LAST_LINE_NUMBER_DESC = Comparator.comparingInt(GradleDependency::getLastLineNumber).reversed();
    private final String _configuration;
    private final String _group;
    private final int _lastLineNumber;
    private final int _lineNumber;
    private final String _name;
    private final String _version;

    public GradleDependency(String configuration, String group, String name, String version) {
        this(configuration, group, name, version, -1, -1);
    }

    public GradleDependency(String configuration, String group, String name, String version, int lineNumber, int lastLineNumber) {
        this._configuration = configuration;
        this._group = group;
        this._name = name;
        this._version = version;
        this._lineNumber = lineNumber;
        this._lastLineNumber = lastLineNumber;
    }

    @Override
    public int compareTo(GradleDependency gradleDependency) {
        String string = this.toString();
        return string.compareTo(gradleDependency.toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GradleDependency)) {
            return false;
        }
        GradleDependency gradleDependency = (GradleDependency)object;
        return Objects.equals(this._configuration, gradleDependency._configuration) && Objects.equals(this._group, gradleDependency._group) && Objects.equals(this._name, gradleDependency._name);
    }

    public String getConfiguration() {
        return this._configuration;
    }

    public String getGroup() {
        return this._group;
    }

    public int getLastLineNumber() {
        return this._lastLineNumber;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public String getName() {
        return this._name;
    }

    public String getVersion() {
        return this._version;
    }

    public int hashCode() {
        return Objects.hash(this._configuration, this._group, this._name);
    }

    public String toString() {
        if (this._version == null) {
            return MessageFormat.format("{0} group: \"{1}\", name: \"{2}\"", this._configuration, this._group, this._name);
        }
        return MessageFormat.format("{0} group: \"{1}\", name: \"{2}\", version: \"{3}\"", this._configuration, this._group, this._name, this._version);
    }
}

