/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import java.util.List;

public class BNDLiferayRelengCategoryCheck
extends BaseFileCheck {
    private static final String _ALLOWED_LIFERAY_RELENG_CATEGORY_NAMES_KEY = "allowedLiferayRelengCategoryNames";

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!absolutePath.endsWith("/app.bnd")) {
            return content;
        }
        String liferayRelengCategory = BNDSourceUtil.getDefinitionValue(content, "Liferay-Releng-Category");
        if (Validator.isNull(liferayRelengCategory)) {
            return content;
        }
        List<String> allowedLiferayRelengCategoryNames = this.getAttributeValues(_ALLOWED_LIFERAY_RELENG_CATEGORY_NAMES_KEY, absolutePath);
        if (!allowedLiferayRelengCategoryNames.isEmpty() && !allowedLiferayRelengCategoryNames.contains(liferayRelengCategory)) {
            String message = StringBundler.concat("The value for 'Liferay-Releng-Category' can be either blank ", "or one of the following values '", StringUtil.merge(allowedLiferayRelengCategoryNames, ", "), "'");
            this.addMessage(fileName, message);
        }
        return content;
    }
}

