/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.util.List;

public class JavaProviderTypeAnnotationCheck
extends BaseJavaTermCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        String packageName;
        if (!javaTerm.hasAnnotation("ProviderType")) {
            return javaTerm.getContent();
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        if (!javaClass.isInterface() && !javaClass.isAbstract()) {
            return StringUtil.replaceFirst(javaTerm.getContent(), "@ProviderType\n", "");
        }
        if (javaClass.getParentJavaClass() != null) {
            return javaTerm.getContent();
        }
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        List<String> exportPackages = BNDSourceUtil.getDefinitionValues(bndSettings.getContent(), "Export-Package");
        if (exportPackages.contains(packageName = javaClass.getPackageName())) {
            return javaTerm.getContent();
        }
        int x = -1;
        do {
            if ((x = packageName.indexOf(".", x + 1)) != -1) continue;
            return StringUtil.replaceFirst(javaTerm.getContent(), "@ProviderType\n", "");
        } while (!exportPackages.contains(packageName.substring(0, x + 1) + "*"));
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }
}

