/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaResultSetCheck
extends BaseFileCheck {
    private static final Pattern _tryStatementPattern = Pattern.compile("\n(\t+)try [\\{\\(]");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _tryStatementPattern.matcher(content);
        while (matcher.find()) {
            int x = content.indexOf("\"select count(", matcher.start());
            if (x == -1) continue;
            int y = content.indexOf("resultSet.getLong(1)", matcher.start());
            int z = content.indexOf("\n" + matcher.group(1) + "}", matcher.start());
            if (y == -1 || z == -1 || x >= y || y >= z) continue;
            this.addMessage(fileName, "Use resultSet.getInt(1) for count", this.getLineNumber(content, y));
        }
        return content;
    }
}

