/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiAntCommandParametersOrderCheck
extends BaseFileCheck {
    private static final Pattern _antCommandCallPattern = Pattern.compile("\n\t+AntCommand\\((.*?)\\);\n", 32);
    private static final Pattern _parameterPattern = Pattern.compile(" -D[^=]+?=(\\\\\"|).+?\\1(?= |\\Z)");
    private static final Pattern _valuePattern = Pattern.compile("\t+value1 = \"(.+)\"\\);\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        ParameterNameComparator parameterNameComparator = new ParameterNameComparator();
        Matcher matcher1 = _antCommandCallPattern.matcher(content);
        while (matcher1.find()) {
            String antCommandCall = matcher1.group();
            if (this.getLevel(antCommandCall) != 0) continue;
            Matcher matcher2 = _valuePattern.matcher(antCommandCall);
            while (matcher2.find()) {
                Matcher matcher3 = _parameterPattern.matcher(matcher2.group(1));
                String previousParameter = null;
                while (matcher3.find()) {
                    int compare;
                    String paratemter = matcher3.group();
                    if (previousParameter != null && (compare = parameterNameComparator.compare(previousParameter, paratemter)) > 0) {
                        content = StringUtil.replaceFirst(content, paratemter, previousParameter, matcher1.start());
                        return StringUtil.replaceFirst(content, previousParameter, paratemter, matcher1.start());
                    }
                    previousParameter = paratemter;
                }
            }
        }
        return content;
    }

    private class ParameterNameComparator
    extends NaturalOrderStringComparator {
        private ParameterNameComparator() {
        }

        @Override
        public int compare(String parameter1, String parameter2) {
            return super.compare(this._getParamterName(parameter1), this._getParamterName(parameter2));
        }

        private String _getParamterName(String parameter) {
            int x = parameter.indexOf("=");
            return parameter.substring(0, x);
        }
    }
}

