/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLServiceAutoImportDefaultReferencesCheck
extends BaseFileCheck {
    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (!fileName.endsWith("/service.xml") || !absolutePath.contains("/modules/apps/") && !absolutePath.contains("/modules/dxp/apps/")) {
            return content;
        }
        if (absolutePath.contains("/modules/apps/archived/")) {
            return content;
        }
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        if (GetterUtil.getBoolean(rootElement.attributeValue("auto-import-default-references"), true)) {
            this.addMessage(fileName, "Attribute 'auto-import-default-references' should always be 'false' in service.xml");
        }
        return content;
    }
}

