/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLStylingCheck
extends BaseFileCheck {
    private static final Pattern _xmlDeclarationPattern = Pattern.compile("(\\A)<\\?xml .+?(?=\\Z|\n)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _xmlDeclarationPattern.matcher(content);
        if (matcher.find()) {
            String oldXmlDeclaration = matcher.group();
            String xmlDeclaration = StringUtil.replace(oldXmlDeclaration, " = ", "=");
            if (!oldXmlDeclaration.equals(xmlDeclaration = xmlDeclaration.replaceAll(" encoding=\"[^\"]*\"", ""))) {
                return StringUtil.replaceFirst(content, oldXmlDeclaration, xmlDeclaration);
            }
        }
        return content;
    }
}

