/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class ExceptionPrintStackTraceCheck
extends BaseCheck {
    private static final String _MSG_AVOID_METHOD_CALL = "method.call.avoid";

    public int[] getDefaultTokens() {
        return new int[]{96};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String absolutePath = this.getAbsolutePath();
        if (absolutePath.contains("/modules/sdk/") || absolutePath.contains("/modules/util/") || absolutePath.contains("/test/") || absolutePath.contains("/testIntegration/") || absolutePath.endsWith("Jdk14LogFactoryImpl.java")) {
            return;
        }
        DetailAST parameterDefinitionDetailAST = detailAST.findFirstToken(21);
        String exceptionVariableName = this.getName(parameterDefinitionDetailAST);
        String variableTypeName = this.getVariableTypeName(detailAST, exceptionVariableName, false);
        if (variableTypeName == null || !variableTypeName.endsWith("Exception")) {
            return;
        }
        List<DetailAST> methodCallDetailASTList = this.getMethodCalls(detailAST, exceptionVariableName, "printStackTrace");
        if (methodCallDetailASTList.isEmpty()) {
            return;
        }
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            DetailAST parameterDetailAST = this.getParameterDetailAST(methodCallDetailAST);
            if (parameterDetailAST != null) continue;
            this.log(methodCallDetailAST, _MSG_AVOID_METHOD_CALL, new Object[0]);
        }
    }
}

