/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class EchoPoshiElement
extends PoshiElement {
    private static final String _ELEMENT_NAME = "echo";
    private static final String _POSHI_SCRIPT_KEYWORD = "echo";
    private static final Pattern _statementPattern = Pattern.compile("^echo\\(.*\\);$");

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType("echo", element)) {
            return new EchoPoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(poshiScript)) {
            return new EchoPoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        String parentheticalContent = this.getParentheticalContent(poshiScript);
        if (!this.isQuotedContent(parentheticalContent)) {
            this.addAttribute("message", parentheticalContent);
        } else {
            String content = this.getDoubleQuotedContent(poshiScript);
            this.addAttribute("message", content);
        }
    }

    @Override
    public String toPoshiScript() {
        String message = this.attributeValue("message");
        return this.createPoshiScriptSnippet(message);
    }

    protected EchoPoshiElement() {
        this("echo");
    }

    protected EchoPoshiElement(Element element) {
        super("echo", element);
    }

    protected EchoPoshiElement(List<Attribute> attributes, List<Node> nodes) {
        this("echo", attributes, nodes);
    }

    protected EchoPoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super("echo", parentPoshiElement, poshiScript);
    }

    protected EchoPoshiElement(String name) {
        super(name);
    }

    protected EchoPoshiElement(String name, Element element) {
        super(name, element);
    }

    protected EchoPoshiElement(String elementName, List<Attribute> attributes, List<Node> nodes) {
        super(elementName, attributes, nodes);
    }

    protected EchoPoshiElement(String name, PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(name, parentPoshiElement, poshiScript);
    }

    @Override
    protected String createPoshiScriptSnippet(String content) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n");
        sb.append(this.getPad());
        sb.append(this.getBlockName());
        sb.append("(");
        if (this.isQuotedContent(content)) {
            sb.append("\"");
            sb.append(content);
            sb.append("\"");
        } else {
            sb.append(content);
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    protected String getBlockName() {
        return "echo";
    }

    private boolean _isElementType(String poshiScript) {
        return this.isValidPoshiScriptStatement(_statementPattern, poshiScript);
    }
}

