/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.AndPoshiElement;
import com.liferay.poshi.core.elements.OrPoshiElement;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class EqualsPoshiElement
extends PoshiElement {
    private static final String _ELEMENT_NAME = "equals";
    private static final Pattern _conditionPattern = Pattern.compile("^[\\(]*(?:\\d+|(?:\\$\\{|\\\")[\\s\\S]*(?:\\}|\"))[\\s]*==[\\s]*(?:\\d+|(?:\\$\\{|\\\")[\\s\\S]*(?:\\}|\"))[\\)]*$");

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType(_ELEMENT_NAME, element)) {
            return new EqualsPoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(parentPoshiElement, poshiScript)) {
            return new EqualsPoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        String[] equalsContentArray;
        String arg1;
        if (poshiScript.startsWith("(") && poshiScript.endsWith(")")) {
            poshiScript = poshiScript.substring(1, poshiScript.length() - 1);
        }
        if (this.isQuotedContent(arg1 = (equalsContentArray = poshiScript.split("=="))[0].trim())) {
            arg1 = this.getDoubleQuotedContent(arg1);
        }
        this.addAttribute("arg1", arg1);
        String arg2 = equalsContentArray[1].trim();
        if (this.isQuotedContent(arg2)) {
            arg2 = this.getDoubleQuotedContent(arg2);
        }
        this.addAttribute("arg2", arg2);
    }

    @Override
    public String toPoshiScript() {
        StringBuilder sb = new StringBuilder();
        String arg1 = this.attributeValue("arg1");
        String arg2 = this.attributeValue("arg2");
        if (this.isQuotedContent(arg1)) {
            arg1 = "\"" + arg1 + "\"";
        }
        sb.append(arg1);
        sb.append(" == ");
        if (this.isQuotedContent(arg2)) {
            arg2 = "\"" + arg2 + "\"";
        }
        sb.append(arg2);
        PoshiElement parentPoshiElement = (PoshiElement)this.getParent();
        if (parentPoshiElement instanceof AndPoshiElement || parentPoshiElement instanceof OrPoshiElement) {
            sb.insert(0, "(");
            sb.append(")");
        }
        return sb.toString();
    }

    protected EqualsPoshiElement() {
        super(_ELEMENT_NAME);
    }

    protected EqualsPoshiElement(Element element) {
        super(_ELEMENT_NAME, element);
    }

    protected EqualsPoshiElement(List<Attribute> attributes, List<Node> nodes) {
        super(_ELEMENT_NAME, attributes, nodes);
    }

    protected EqualsPoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(_ELEMENT_NAME, parentPoshiElement, poshiScript);
    }

    @Override
    protected String getBlockName() {
        return _ELEMENT_NAME;
    }

    @Override
    protected Pattern getConditionPattern() {
        return _conditionPattern;
    }

    private boolean _isElementType(PoshiElement parentPoshiElement, String poshiScript) {
        if (this.isConditionElementType(parentPoshiElement, poshiScript)) {
            List<String> nestedConditions = this.getNestedConditions(poshiScript, "||");
            if (nestedConditions.size() > 1) {
                return false;
            }
            nestedConditions = this.getNestedConditions(poshiScript, "&&");
            return nestedConditions.size() <= 1;
        }
        return false;
    }
}

