/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.AndPoshiElement;
import com.liferay.poshi.core.elements.EqualsPoshiElement;
import com.liferay.poshi.core.elements.OrPoshiElement;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class NotPoshiElement
extends PoshiElement {
    private static final String _ELEMENT_NAME = "not";
    private static final Pattern _conditionPattern = Pattern.compile("^(![\\s\\S]*|(?:\\d+|(?:\\$\\{|\\\")[\\s\\S]*(?:\\}|\"))[\\s]*!=[\\s]*[\\s\\S]*(?:\\d+|(?:\\}|\")))$");

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType(_ELEMENT_NAME, element)) {
            return new NotPoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(parentPoshiElement, poshiScript)) {
            return new NotPoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        if (poshiScript.contains("!=")) {
            List<String> nestedConditions = this.getNestedConditions(poshiScript, "!=");
            poshiScript = nestedConditions.get(0) + "==" + nestedConditions.get(1);
        } else {
            poshiScript = this.getParentheticalContent(poshiScript);
        }
        this.add(PoshiNodeFactory.newPoshiNode(this, poshiScript));
    }

    @Override
    public String toPoshiScript() {
        StringBuilder sb = new StringBuilder();
        for (PoshiElement poshiElement : this.toPoshiElements(this.elements())) {
            if (poshiElement instanceof EqualsPoshiElement) {
                PoshiElement parentPoshiElement = (PoshiElement)this.getParent();
                if (parentPoshiElement instanceof AndPoshiElement || parentPoshiElement instanceof OrPoshiElement) {
                    sb.append("(");
                    sb.append(this._toNotEqualsPoshiScript((EqualsPoshiElement)poshiElement));
                    sb.append(")");
                    continue;
                }
                sb.append(this._toNotEqualsPoshiScript((EqualsPoshiElement)poshiElement));
                continue;
            }
            sb.append("!(");
            sb.append(poshiElement.toPoshiScript());
            sb.append(")");
        }
        return sb.toString();
    }

    protected NotPoshiElement() {
        super(_ELEMENT_NAME);
    }

    protected NotPoshiElement(Element element) {
        super(_ELEMENT_NAME, element);
    }

    protected NotPoshiElement(List<Attribute> attributes, List<Node> nodes) {
        super(_ELEMENT_NAME, attributes, nodes);
    }

    protected NotPoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(_ELEMENT_NAME, parentPoshiElement, poshiScript);
    }

    @Override
    protected String getBlockName() {
        return _ELEMENT_NAME;
    }

    @Override
    protected Pattern getConditionPattern() {
        return _conditionPattern;
    }

    private boolean _isElementType(PoshiElement parentPoshiElement, String poshiScript) {
        return this.isConditionElementType(parentPoshiElement, poshiScript);
    }

    private String _toNotEqualsPoshiScript(EqualsPoshiElement equalsPoshiElement) {
        StringBuilder sb = new StringBuilder();
        String arg1 = equalsPoshiElement.attributeValue("arg1");
        if (this.isQuotedContent(arg1)) {
            arg1 = "\"" + arg1 + "\"";
        }
        sb.append(arg1);
        sb.append(" != ");
        String arg2 = equalsPoshiElement.attributeValue("arg2");
        if (this.isQuotedContent(arg2)) {
            arg2 = "\"" + arg2 + "\"";
        }
        sb.append(arg2);
        return sb.toString();
    }
}

