/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.pql;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class PQLModifier {
    private static final Set<String> _availableModifiers = new HashSet<String>(Arrays.asList("NOT"));
    private final String _modifier;

    public static Set<String> getAvailableModifiers() {
        return _availableModifiers;
    }

    public static void validateModifier(String modifier) throws Exception {
        if (modifier == null || !_availableModifiers.contains(modifier)) {
            throw new Exception("Invalid modifier: " + modifier);
        }
    }

    public PQLModifier(String modifier) throws Exception {
        PQLModifier.validateModifier(modifier);
        this._modifier = modifier;
    }

    public String getModifier() {
        return this._modifier;
    }

    public abstract Object getPQLResult(Object var1) throws Exception;
}

