/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDWebContextPathCheck
extends BaseFileCheck {
    private static final Pattern _jsonNamePattern = Pattern.compile("\n\\s*['\"]name['\"]:");

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (fileName.endsWith("/bnd.bnd") && !this.isModulesApp(absolutePath, true) && !absolutePath.contains("/testIntegration/") && !absolutePath.contains("/third-party/")) {
            this._checkWebContextPath(fileName, absolutePath, content);
        }
        return content;
    }

    private void _checkWebContextPath(String fileName, String absolutePath, String content) throws IOException {
        String moduleName = BNDSourceUtil.getModuleName(absolutePath);
        if (moduleName.contains("-import-") || moduleName.contains("-private-")) {
            return;
        }
        String webContextPath = BNDSourceUtil.getDefinitionValue(content, "Web-ContextPath");
        if (this._hasPackageJSONNameProperty(absolutePath)) {
            if (webContextPath == null) {
                this.addMessage(fileName, "Missing Web-ContextPath");
            }
        } else if (webContextPath != null && !webContextPath.equals("/" + moduleName)) {
            this.addMessage(fileName, "Incorrect Web-ContextPath '" + webContextPath + "'");
        }
    }

    private boolean _hasPackageJSONNameProperty(String absolutePath) throws IOException {
        int pos = absolutePath.lastIndexOf("/");
        File file = new File(absolutePath.substring(0, pos + 1) + "package.json");
        if (!file.exists()) {
            return false;
        }
        String content = FileUtil.read(file);
        Matcher matcher = _jsonNamePattern.matcher(content);
        while (matcher.find()) {
            if (this.getLevel(content.substring(0, matcher.start()), "{", "}") != 1) continue;
            return true;
        }
        return false;
    }
}

