/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiIndentationCheck
extends BaseFileCheck {
    private static final Pattern _curlPattern = Pattern.compile("(?<=\n)\t*var \\w*curl = '''(\n.*?\n[ \t]*)''';(?=\n)", 34);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _curlPattern.matcher(content);
        while (matcher.find()) {
            if (StringUtil.contains(matcher.group(1), "'''")) continue;
            String match = matcher.group();
            String[] lines = match.split("\n");
            int leadingTabCount = this.getLeadingTabCount(lines[0]);
            lines[1] = this._fixTabs(leadingTabCount + 1, lines[1]);
            lines[lines.length - 1] = this._fixTabs(leadingTabCount, lines[lines.length - 1]);
            int level = leadingTabCount + 2;
            for (int i = 2; i < lines.length - 1; ++i) {
                Object trimmedLine = StringUtil.trim(lines[i]);
                lines[i] = this._fixTabs(level, (String)trimmedLine);
                trimmedLine = ((String)trimmedLine).replaceAll("(.*?)\\$\\{.*?\\}(.*)", "$1$2");
                level += this.getLevel((String)trimmedLine, "[{", "}]");
                trimmedLine = StringUtil.removeSubstrings((String)trimmedLine, "[{", "}]");
                level += this.getLevel((String)trimmedLine, new String[]{"[", "{"}, new String[]{"]", "}"});
                if (!((String)trimmedLine).endsWith("'{")) continue;
                ++level;
            }
            StringBundler sb = new StringBundler(lines.length * 2);
            for (String line : lines) {
                if (!Validator.isNotNull(line.trim())) continue;
                sb.append(line);
                sb.append('\n');
            }
            sb.setIndex(sb.index() - 1);
            String replacement = sb.toString();
            if (match.equals(replacement)) continue;
            return StringUtil.replaceFirst(content, match, replacement, matcher.start());
        }
        return content;
    }

    private String _fixTabs(int expectedTabCount, String line) {
        if (line.equals("]") || line.equals("]'") || line.equals("],") || line.equals("}") || line.equals("}'") || line.equals("},") || line.equals("}]") || line.equals("}]'") || line.equals("}],")) {
            --expectedTabCount;
        }
        StringBundler sb = new StringBundler(expectedTabCount + 1);
        for (int i = 0; i < expectedTabCount; ++i) {
            sb.append('\t');
        }
        sb.append(StringUtil.trim(line));
        return sb.toString();
    }
}

