/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class UpgradeVelocityCommentMigrationCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith(".vm")) {
            return content;
        }
        int periodIndex = fileName.lastIndexOf(".");
        int slashIndex = fileName.lastIndexOf("/");
        File file = new File(StringBundler.concat(fileName.substring(0, slashIndex), "/migrated/", fileName.substring(slashIndex + 1, periodIndex), ".ftl"));
        if (file.length() != 0L) {
            content = FileUtil.read(file);
        }
        content = this._formatContent(content);
        FileUtil.write(file, content);
        return content;
    }

    private String _formatContent(String content) {
        String[] lines;
        for (String line : lines = content.split("\n")) {
            if (!line.contains("##") || line.length() == 2) continue;
            String newComment = line.replace("##", "<#--") + " -->";
            if (newComment.contains("Velocity Transform Template")) {
                newComment = StringUtil.replace(newComment, "Velocity Transform Template", "FreeMarker Template");
            }
            content = StringUtil.replace(content, line, newComment);
        }
        return StringUtil.removeSubstring(content, "##");
    }
}

