/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.List;

public class UpgradeProcessCheck
extends BaseCheck {
    private static final String[] _ALTER_METHOD_NAMES = new String[]{"alterColumnName", "alterColumnType", "alterTableAddColumn", "alterTableDropColumn"};
    private static final String _MSG_MOVE_UPGRADE_STEP_INSIDE_POST_UPGRADE_STEPS = "upgrade.step.move.inside.post.upgrade.steps";
    private static final String _MSG_MOVE_UPGRADE_STEP_INSIDE_PRE_UPGRADE_STEPS = "upgrade.step.move.inside.pre.upgrade.steps";
    private static final String _MSG_UNNECESSARY_CLASS = "class.unnecessary";
    private static final String _MSG_UNNECESSARY_IF_STATEMENT = "if.statement.unnecessary";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null || !this._isUpgradeProcess(detailAST)) {
            return;
        }
        for (DetailAST literalIfDetailAST : this.getAllChildTokens(detailAST, true, 83)) {
            if (!this._isUnnecessaryIfStatement(literalIfDetailAST)) continue;
            this.log(literalIfDetailAST, _MSG_UNNECESSARY_IF_STATEMENT, new Object[0]);
            return;
        }
        String absolutePath = this.getAbsolutePath();
        if (absolutePath.contains("/portal-impl/src/com/liferay/portal/upgrade/v6_") || absolutePath.contains("/portal-impl/src/com/liferay/portal/upgrade/v7_0_")) {
            return;
        }
        List<DetailAST> methodDefDetailASTList = this.getAllChildTokens(detailAST.findFirstToken(6), false, 9);
        DetailAST doUpgradeMethodDefDetailAST = null;
        for (DetailAST methodDefDetailAST : methodDefDetailASTList) {
            if (!StringUtil.equals(this.getName(methodDefDetailAST), "doUpgrade") || !AnnotationUtil.containsAnnotation((DetailAST)methodDefDetailAST, (String)"Override")) continue;
            doUpgradeMethodDefDetailAST = methodDefDetailAST;
            break;
        }
        if (doUpgradeMethodDefDetailAST == null) {
            return;
        }
        DetailAST slistDetailAST = doUpgradeMethodDefDetailAST.findFirstToken(7);
        if (slistDetailAST.getChildCount() == 1) {
            return;
        }
        if (methodDefDetailASTList.size() == 1 && this._isUnnecessaryUpgradeProcessClass(slistDetailAST)) {
            this.log(detailAST, _MSG_UNNECESSARY_CLASS, new Object[]{JavaSourceUtil.getClassName(absolutePath)});
            return;
        }
        this._checkPostUpgradeSteps(slistDetailAST);
        this._checkPreUpgradeSteps(slistDetailAST);
    }

    private void _checkPostUpgradeSteps(DetailAST detailAST) {
        DetailAST lastChildDetailAST = detailAST.getLastChild();
        if (lastChildDetailAST.getType() != 73) {
            return;
        }
        DetailAST previousSiblingDetailAST = lastChildDetailAST.getPreviousSibling();
        if (previousSiblingDetailAST == null || previousSiblingDetailAST.getType() != 45) {
            return;
        }
        if ((previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling()) == null || previousSiblingDetailAST.getType() != 28) {
            return;
        }
        DetailAST firstChildDetailAST = previousSiblingDetailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 27) {
            return;
        }
        String methodName = this.getMethodName(firstChildDetailAST);
        if (ArrayUtil.contains(_ALTER_METHOD_NAMES, methodName) && previousSiblingDetailAST.getPreviousSibling() != null) {
            this.log(firstChildDetailAST, _MSG_MOVE_UPGRADE_STEP_INSIDE_POST_UPGRADE_STEPS, new Object[]{methodName});
        }
    }

    private void _checkPreUpgradeSteps(DetailAST detailAST) {
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 28) {
            return;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()) == null || firstChildDetailAST.getType() != 27) {
            return;
        }
        String methodName = this.getMethodName(firstChildDetailAST);
        if (ArrayUtil.contains(_ALTER_METHOD_NAMES, methodName)) {
            this.log(firstChildDetailAST, _MSG_MOVE_UPGRADE_STEP_INSIDE_PRE_UPGRADE_STEPS, new Object[]{methodName});
        }
    }

    private boolean _containsOnlyAlterMethodCalls(DetailAST detailAST, String tableName, String columnName) {
        if (detailAST == null) {
            return false;
        }
        DetailAST lastChildDetailAST = detailAST.getLastChild();
        if (lastChildDetailAST.getType() != 73) {
            return false;
        }
        for (DetailAST previousSiblingDetailAST = lastChildDetailAST.getPreviousSibling(); previousSiblingDetailAST != null; previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling()) {
            if (previousSiblingDetailAST.getType() != 28 && previousSiblingDetailAST.getType() != 45) {
                return false;
            }
            if (previousSiblingDetailAST.getType() != 28) continue;
            DetailAST firstChildDetailAST = previousSiblingDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 27 || !ArrayUtil.contains(_ALTER_METHOD_NAMES, this.getMethodName(firstChildDetailAST))) {
                return false;
            }
            if (!Validator.isNotNull(columnName) || !Validator.isNotNull(tableName) || this._hasSameTableNameAndColumnName(firstChildDetailAST, tableName, columnName)) continue;
            return false;
        }
        return true;
    }

    private String _getParameterName(DetailAST detailAST) {
        if (detailAST == null) {
            return null;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 139) {
            return null;
        }
        return firstChildDetailAST.getText();
    }

    private boolean _hasSameTableNameAndColumnName(DetailAST detailAST, String tableName, String columnName) {
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 59) {
            return false;
        }
        DetailAST elistDetailAST = detailAST.findFirstToken(34);
        firstChildDetailAST = elistDetailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 28 || !StringUtil.equals(tableName, this._getParameterName(firstChildDetailAST))) {
            return false;
        }
        DetailAST nextSiblingDetailAST = firstChildDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 74) {
            return false;
        }
        return (nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) != null && nextSiblingDetailAST.getType() == 28 && StringUtil.equals(columnName, this._getParameterName(nextSiblingDetailAST));
    }

    private boolean _isUnnecessaryIfStatement(DetailAST detailAST) {
        DetailAST exprDetailAST = detailAST.findFirstToken(28);
        if (exprDetailAST.getChildCount() != 1) {
            return false;
        }
        DetailAST firstChildDetailAST = exprDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 132) {
            firstChildDetailAST = firstChildDetailAST.getFirstChild();
        }
        if (firstChildDetailAST.getType() != 27) {
            return false;
        }
        String methodName = this.getMethodName(firstChildDetailAST);
        if (!methodName.equals("hasColumn") && !methodName.equals("hasColumnType")) {
            return false;
        }
        DetailAST elistDetailAST = firstChildDetailAST.findFirstToken(34);
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(elistDetailAST, false, 28);
        if (exprDetailASTList.size() < 2) {
            return false;
        }
        String columnName = this._getParameterName(exprDetailASTList.get(1));
        String tableName = this._getParameterName(exprDetailASTList.get(0));
        if (Validator.isNull(columnName) || Validator.isNull(tableName)) {
            return false;
        }
        return this._containsOnlyAlterMethodCalls(detailAST.findFirstToken(7), tableName, columnName);
    }

    private boolean _isUnnecessaryUpgradeProcessClass(DetailAST detailAST) {
        return this._containsOnlyAlterMethodCalls(detailAST, null, null);
    }

    private boolean _isUpgradeProcess(DetailAST detailAST) {
        DetailAST extendsClauseDetailAST = detailAST.findFirstToken(18);
        if (extendsClauseDetailAST == null) {
            return false;
        }
        DetailAST firstChildDetailAST = extendsClauseDetailAST.getFirstChild();
        return firstChildDetailAST.getType() == 58 && StringUtil.equals(this.getName(extendsClauseDetailAST), "UpgradeProcess");
    }
}

