/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.processor;

import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.processor.BaseSourceProcessor;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class PropertiesSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.properties", "**/.eslintignore", "**/.prettierignore"};

    @Override
    protected List<String> doGetFileNames() throws IOException {
        return this.getFileNames(new String[]{"**/docroot/dtd/**", "**/lportal.properties"}, this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        if (this.isPortalSource() || this.isSubrepository()) {
            return _INCLUDES;
        }
        return new String[]{"**/liferay-plugin-package.properties", "**/portal.properties", "**/portal-ext.properties", "**/portlet.properties", "**/poshi.properties", "**/service.properties", "**/source-formatter.properties", "**/test.properties"};
    }

    @Override
    protected File format(File file, String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith(".properties") && SourceUtil.isXML(content)) {
            return file;
        }
        return super.format(file, fileName, absolutePath, content);
    }
}

