/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.TimeZoneThreadLocal;
import java.util.Locale;
import java.util.TimeZone;

public class CompanyThreadLocal {
    private static final Log _log = LogFactoryUtil.getLog(CompanyThreadLocal.class);
    private static final CentralizedThreadLocal<Long> _companyId = new CentralizedThreadLocal<Long>(CompanyThreadLocal.class + "._companyId", () -> 0L);
    private static final CentralizedThreadLocal<Boolean> _initializingPortalInstance = new CentralizedThreadLocal<Boolean>(CompanyThreadLocal.class + "._initializingPortalInstance", () -> Boolean.FALSE);
    private static final ThreadLocal<Boolean> _locked = new CentralizedThreadLocal<Boolean>(CompanyThreadLocal.class + "._locked", () -> Boolean.FALSE);

    public static Long getCompanyId() {
        Long companyId = _companyId.get();
        if (_log.isDebugEnabled()) {
            _log.debug("getCompanyId " + companyId);
        }
        return companyId;
    }

    public static boolean isInitializingPortalInstance() {
        return _initializingPortalInstance.get();
    }

    public static boolean isLocked() {
        return _locked.get();
    }

    public static SafeCloseable lock(long companyId) {
        SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable(companyId);
        _locked.set(true);
        return () -> {
            _locked.set(false);
            safeCloseable.close();
        };
    }

    public static void setCompanyId(Long companyId) {
        if (CompanyThreadLocal._setCompanyId(companyId)) {
            CTCollectionThreadLocal.removeCTCollectionId();
        }
    }

    public static SafeCloseable setInitializingCompanyIdWithSafeCloseable(long companyId) {
        if (companyId > 0L) {
            return _companyId.setWithSafeCloseable(companyId);
        }
        return _companyId.setWithSafeCloseable(0L);
    }

    public static SafeCloseable setInitializingPortalInstance(boolean initializingPortalInstance) {
        return _initializingPortalInstance.setWithSafeCloseable(initializingPortalInstance);
    }

    public static SafeCloseable setWithSafeCloseable(Long companyId) {
        return CompanyThreadLocal.setWithSafeCloseable(companyId, 0L);
    }

    public static SafeCloseable setWithSafeCloseable(Long companyId, Long ctCollectionId) {
        long currentCompanyId = _companyId.get();
        Locale defaultLocale = LocaleThreadLocal.getDefaultLocale();
        TimeZone defaultTimeZone = TimeZoneThreadLocal.getDefaultTimeZone();
        CompanyThreadLocal._setCompanyId(companyId);
        SafeCloseable ctCollectionSafeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);
        return () -> {
            _companyId.set(currentCompanyId);
            LocaleThreadLocal.setDefaultLocale(defaultLocale);
            TimeZoneThreadLocal.setDefaultTimeZone(defaultTimeZone);
            ctCollectionSafeCloseable.close();
        };
    }

    /*
     * Exception decompiling
     */
    private static User _fetchGuestUser(long companyId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean _setCompanyId(Long companyId) {
        block9: {
            if (companyId.equals(_companyId.get())) {
                return false;
            }
            if (CompanyThreadLocal.isLocked()) {
                throw new UnsupportedOperationException("CompanyThreadLocal modification is not allowed");
            }
            if (_log.isDebugEnabled()) {
                _log.debug("setCompanyId " + companyId);
            }
            if (companyId > 0L) {
                _companyId.set(companyId);
                try {
                    User guestUser = CompanyThreadLocal._fetchGuestUser(companyId);
                    if (guestUser == null) {
                        if (_log.isDebugEnabled()) {
                            _log.debug("No guest user was found for company " + companyId);
                        }
                        break block9;
                    }
                    LocaleThreadLocal.setDefaultLocale(guestUser.getLocale());
                    TimeZoneThreadLocal.setDefaultTimeZone(guestUser.getTimeZone());
                }
                catch (Exception exception) {
                    _log.error(exception);
                }
            } else {
                _companyId.set(0L);
                LocaleThreadLocal.setDefaultLocale(null);
                TimeZoneThreadLocal.setDefaultTimeZone(null);
            }
        }
        return true;
    }
}

