/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.util;

import com.liferay.poshi.core.util.PropsValues;
import com.liferay.poshi.core.util.StringUtil;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.dom4j.util.NodeComparator;

public class Dom4JUtil {
    public static void addToElement(Element element, Object ... items) {
        for (Object item : items) {
            if (item == null) continue;
            if (item instanceof Attribute) {
                element.add((Attribute)item);
                continue;
            }
            if (item instanceof Element) {
                element.add((Element)item);
                continue;
            }
            if (item instanceof String) {
                element.addText((String)item);
                continue;
            }
            throw new IllegalArgumentException("Only attributes, elements, and strings may be added");
        }
    }

    public static boolean elementsEqual(Node node1, Node node2) {
        NodeComparator nodeComparator = new NodeComparator();
        int compare = nodeComparator.compare(node1, node2);
        return compare == 0;
    }

    public static String format(Element element) throws IOException {
        Element node = element;
        return Dom4JUtil.format((Node)node, true);
    }

    public static String format(Element element, boolean pretty) throws IOException {
        Element node = element;
        return Dom4JUtil.format((Node)node, pretty);
    }

    public static String format(Node node) throws IOException {
        return Dom4JUtil.format(node, true);
    }

    public static String format(Node node, boolean pretty) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setIndent("\t");
        outputFormat.setTrimText(false);
        XMLWriter xmlWriter = null;
        xmlWriter = pretty ? new XMLWriter((Writer)writer, outputFormat) : new XMLWriter((Writer)writer);
        xmlWriter.write(node);
        return ((Object)writer).toString();
    }

    public static Element getNewAnchorElement(String href, Element parentElement, Object ... items) {
        if (items == null || items.length == 0) {
            return null;
        }
        Element anchorElement = Dom4JUtil.getNewElement("a", parentElement, items);
        anchorElement.addAttribute("href", href);
        return anchorElement;
    }

    public static Element getNewAnchorElement(String href, Object ... items) {
        return Dom4JUtil.getNewAnchorElement(href, null, items);
    }

    public static Element getNewElement(String childElementTag) {
        return Dom4JUtil.getNewElement(childElementTag, null, new Object[0]);
    }

    public static Element getNewElement(String childElementTag, Element parentElement, Object ... items) {
        DefaultElement childElement = new DefaultElement(childElementTag);
        if (parentElement != null) {
            parentElement.add((Element)childElement);
        }
        if (items != null && items.length > 0) {
            Dom4JUtil.addToElement((Element)childElement, items);
        }
        return childElement;
    }

    public static Document parse(String xml) throws DocumentException {
        SAXReader saxReader = new SAXReader();
        return saxReader.read((Reader)new StringReader(xml));
    }

    public static void removeWhiteSpaceTextNodes(Element element) {
        for (Node node : Dom4JUtil.toNodeList(element.content())) {
            if (!(node instanceof Text)) continue;
            String nodeText = node.getText();
            if ((nodeText = nodeText.trim()).length() != 0) continue;
            node.detach();
        }
        for (Element childElement : Dom4JUtil.toElementList(element.elements())) {
            Dom4JUtil.removeWhiteSpaceTextNodes(childElement);
        }
    }

    public static void replace(Element element, boolean cascade, String replacementText, String targetText) {
        Iterator attributeIterator = element.attributeIterator();
        while (attributeIterator.hasNext()) {
            Attribute attribute = (Attribute)attributeIterator.next();
            String text = attribute.getValue();
            attribute.setValue(StringUtil.replace(text, targetText, replacementText));
        }
        Iterator nodeIterator = element.nodeIterator();
        while (nodeIterator.hasNext()) {
            Node node = (Node)nodeIterator.next();
            if (node instanceof Text) {
                Text textNode = (Text)node;
                String text = textNode.getText();
                if (!text.contains(targetText)) continue;
                text = StringUtil.replace(text, targetText, replacementText);
                textNode.setText(text);
                continue;
            }
            if (!(node instanceof Element) || !cascade) continue;
            Dom4JUtil.replace((Element)node, cascade, replacementText, targetText);
        }
    }

    public static List<Attribute> toAttributeList(List<?> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>(list.size());
        for (Object object : list) {
            attributeList.add((Attribute)object);
        }
        return attributeList;
    }

    public static List<Element> toElementList(List<?> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Element> elementList = new ArrayList<Element>(list.size());
        for (Object object : list) {
            elementList.add((Element)object);
        }
        return elementList;
    }

    public static List<Node> toNodeList(List<?> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Node> nodeList = new ArrayList<Node>(list.size());
        for (Object object : list) {
            nodeList.add((Node)object);
        }
        return nodeList;
    }

    public static void validateDocument(URL url) throws DocumentException {
        SAXReader saxReader = new SAXReader();
        try {
            saxReader.read(url);
        }
        catch (DocumentException documentException) {
            if (PropsValues.DEBUG_STACKTRACE.booleanValue()) {
                documentException.printStackTrace();
            }
            throw documentException;
        }
    }
}

