/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JSPSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseJSPTermsCheck
extends BaseFileCheck {
    private static final Pattern _methodCallPattern = Pattern.compile("\\b(?<!['\"])([a-z]\\w+)\\.(\\w+)?\\(");
    private List<String> _allFileNames;
    private Map<String, String> _contentsMap;

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    protected Map<String, String> getContentsMap() {
        return this._contentsMap;
    }

    protected Set<String> getMissingTaglibPrefixes(String fileName, Set<String> taglibPrefixes) {
        List<String> dependentfileNames = new ArrayList<String>();
        dependentfileNames.add(fileName);
        Map<String, String> contentsMap = this.getContentsMap();
        dependentfileNames = JSPSourceUtil.addIncludedAndReferencedFileNames(dependentfileNames, new HashSet<String>(), contentsMap, ".*\\.jspf");
        if (fileName.endsWith(".jspf") && dependentfileNames.size() == 1) {
            return Collections.emptySet();
        }
        for (String dependentfileName : dependentfileNames) {
            String dependenFileContent = contentsMap.get(dependentfileName = StringUtil.replace(dependentfileName, '\\', '/'));
            if (dependenFileContent == null) {
                return Collections.emptySet();
            }
            Iterator<String> iterator = taglibPrefixes.iterator();
            while (iterator.hasNext()) {
                String prefix = iterator.next();
                if (!dependenFileContent.contains("prefix=\"" + prefix + "\"")) continue;
                iterator.remove();
                if (!taglibPrefixes.isEmpty()) continue;
                return taglibPrefixes;
            }
        }
        return taglibPrefixes;
    }

    protected boolean hasUnusedJSPTerm(String fileName, String content, String regex, int lineNumber, String type, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames, Map<String, String> contentsMap) {
        includeFileNames.add(fileName);
        HashSet<String> checkedForUnusedJSPTerm = new HashSet<String>();
        return !this._isJSPTermRequired(fileName, content, regex, lineNumber, type, checkedForUnusedJSPTerm, checkedForIncludesFileNames, includeFileNames, contentsMap);
    }

    protected boolean hasUnusedJSPTerm(String fileName, String content, String regex, String type, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames, Map<String, String> contentsMap) {
        return this.hasUnusedJSPTerm(fileName, content, regex, -1, type, checkedForIncludesFileNames, includeFileNames, contentsMap);
    }

    protected boolean hasVariableReference(String content, String value, int pos) {
        if (pos == -1) {
            return false;
        }
        pos = content.indexOf("\n", pos);
        Matcher methodCallMatcher = _methodCallPattern.matcher(value);
        while (methodCallMatcher.find()) {
            Pattern pattern = Pattern.compile("\\b(?<!['\"])" + methodCallMatcher.group(1) + "\\.(\\w+)?\\(");
            Matcher matcher = pattern.matcher(content);
            while (matcher.find() && matcher.start() <= pos) {
                String methodName = matcher.group(1);
                if (methodName.startsWith("get") || methodName.startsWith("is")) continue;
                return true;
            }
        }
        return false;
    }

    protected synchronized void populateContentsMap(String fileName, String content) throws IOException {
        if (this._contentsMap != null) {
            return;
        }
        List<String> allJSPFileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, new String[]{"**/null.jsp", "**/tools/**"}, new String[]{"**/*.jsp", "**/*.jspf", "**/*.tag"}, this.getSourceFormatterExcludes(), true);
        this._contentsMap = JSPSourceUtil.getContentsMap(allJSPFileNames);
        if (this._contentsMap.isEmpty()) {
            this._contentsMap.put(fileName, content);
        }
    }

    protected void put(String fileName, String content) {
        this._contentsMap.put(fileName, content);
    }

    private String _getRangeContent(String content, int lineNumber) {
        String trimmedLine;
        String line = this.getLine(content, lineNumber);
        String indent = SourceUtil.getIndent(line);
        if (indent.length() == 0) {
            return content;
        }
        for (int curLineNumber = lineNumber - 1; curLineNumber != 0 && !(trimmedLine = StringUtil.trim(this.getLine(content, curLineNumber))).equals("<%"); --curLineNumber) {
            if (!trimmedLine.equals("<%!")) continue;
            return content;
        }
        StringBundler sb = new StringBundler();
        sb.append("<%\n");
        sb.append(line);
        while (true) {
            if ((line = this.getLine(content, ++lineNumber)) == null) {
                if (indent.length() == 0) {
                    return sb.toString();
                }
                return content;
            }
            if (Validator.isNotNull(line) && !line.startsWith(indent)) {
                String trimmedLine2 = StringUtil.trim(line);
                if (trimmedLine2.startsWith("}")) {
                    sb.append("%>/n");
                    return sb.toString();
                }
                if (trimmedLine2.matches("</[\\w-]+:[\\w-]+>")) {
                    return sb.toString();
                }
                if (trimmedLine2.matches("</[\\w-]+>")) {
                    indent = indent.substring(1);
                }
            }
            sb.append(line);
            sb.append("\n");
        }
    }

    private boolean _isJSPTermRequired(String fileName, String content, String regex, int lineNumber, String type, Set<String> checkedForUnusedJSPTerm, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames, Map<String, String> contentsMap) {
        String[] includeFileNamesArray;
        if (checkedForUnusedJSPTerm.contains(fileName)) {
            return false;
        }
        checkedForUnusedJSPTerm.add(fileName);
        if (content == null) {
            content = contentsMap.get(fileName);
        }
        if (Validator.isNull(content)) {
            return false;
        }
        if (lineNumber != -1) {
            content = this._getRangeContent(content, lineNumber);
        }
        int count = 0;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            if (type.equals("taglib")) {
                ++count;
                continue;
            }
            int x = matcher.start() + 1;
            if (this.isJavaSource(content, x)) {
                if (ToolsUtil.isInsideQuotes(content, x)) continue;
                ++count;
                continue;
            }
            String line = StringUtil.trim(this.getLine(content, this.getLineNumber(content, matcher.start())));
            if (line.startsWith("function ")) continue;
            int y = content.lastIndexOf("<%", x) + 2;
            int z = content.lastIndexOf("%>", x);
            if (y == 1 || z > y || (z = content.indexOf("%>", x)) != -1 && this.getLineNumber(content, y) == this.getLineNumber(content, z) && ToolsUtil.isInsideQuotes(content.substring(y, z), x - y, false)) continue;
            ++count;
        }
        if (count > 1 || count == 1 && (!type.equals("variable") || checkedForUnusedJSPTerm.size() > 1)) {
            return true;
        }
        if (!checkedForIncludesFileNames.contains(fileName)) {
            includeFileNames.addAll(JSPSourceUtil.getJSPIncludeFileNames(fileName, includeFileNames, contentsMap, false));
            includeFileNames.addAll(JSPSourceUtil.getJSPReferenceFileNames(fileName, includeFileNames, contentsMap, ".*\\.(jsp|jspf|tag)"));
        }
        checkedForIncludesFileNames.add(fileName);
        for (String includeFileName : includeFileNamesArray = includeFileNames.toArray(new String[0])) {
            if (checkedForUnusedJSPTerm.contains(includeFileName) || !this._isJSPTermRequired(includeFileName, null, regex, -1, type, checkedForUnusedJSPTerm, checkedForIncludesFileNames, includeFileNames, contentsMap)) continue;
            return true;
        }
        return false;
    }
}

