/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.GradleSourceUtil;
import java.io.File;
import java.util.List;

public class GradleDependencyConfigurationCheck
extends BaseFileCheck {
    private static final String _CHECK_API_DEPENDENCIES_KEY = "checkAPIDependencies";
    private static final String _CHECK_RUNTIME_ONLY_DEPENDENCIES_KEY = "checkRuntimeOnlyDependencies";
    private static final String _CHECK_TEST_IMPLEMENTATION_DEPENDENCIES_KEY = "checkTestImplementationDependencies";
    private static final String _CHECK_TEST_INTEGRATION_IMPLEMENTATION_DEPENDENCIES_KEY = "checkTestIntegrationImplementationDependencies";
    private static final String _CHECK_TEST_INTEGRATION_RUNTIME_ONLY_DEPENDENCIES_KEY = "checkTestIntegrationRuntimeOnlyDependencies";
    private static final String _CHECK_TEST_RUNTIME_ONLY_DEPENDENCIES_KEY = "checkTestRuntimeOnlyDependencies";

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        List<String> blocks = GradleSourceUtil.getDependenciesBlocks(content);
        for (String dependencies : blocks) {
            if (this.isModulesApp(absolutePath, false) && this._hasBNDFile(absolutePath) && !GradleSourceUtil.isSpringBootExecutable(content)) {
                content = this._formatDependencies(content, dependencies);
            }
            if (absolutePath.contains("/third-party/")) {
                content = this._fixTransitive(content, dependencies);
            }
            if (this.isAttributeValue(_CHECK_API_DEPENDENCIES_KEY, absolutePath)) {
                content = this._fixConfigurations(content, dependencies, "compile", "api");
            }
            if (this.isAttributeValue(_CHECK_RUNTIME_ONLY_DEPENDENCIES_KEY, absolutePath)) {
                content = this._fixConfigurations(content, dependencies, "runtime", "runtimeOnly");
            }
            if (this.isAttributeValue(_CHECK_TEST_IMPLEMENTATION_DEPENDENCIES_KEY, absolutePath)) {
                content = this._fixConfigurations(content, dependencies, "testCompile", "testImplementation");
            }
            if (this.isAttributeValue(_CHECK_TEST_INTEGRATION_IMPLEMENTATION_DEPENDENCIES_KEY, absolutePath)) {
                content = this._fixConfigurations(content, dependencies, "testIntegrationCompile", "testIntegrationImplementation");
            }
            if (this.isAttributeValue(_CHECK_TEST_INTEGRATION_RUNTIME_ONLY_DEPENDENCIES_KEY, absolutePath)) {
                content = this._fixConfigurations(content, dependencies, "testIntegrationRuntime", "testIntegrationRuntimeOnly");
            }
            if (!this.isAttributeValue(_CHECK_TEST_RUNTIME_ONLY_DEPENDENCIES_KEY, absolutePath)) continue;
            content = this._fixConfigurations(content, dependencies, "testRuntime", "testRuntimeOnly");
        }
        return content;
    }

    private String _fixConfigurations(String content, String dependencies, String oldConfiguration, String newConfiguration) {
        int y;
        int x = dependencies.indexOf("\n");
        if (x == (y = dependencies.lastIndexOf("\n"))) {
            return content;
        }
        dependencies = dependencies.substring(x, y + 1);
        String[] stringArray = StringUtil.splitLines(dependencies);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String oldDependency;
            String newDependency = oldDependency = stringArray[i];
            String configuration = GradleSourceUtil.getConfiguration(oldDependency);
            if (configuration.equals(oldConfiguration)) {
                newDependency = StringUtil.replaceFirst(oldDependency, oldConfiguration, newConfiguration);
            }
            content = StringUtil.replaceFirst(content, oldDependency, newDependency);
        }
        return content;
    }

    private String _fixTransitive(String content, String dependencies) {
        int y;
        int x = dependencies.indexOf("\n");
        if (x == (y = dependencies.lastIndexOf("\n"))) {
            return content;
        }
        dependencies = dependencies.substring(x, y + 1);
        for (String oldDependency : StringUtil.splitLines(dependencies)) {
            String configuration = GradleSourceUtil.getConfiguration(oldDependency);
            String newDependency = oldDependency;
            if (!configuration.equals("compileOnly") || oldDependency.contains("transitive: false")) continue;
            newDependency = oldDependency + ", transitive: false";
            content = StringUtil.replaceFirst(content, oldDependency, newDependency);
        }
        return content;
    }

    private String _formatDependencies(String content, String dependencies) {
        int y;
        int x = dependencies.indexOf("\n");
        if (x == (y = dependencies.lastIndexOf("\n"))) {
            return content;
        }
        dependencies = dependencies.substring(x, y + 1);
        for (String oldDependency : StringUtil.splitLines(dependencies)) {
            String configuration = GradleSourceUtil.getConfiguration(oldDependency);
            String newDependency = oldDependency;
            if (configuration.equals("compile")) {
                newDependency = StringUtil.replaceFirst(oldDependency, "compile", "compileOnly");
                content = StringUtil.replaceFirst(content, oldDependency, newDependency);
                continue;
            }
            if (!configuration.equals("compileOnly")) continue;
            newDependency = StringUtil.removeSubstrings(oldDependency, "transitive: false, ", "transitive: true,");
            content = StringUtil.replaceFirst(content, oldDependency, newDependency);
        }
        return content;
    }

    private boolean _hasBNDFile(String absolutePath) {
        if (!absolutePath.endsWith("/build.gradle")) {
            return false;
        }
        int pos = absolutePath.lastIndexOf("/");
        File file = new File(absolutePath.substring(0, pos + 1) + "bnd.bnd");
        return file.exists();
    }
}

