/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.GradleSourceUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleDependencyVersionCheck
extends BaseFileCheck {
    private static final Pattern _dependencyNamePattern = Pattern.compile(".*, name: \"([^\"]*)\".*");
    private static final Pattern _dependencyVersionPattern = Pattern.compile(".*, version: \"([^\"]*)\".*");
    private static final Pattern _majorVersionPattern = Pattern.compile("^[0-9]+");
    private Map<String, Integer> _publishedMajorVersionsMap;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (this.isExcludedPath("run.outside.portal.excludes", absolutePath)) {
            return content;
        }
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        String moduleName = absolutePath.substring(y + 1, x);
        if (!moduleName.contains("test")) {
            for (String dependencies : GradleSourceUtil.getDependenciesBlocks(content)) {
                content = this._formatDependencies(absolutePath, content, dependencies);
            }
        }
        return content;
    }

    private String _formatDependencies(String absolutePath, String content, String dependencies) throws IOException {
        int y;
        int x = dependencies.indexOf("\n");
        if (x == (y = dependencies.lastIndexOf("\n"))) {
            return content;
        }
        dependencies = dependencies.substring(x, y + 1);
        StringBundler sb = new StringBundler();
        for (String line : StringUtil.splitLines(dependencies)) {
            String dependencyName = this._getDependencyName(line);
            if (Objects.isNull(dependencyName) || line.matches(".*\\s+testCompile\\s+.*")) {
                sb.append(line);
                sb.append("\n");
                continue;
            }
            String dependencyVersion = this._getDependencyVersion(line);
            if (dependencyVersion.matches("^[0-9.]+") && !this._isValidVersion(absolutePath, dependencyName, dependencyVersion)) {
                Map<String, Integer> publishedMajorVersionsMap = this._getPublishedMajorVersionsMap(absolutePath);
                line = StringUtil.replaceFirst(line, dependencyVersion, publishedMajorVersionsMap.get(dependencyName) + ".0.0");
            }
            sb.append(line);
            sb.append("\n");
        }
        return StringUtil.replace(content, StringUtil.trim(dependencies), StringUtil.trim(sb.toString()));
    }

    private String _getDependencyName(String dependency) {
        Matcher matcher = _dependencyNamePattern.matcher(dependency);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    private String _getDependencyVersion(String dependency) {
        Matcher matcher = _dependencyVersionPattern.matcher(dependency);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    private String _getMajorVersion(String version) {
        Matcher matcher = _majorVersionPattern.matcher(version);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group();
    }

    private synchronized Map<String, Integer> _getPublishedMajorVersionsMap(String absolutePath) throws IOException {
        if (this._publishedMajorVersionsMap != null) {
            return this._publishedMajorVersionsMap;
        }
        String content = this.getModulesPropertiesContent(absolutePath);
        if (Validator.isNull(content)) {
            this._publishedMajorVersionsMap = Collections.emptyMap();
            return this._publishedMajorVersionsMap;
        }
        HashMap<String, String> bundleVersionsMap = new HashMap<String, String>();
        List<String> lines = ListUtil.fromString(content);
        for (String string : lines) {
            String key;
            String[] array = StringUtil.split(string, "=");
            if (array.length != 2 || !(key = array[0]).startsWith("bundle.version[")) continue;
            bundleVersionsMap.put(key.substring(15, key.length() - 1), array[1]);
        }
        this._publishedMajorVersionsMap = new HashMap<String, Integer>();
        for (Map.Entry entry : bundleVersionsMap.entrySet()) {
            String bundleVersion = (String)entry.getValue();
            String majorVersion = this._getMajorVersion(bundleVersion);
            if (Validator.isNull(majorVersion)) continue;
            int publishedMajorVersion = GetterUtil.getInteger(majorVersion);
            if (publishedMajorVersion > 1 && bundleVersion.matches(publishedMajorVersion + "[0.]*")) {
                --publishedMajorVersion;
            }
            this._publishedMajorVersionsMap.put((String)entry.getKey(), publishedMajorVersion);
        }
        return this._publishedMajorVersionsMap;
    }

    private boolean _isValidVersion(String absolutePath, String dependencyName, String dependencyVersion) throws IOException {
        Map<String, Integer> publishedMajorVersionsMap = this._getPublishedMajorVersionsMap(absolutePath);
        Set<String> bundleSymbolicNames = publishedMajorVersionsMap.keySet();
        return !dependencyName.startsWith("com.liferay.") || !bundleSymbolicNames.contains(dependencyName) || GetterUtil.getInteger(this._getMajorVersion(dependencyVersion)) == publishedMajorVersionsMap.get(dependencyName);
    }
}

