/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.JavaAnnotationsCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaComponentAnnotationsCheck
extends JavaAnnotationsCheck {
    private static final String _ALLOWED_IMMEDIATE_ATTRIBUTE_CLASS_NAMES_KEY = "allowedImmediateAttributeClassNames";
    private static final String _CHECK_CONFIGURATION_PID_ATTRIBUTE_KEY = "checkConfigurationPidAttribute";
    private static final String _CHECK_CONFIGURATION_POLICY_ATTRIBUTE_KEY = "checkConfigurationPolicyAttribute";
    private static final String _CHECK_IMMEDIATE_ATTRIBUTE_KEY = "checkImmediateAttribute";
    private static final String _CHECK_MISMATCHED_SERVICE_ATTRIBUTE_KEY = "checkMismatchedServiceAttribute";
    private static final String _CHECK_PORTLET_VERSION_KEY = "checkPortletVersion";
    private static final String _CHECK_SELF_REGISTRATION_KEY = "checkSelfRegistration";
    private static final String _ENTERPRISE_APP_MODULE_PATH_NAMES_KEY = "enterpriseAppModulePathNames";
    private static final Pattern _annotationParameterPropertyPattern = Pattern.compile("\\s(\\w+) = \\{");
    private static final Pattern _attributePattern = Pattern.compile("\\W(\\w+)\\s*=");
    private Map<String, String> _bundleSymbolicNamesMap;
    private String _rootDirName;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String formatAnnotation(String fileName, String absolutePath, JavaClass javaClass, String fileContent, String annotation, String indent) {
        String trimmedAnnotation = StringUtil.trim(annotation);
        if (!trimmedAnnotation.equals("@Component") && !trimmedAnnotation.startsWith("@Component(")) {
            return annotation;
        }
        List<String> importNames = javaClass.getImportNames();
        if (!importNames.contains("org.osgi.service.component.annotations.Component")) {
            return annotation;
        }
        this._checkImmediateAttribute(fileName, absolutePath, annotation);
        annotation = this._formatAnnotationParameterProperties(annotation);
        annotation = this._formatConfigurationAttributes(fileName, absolutePath, javaClass, annotation);
        annotation = this._formatEnabledAttribute(absolutePath, annotation);
        annotation = this._formatServiceAttribute(fileName, absolutePath, javaClass.getName(), annotation, javaClass.getImplementedClassNames());
        List<String> extendedClassNames = javaClass.getExtendedClassNames(false);
        if (extendedClassNames.contains("MVCPortlet")) {
            annotation = this._formatMVCPortletProperties(absolutePath, annotation);
        }
        return annotation;
    }

    private String _addAttribute(String annotation, String attributeName, String attributeValue) {
        if (!annotation.contains("(")) {
            return StringBundler.concat(annotation.substring(0, annotation.length() - 1), "(", attributeName, " = ", attributeValue, ")\n");
        }
        Matcher matcher = _attributePattern.matcher(annotation);
        while (matcher.find()) {
            String curAttributeName;
            if (ToolsUtil.isInsideQuotes(annotation, matcher.end(1)) || this.getLevel(annotation.substring(0, matcher.end()), "{", "}") != 0 || (curAttributeName = matcher.group(1)).compareTo(attributeName) <= 0) continue;
            return StringUtil.insert(annotation, StringBundler.concat(attributeName, " = ", attributeValue, ", "), matcher.start(1));
        }
        String indent = SourceUtil.getIndent(annotation);
        if (annotation.endsWith("\n" + indent + ")\n")) {
            int pos = annotation.lastIndexOf("\n", annotation.length() - 2);
            return StringUtil.insert(annotation, StringBundler.concat(",\n\t", indent, attributeName, " = ", attributeValue), pos);
        }
        return StringUtil.replaceLast(annotation, ')', StringBundler.concat(", ", attributeName, " = ", attributeValue, ")"));
    }

    private String _addNewProperties(String newProperties, String properties) {
        if (!(newProperties = StringUtil.trimTrailing(newProperties)).endsWith(",")) {
            newProperties = newProperties + ",";
        }
        return newProperties + properties;
    }

    private void _checkImmediateAttribute(String fileName, String absolutePath, String annotation) {
        if (absolutePath.contains("/modules/apps/archived/") || !this.isAttributeValue(_CHECK_IMMEDIATE_ATTRIBUTE_KEY, absolutePath)) {
            return;
        }
        List<String> allowedImmediateAttributeClassNames = this.getAttributeValues(_ALLOWED_IMMEDIATE_ATTRIBUTE_CLASS_NAMES_KEY, absolutePath);
        for (String allowedImmediateAttributeClassName : allowedImmediateAttributeClassNames) {
            if (!absolutePath.contains(allowedImmediateAttributeClassName)) continue;
            return;
        }
        String immediateAttributeValue = this.getAnnotationAttributeValue(annotation, "immediate");
        if (immediateAttributeValue != null && immediateAttributeValue.equals("true")) {
            this.addMessage(fileName, "Do not use 'immediate = true' in @Component");
        }
    }

    private String _formatAnnotationParameterProperties(String annotation) {
        Matcher matcher = _annotationParameterPropertyPattern.matcher(annotation);
        while (matcher.find()) {
            int x = matcher.end() - 1;
            while (ToolsUtil.isInsideQuotes(annotation, x = annotation.indexOf(125, x + 1))) {
            }
            String parameterProperties = annotation.substring(matcher.end(), x);
            String newParameterProperties = StringUtil.replace(parameterProperties, new String[]{" =", "= "}, new String[]{"=", "="});
            if (!parameterProperties.equals(newParameterProperties)) {
                return StringUtil.replaceFirst(annotation, parameterProperties, newParameterProperties);
            }
            parameterProperties = StringUtil.replace(parameterProperties, new String[]{"\t", "    ", "\n"}, new String[]{"", "", " "});
            if ((parameterProperties = StringUtil.trim(parameterProperties)).startsWith("@")) continue;
            String[] parameterPropertiesArray = StringUtil.split(parameterProperties, ", ");
            AnnotationParameterPropertyComparator comparator = new AnnotationParameterPropertyComparator(matcher.group(1));
            for (int i = 1; i < parameterPropertiesArray.length; ++i) {
                String previousParameterProperty = parameterPropertiesArray[i - 1];
                String parameterProperty = parameterPropertiesArray[i];
                int compare = comparator.compare(previousParameterProperty, parameterProperty);
                if (compare <= 0) continue;
                annotation = StringUtil.replaceFirst(annotation, previousParameterProperty, parameterProperty);
                annotation = StringUtil.replaceLast(annotation, parameterProperty, previousParameterProperty);
                return annotation;
            }
        }
        return annotation;
    }

    private String _formatConfigurationAttributes(String fileName, String absolutePath, JavaClass javaClass, String annotation) {
        String configurationPid = this.getAnnotationAttributeValue(annotation, "configurationPid");
        if (configurationPid != null) {
            return this._formatConfigurationPid(fileName, absolutePath, javaClass, annotation, configurationPid);
        }
        for (JavaMethod javaMethod : this._getJavaMethods(javaClass, "Activate", "Modified")) {
            String javaMethodContent = javaMethod.getContent();
            if (!javaMethodContent.contains("ConfigurableUtil.createConfigurable")) continue;
            this.addMessage(fileName, "Missing @Component 'configurationPid' attribute, see LPS-88783");
            break;
        }
        if (!this.isAttributeValue(_CHECK_CONFIGURATION_POLICY_ATTRIBUTE_KEY, absolutePath)) {
            return annotation;
        }
        List<String> imports = javaClass.getImportNames();
        if (imports.contains("org.osgi.service.component.annotations.Modified") || this.getAnnotationAttributeValue(annotation, "configurationPolicy ") != null) {
            return annotation;
        }
        for (JavaMethod javaMethod : this._getJavaMethods(javaClass, "Activate")) {
            JavaSignature signature = javaMethod.getSignature();
            for (JavaParameter parameter : signature.getParameters()) {
                String parameterType = parameter.getParameterType();
                if (!parameterType.equals("ComponentContext") && !parameterType.startsWith("Map<")) continue;
                return annotation;
            }
        }
        return this._addAttribute(annotation, "configurationPolicy", "ConfigurationPolicy.IGNORE");
    }

    private String _formatConfigurationPid(String fileName, String absolutePath, JavaClass javaClass, String annotation, String configurationPid) {
        if (!this.isAttributeValue(_CHECK_CONFIGURATION_PID_ATTRIBUTE_KEY, absolutePath)) {
            return annotation;
        }
        ArrayList<String> configurationClasses = new ArrayList<String>();
        if (StringUtil.startsWith(configurationPid, '{')) {
            configurationPid = configurationPid.substring(1, configurationPid.length() - 1);
            for (String configurationClass : StringUtil.split(configurationPid, ", ")) {
                configurationClasses.add(configurationClass);
            }
        } else {
            configurationClasses.add(configurationPid);
        }
        List<String> importNames = javaClass.getImportNames();
        for (String configurationClass : configurationClasses) {
            File javaFile;
            if (!(configurationClass = StringUtil.unquote(configurationClass)).startsWith("com.liferay")) continue;
            int pos = configurationClass.lastIndexOf(".scoped");
            if (pos != -1) {
                configurationClass = configurationClass.substring(0, pos);
            }
            if (importNames.contains(configurationClass) || (javaFile = JavaSourceUtil.getJavaFile(configurationClass, this._getRootDirName(absolutePath), this._getBundleSymbolicNamesMap(absolutePath))) != null) continue;
            String message = StringBundler.concat("Remove '", configurationClass, "' from 'configurationPid' as the configuration class ", "does not exist");
            this.addMessage(fileName, message);
        }
        return annotation;
    }

    private String _formatEnabledAttribute(String absolutePath, String annotation) {
        if (absolutePath.contains("-test/") || absolutePath.contains("-test-util/")) {
            return annotation;
        }
        List<String> enterpriseAppModulePathNames = this.getAttributeValues(_ENTERPRISE_APP_MODULE_PATH_NAMES_KEY, absolutePath);
        if (enterpriseAppModulePathNames.isEmpty()) {
            return annotation;
        }
        for (String enterpriseAppModulePathName : enterpriseAppModulePathNames) {
            String enabledAttributeValue;
            if (!absolutePath.contains(enterpriseAppModulePathName) || (enabledAttributeValue = this.getAnnotationAttributeValue(annotation, "enabled")) != null) continue;
            return this._addAttribute(annotation, "enabled", "false");
        }
        return annotation;
    }

    private String _formatMVCPortletProperties(String absolutePath, String annotation) {
        int x = annotation.indexOf("property = {");
        if (x == -1) {
            return annotation;
        }
        int y = x;
        while (ToolsUtil.isInsideQuotes(annotation, y = annotation.indexOf(125, y + 1))) {
        }
        String properties = annotation.substring(x, y);
        String newProperties = StringUtil.replace(properties, new String[]{"\"javax.portlet.supports.mime-type=text/html\",", "\"javax.portlet.supports.mime-type=text/html\""}, new String[]{"", ""});
        if (newProperties.contains("\"javax.portlet.init-param.config-template=") && !newProperties.contains("javax.portlet.portlet-mode=")) {
            newProperties = this._addNewProperties(newProperties, "\"javax.portlet.portlet-mode=text/html;config\"");
        }
        if (this.isAttributeValue(_CHECK_PORTLET_VERSION_KEY, absolutePath) && !absolutePath.contains("/modules/apps/archived/") && !absolutePath.contains("/modules/sdk/") && !newProperties.contains("\"javax.portlet.version=3.0\"")) {
            List<String> serviceAttributeValues;
            String serviceAttributeValue = this.getAnnotationAttributeValue(annotation, "service");
            if (serviceAttributeValue.startsWith("{") && serviceAttributeValue.endsWith("}")) {
                serviceAttributeValue = serviceAttributeValue.substring(1, serviceAttributeValue.length() - 1);
            }
            if ((serviceAttributeValues = ListUtil.fromString(serviceAttributeValue, ",")).contains("Portlet.class")) {
                newProperties = this._addNewProperties(newProperties, "\"javax.portlet.version=3.0\"");
            }
        }
        return StringUtil.replace(annotation, properties, newProperties);
    }

    private String _formatServiceAttribute(String fileName, String absolutePath, String className, String annotation, List<String> implementedClassNames) {
        String expectedServiceAttributeValue = this._getExpectedServiceAttributeValue(implementedClassNames);
        String serviceAttributeValue = this.getAnnotationAttributeValue(annotation, "service");
        if (serviceAttributeValue == null) {
            return this._addAttribute(annotation, "service", expectedServiceAttributeValue);
        }
        boolean checkMismatchedServiceAttribute = this.isAttributeValue(_CHECK_MISMATCHED_SERVICE_ATTRIBUTE_KEY, absolutePath);
        boolean checkSelfRegistration = this.isAttributeValue(_CHECK_SELF_REGISTRATION_KEY, absolutePath);
        if (!checkMismatchedServiceAttribute && !checkSelfRegistration) {
            return annotation;
        }
        if (checkMismatchedServiceAttribute && !serviceAttributeValue.equals(expectedServiceAttributeValue)) {
            this.addMessage(fileName, "Mismatched @Component 'service' attribute");
        }
        if (checkSelfRegistration && serviceAttributeValue.matches(".*\\b" + className + "\\.class.*")) {
            this.addMessage(fileName, "No need to register '" + className + "' in @Component 'service' attribute");
        }
        return annotation;
    }

    private synchronized Map<String, String> _getBundleSymbolicNamesMap(String absolutePath) {
        if (this._bundleSymbolicNamesMap == null) {
            this._bundleSymbolicNamesMap = BNDSourceUtil.getBundleSymbolicNamesMap(this._getRootDirName(absolutePath));
        }
        return this._bundleSymbolicNamesMap;
    }

    private String _getExpectedServiceAttributeValue(List<String> implementedClassNames) {
        if (implementedClassNames.isEmpty()) {
            return "{}";
        }
        if (implementedClassNames.size() == 1) {
            return implementedClassNames.get(0) + ".class";
        }
        StringBundler sb = new StringBundler(implementedClassNames.size() * 3 + 1);
        sb.append("{");
        for (String implementedClassName : implementedClassNames) {
            sb.append(implementedClassName);
            sb.append(".class");
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append("}");
        return sb.toString();
    }

    private List<JavaMethod> _getJavaMethods(JavaClass javaClass, String ... annotations) {
        ArrayList<JavaMethod> javaMethods = new ArrayList<JavaMethod>();
        block0: for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            if (!(javaTerm instanceof JavaMethod)) continue;
            for (String annotation : annotations) {
                if (!javaTerm.hasAnnotation(annotation)) continue;
                javaMethods.add((JavaMethod)javaTerm);
                continue block0;
            }
        }
        return javaMethods;
    }

    private synchronized String _getRootDirName(String absolutePath) {
        if (this._rootDirName == null) {
            this._rootDirName = SourceUtil.getRootDirName(absolutePath);
        }
        return this._rootDirName;
    }

    private class AnnotationParameterPropertyComparator
    extends NaturalOrderStringComparator {
        private final String _parameterName;

        public AnnotationParameterPropertyComparator(String parameterName) {
            this._parameterName = parameterName;
        }

        @Override
        public int compare(String property1, String property2) {
            String propertyName2;
            if (!this._parameterName.equals("property")) {
                return super.compare(property1, property2);
            }
            String propertyName1 = this._getPropertyName(property1);
            if (propertyName1.equals(propertyName2 = this._getPropertyName(property2))) {
                return super.compare(property1, property2);
            }
            int value = super.compare(propertyName1, propertyName2);
            if (propertyName1.startsWith("\"") ^ propertyName2.startsWith("\"")) {
                return -value;
            }
            return value;
        }

        private String _getPropertyName(String property) {
            int x = property.indexOf("=");
            if (x != -1) {
                return property.substring(0, x);
            }
            return property;
        }
    }
}

