/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.poshi.core.util.FileUtil;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.source.formatter.check.JavaAnnotationsCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaReferenceAnnotationsCheck
extends JavaAnnotationsCheck {
    private static final String _IGNORE_TARGET_ATTRIBUTE_VALUES_KEY = "ignoreTargetAttributeValues";
    private static final Pattern _classConstantPattern = Pattern.compile("^([A-Z]\\w+)\\.?([A-Z]\\w+)$");
    private static final Pattern _componentNamePattern = Pattern.compile("\\(component\\.name=([^)]+)\\)");
    private volatile Map<String, String> _bundleSymbolicNamesMap;
    private final Map<String, JavaClass> _javaClassMap = new ConcurrentHashMap<String, JavaClass>();
    private volatile String _rootDirName;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String formatAnnotation(String fileName, String absolutePath, JavaClass javaClass, String fileContent, String annotation, String indent) throws Exception {
        String trimmedAnnotation = StringUtil.trim(annotation);
        if (!trimmedAnnotation.equals("@Reference") && !trimmedAnnotation.startsWith("@Reference(")) {
            return annotation;
        }
        List<String> importNames = javaClass.getImportNames();
        if (!importNames.contains("org.osgi.service.component.annotations.Reference")) {
            return annotation;
        }
        this._checkTargetAttribute(fileName, absolutePath, javaClass, annotation);
        return annotation;
    }

    private void _checkTargetAttribute(String fileName, String absolutePath, JavaClass javaClass, String annotation) throws Exception {
        String targetAttributeValue = this.getAnnotationAttributeValue(annotation, "target");
        List<String> ignoreTargetAttributeValues = this.getAttributeValues(_IGNORE_TARGET_ATTRIBUTE_VALUES_KEY, absolutePath);
        if (targetAttributeValue == null || ignoreTargetAttributeValues.contains(targetAttributeValue)) {
            return;
        }
        String componentName = this._getComponentName(absolutePath, javaClass, targetAttributeValue);
        if (componentName == null) {
            return;
        }
        if (componentName.contains("+")) {
            componentName = StringUtil.regexReplaceAll(componentName, "[^\\w\\.]", "");
        }
        if (componentName.contains("*")) {
            this.addMessage(fileName, "Do not use globs for the 'component.name'. Use the fully qualified name of the component class.");
            return;
        }
        if (!componentName.startsWith("com.liferay")) {
            return;
        }
        JavaClass componentJavaClass = this._getJavaClass(absolutePath, componentName);
        if (componentJavaClass != null) {
            List<String> importNames = componentJavaClass.getImportNames();
            if (componentJavaClass.hasAnnotation("Component") && importNames.contains("org.osgi.service.component.annotations.Component")) {
                return;
            }
        }
        this.addMessage(fileName, "The value '" + componentName + "' is not a valid OSGi component");
    }

    private Map<String, String> _getBundleSymbolicNamesMap(String absolutePath) {
        Map<String, String> bundleSymbolicNamesMap = this._bundleSymbolicNamesMap;
        if (bundleSymbolicNamesMap == null) {
            this._bundleSymbolicNamesMap = bundleSymbolicNamesMap = BNDSourceUtil.getBundleSymbolicNamesMap(this._getRootDirName(absolutePath));
        }
        return bundleSymbolicNamesMap;
    }

    private String _getComponentName(String absolutePath, JavaClass javaClass, String targetAttributeValue) throws Exception {
        Matcher classConstantMatcher = _classConstantPattern.matcher(targetAttributeValue);
        if (!classConstantMatcher.find()) {
            Matcher componentNameMatcher = _componentNamePattern.matcher(targetAttributeValue);
            if (componentNameMatcher.find()) {
                return componentNameMatcher.group(1);
            }
            return null;
        }
        String classConstantName = classConstantMatcher.group(1);
        JavaClass classConstantJavaClass = javaClass;
        if (classConstantMatcher.groupCount() == 2) {
            String className = classConstantMatcher.group(1);
            String fullyQualifiedName = javaClass.getPackageName() + "." + className;
            for (String importName : javaClass.getImportNames()) {
                if (!importName.endsWith(className)) continue;
                fullyQualifiedName = importName;
                break;
            }
            classConstantName = classConstantMatcher.group(2);
            classConstantJavaClass = this._getJavaClass(absolutePath, fullyQualifiedName);
        }
        if (classConstantJavaClass != null) {
            for (JavaTerm javaTerm : classConstantJavaClass.getChildJavaTerms()) {
                JavaVariable javaVariable;
                if (!javaTerm.isJavaVariable() || !classConstantName.equals((javaVariable = (JavaVariable)javaTerm).getName())) continue;
                Matcher componentNameMatcher = _componentNamePattern.matcher(javaVariable.getContent());
                if (componentNameMatcher.find()) {
                    return componentNameMatcher.group(1);
                }
                return null;
            }
        }
        return null;
    }

    private JavaClass _getJavaClass(String absolutePath, String fullyQualifiedName) throws Exception {
        File javaFile;
        JavaClass javaClass = this._javaClassMap.get(fullyQualifiedName);
        if (javaClass == null && (javaFile = JavaSourceUtil.getJavaFile(fullyQualifiedName, this._getRootDirName(absolutePath), this._getBundleSymbolicNamesMap(absolutePath))) != null) {
            javaClass = JavaClassParser.parseJavaClass(javaFile.getName(), FileUtil.read(javaFile));
            this._javaClassMap.put(fullyQualifiedName, javaClass);
        }
        return javaClass;
    }

    private String _getRootDirName(String absolutePath) {
        String rootDirName = this._rootDirName;
        if (rootDirName == null) {
            this._rootDirName = rootDirName = JavaSourceUtil.getRootDirName(absolutePath);
        }
        return rootDirName;
    }
}

