/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class ServiceComponentRuntimeCheck
extends BaseCheck {
    private static final String[] _METHOD_NAMES = new String[]{"disableComponent", "enableComponent"};
    private static final String _MSG_PROMISE_GET_VALUE = "promise.get.value";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String absolutePath = this.getAbsolutePath();
        if (!(absolutePath.contains("/test/") || absolutePath.contains("/testIntegration/") || absolutePath.endsWith("Test.java"))) {
            return;
        }
        List<String> importNames = this.getImportNames(detailAST);
        if (!importNames.contains("org.osgi.service.component.runtime.ServiceComponentRuntime")) {
            return;
        }
        String serviceComponentRuntimeVariableName = this._getServiceComponentRuntimeVariableName(detailAST);
        if (serviceComponentRuntimeVariableName == null) {
            return;
        }
        for (DetailAST methodDefDetailAST : this.getAllChildTokens(detailAST, true, 9)) {
            for (DetailAST methodCallDetailAST : this.getMethodCalls(methodDefDetailAST, serviceComponentRuntimeVariableName, _METHOD_NAMES)) {
                DetailAST slistDetailAST;
                DetailAST assignDetailAST = this.getParentWithTokenType(methodCallDetailAST, 80);
                if (assignDetailAST == null) {
                    this.log(methodCallDetailAST, _MSG_PROMISE_GET_VALUE, new Object[]{this.getMethodName(methodCallDetailAST)});
                    continue;
                }
                String promiseVariableName = this.getName(assignDetailAST);
                if (promiseVariableName == null) {
                    promiseVariableName = this.getName(assignDetailAST.getParent());
                }
                if (!ListUtil.isEmpty(this.getMethodCalls(slistDetailAST = methodDefDetailAST.findFirstToken(7), promiseVariableName, "getValue"))) continue;
                this.log(assignDetailAST, _MSG_PROMISE_GET_VALUE, new Object[]{this.getMethodName(methodCallDetailAST)});
            }
        }
    }

    private String _getServiceComponentRuntimeVariableName(DetailAST classDefDetailAST) {
        DetailAST objBlockDetailAST = classDefDetailAST.findFirstToken(6);
        for (DetailAST variableDefDetailAST : this.getAllChildTokens(objBlockDetailAST, false, 10)) {
            String variableName;
            String variableTypeName = this.getVariableTypeName(variableDefDetailAST, variableName = this.getName(variableDefDetailAST), false);
            if (!variableTypeName.equals("ServiceComponentRuntime")) continue;
            return variableName;
        }
        return null;
    }
}

