/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.processor;

import com.liferay.petra.nio.CharsetDecoderUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.check.SourceCheck;
import com.liferay.source.formatter.check.configuration.SourceChecksResult;
import com.liferay.source.formatter.check.configuration.SourceFormatterConfiguration;
import com.liferay.source.formatter.check.configuration.SourceFormatterSuppressions;
import com.liferay.source.formatter.check.util.SourceChecksUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.Checker;
import com.liferay.source.formatter.checkstyle.util.CheckstyleLogger;
import com.liferay.source.formatter.processor.SourceProcessor;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public abstract class BaseSourceProcessor
implements SourceProcessor {
    private static final Log _log = LogFactoryUtil.getLog(BaseSourceProcessor.class);
    private List<String> _allFileNames;
    private final List<String> _modifiedFileNames = new CopyOnWriteArrayList<String>();
    private List<String> _pluginsInsideModulesDirectoryNames;
    private boolean _portalSource;
    private String _projectPathPrefix;
    private Map<String, Properties> _propertiesMap;
    private Set<SourceCheck> _sourceChecks;
    private SourceFormatterArgs _sourceFormatterArgs;
    private SourceFormatterConfiguration _sourceFormatterConfiguration;
    private SourceFormatterExcludes _sourceFormatterExcludes;
    private final Map<String, Set<SourceFormatterMessage>> _sourceFormatterMessagesMap = new ConcurrentHashMap<String, Set<SourceFormatterMessage>>();
    private SourceFormatterSuppressions _sourceFormatterSuppressions;
    private final List<SourceMismatchException> _sourceMismatchExceptions = new ArrayList<SourceMismatchException>();
    private boolean _subrepository;

    @Override
    public final void format() throws Exception {
        List<String> fileNames = this.getFileNames();
        if (this._sourceFormatterArgs.isShowDebugInformation()) {
            Class<?> clazz = this.getClass();
            DebugUtil.addProcessorFileCount(clazz.getSimpleName(), fileNames.size());
        }
        if (fileNames.isEmpty()) {
            return;
        }
        this.preFormat();
        this._sourceChecks = this._getSourceChecks(fileNames);
        ExecutorService executorService = Executors.newFixedThreadPool(this._sourceFormatterArgs.getProcessorThreadCount());
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(fileNames.size());
        for (final String string : fileNames) {
            Future<Void> future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() {
                    BaseSourceProcessor.this._performTask(string);
                    return null;
                }
            });
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        this.postFormat();
    }

    public final List<String> getFileNames() throws Exception {
        List<String> fileNames = this._sourceFormatterArgs.getFileNames();
        if (fileNames != null) {
            return SourceFormatterUtil.filterFileNames(fileNames, new String[0], this.getIncludes(), new SourceFormatterExcludes(), false);
        }
        return this.doGetFileNames();
    }

    @Override
    public String[] getIncludes() {
        return this.filterIncludes(this.doGetIncludes());
    }

    @Override
    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    @Override
    public SourceFormatterArgs getSourceFormatterArgs() {
        return this._sourceFormatterArgs;
    }

    @Override
    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        TreeSet<SourceFormatterMessage> sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        for (Map.Entry<String, Set<SourceFormatterMessage>> entry : this._sourceFormatterMessagesMap.entrySet()) {
            sourceFormatterMessages.addAll((Collection<SourceFormatterMessage>)entry.getValue());
        }
        return sourceFormatterMessages;
    }

    @Override
    public List<SourceMismatchException> getSourceMismatchExceptions() {
        return this._sourceMismatchExceptions;
    }

    @Override
    public boolean isPortalSource() {
        return this._portalSource;
    }

    @Override
    public boolean isSubrepository() {
        return this._subrepository;
    }

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    @Override
    public void setPluginsInsideModulesDirectoryNames(List<String> pluginsInsideModulesDirectoryNames) {
        this._pluginsInsideModulesDirectoryNames = pluginsInsideModulesDirectoryNames;
    }

    @Override
    public void setPortalSource(boolean portalSource) {
        this._portalSource = portalSource;
    }

    @Override
    public void setProjectPathPrefix(String projectPathPrefix) {
        this._projectPathPrefix = projectPathPrefix;
    }

    @Override
    public void setPropertiesMap(Map<String, Properties> propertiesMap) {
        this._propertiesMap = propertiesMap;
    }

    @Override
    public void setSourceFormatterArgs(SourceFormatterArgs sourceFormatterArgs) {
        this._sourceFormatterArgs = sourceFormatterArgs;
    }

    @Override
    public void setSourceFormatterConfiguration(SourceFormatterConfiguration sourceFormatterConfiguration) {
        this._sourceFormatterConfiguration = sourceFormatterConfiguration;
    }

    @Override
    public void setSourceFormatterExcludes(SourceFormatterExcludes sourceFormatterExcludes) {
        this._sourceFormatterExcludes = sourceFormatterExcludes;
    }

    @Override
    public void setSourceFormatterSuppressions(SourceFormatterSuppressions sourceFormatterSuppressions) {
        this._sourceFormatterSuppressions = sourceFormatterSuppressions;
    }

    @Override
    public void setSubrepository(boolean subrepository) {
        this._subrepository = subrepository;
    }

    protected abstract List<String> doGetFileNames() throws Exception;

    protected abstract String[] doGetIncludes();

    protected String[] filterIncludes(String[] includes) {
        List<String> fileExtensions = this._sourceFormatterArgs.getFileExtensions();
        if (fileExtensions.isEmpty()) {
            return includes;
        }
        String[] filteredIncludes = new String[]{};
        for (String include : includes) {
            for (String fileExtension : fileExtensions) {
                if (!include.endsWith(fileExtension)) continue;
                filteredIncludes = ArrayUtil.append(filteredIncludes, include);
            }
        }
        return filteredIncludes;
    }

    protected File format(File file, String fileName, String absolutePath, String content) throws Exception {
        HashSet<String> modifiedContents = new HashSet<String>();
        TreeSet<String> modifiedMessages = new TreeSet<String>();
        String newContent = this.format(file, fileName, absolutePath, content, content, new ArrayList<SourceCheck>(this._sourceChecks), modifiedContents, modifiedMessages, 0);
        return this.processFormattedFile(file, fileName, content, newContent, modifiedMessages);
    }

    protected String format(File file, String fileName, String absolutePath, String content, String originalContent, List<SourceCheck> sourceChecks, Set<String> modifiedContents, Set<String> modifiedMessages, int count) throws Exception {
        SourceCheck sourceCheck;
        this._sourceFormatterMessagesMap.remove(fileName);
        String newContent = content;
        List<String> checkCategoryNames = this._sourceFormatterArgs.getCheckCategoryNames();
        if (checkCategoryNames.contains("Styling") || checkCategoryNames.isEmpty() && ListUtil.isEmpty(this._sourceFormatterArgs.getCheckNames())) {
            this._checkUTF8(file, fileName);
            newContent = StringUtil.replace(newContent, "\r\n", "\n");
            if (!content.equals(newContent)) {
                modifiedMessages.add(file.toString() + " (ReturnCharacter)");
            }
        }
        newContent = this.parse(file, fileName, newContent, modifiedMessages);
        SourceChecksResult sourceChecksResult = this._processSourceChecks(file, fileName, absolutePath, newContent, sourceChecks, modifiedMessages);
        if ((newContent = sourceChecksResult.getContent()) == null || content.equals(newContent)) {
            return newContent;
        }
        if (!modifiedContents.add(newContent)) {
            this._sourceFormatterMessagesMap.remove(fileName);
            this.processMessage(fileName, "Infinite loop in SourceFormatter");
            return originalContent;
        }
        if (newContent.length() > content.length()) {
            if (++count > 10000) {
                this._sourceFormatterMessagesMap.remove(fileName);
                this.processMessage(fileName, "Infinite loop in SourceFormatter");
                return originalContent;
            }
        } else {
            count = 0;
        }
        if ((sourceCheck = sourceChecksResult.getMostRecentProcessedSourceCheck()) != null) {
            sourceChecks.remove(sourceCheck);
            sourceChecks.add(0, sourceCheck);
        }
        return this.format(file, fileName, absolutePath, newContent, originalContent, sourceChecks, modifiedContents, modifiedMessages, count);
    }

    protected List<String> getAllFileNames() {
        return this._allFileNames;
    }

    protected File getFile(String fileName, int level) {
        return SourceFormatterUtil.getFile(this._sourceFormatterArgs.getBaseDirName(), fileName, level);
    }

    protected List<String> getFileNames(String[] excludes, String[] includes) throws IOException {
        return this.getFileNames(excludes, includes, false);
    }

    protected List<String> getFileNames(String[] excludes, String[] includes, boolean forceIncludeAllFiles) throws IOException {
        if (!forceIncludeAllFiles && SetUtil.isNotEmpty(this._sourceFormatterArgs.getRecentChangesFileNames())) {
            return SourceFormatterUtil.filterRecentChangesFileNames(this._sourceFormatterArgs.getRecentChangesFileNames(), excludes, includes, this._sourceFormatterExcludes);
        }
        return SourceFormatterUtil.filterFileNames(this._allFileNames, excludes, includes, this._sourceFormatterExcludes, forceIncludeAllFiles);
    }

    protected List<String> getPluginsInsideModulesDirectoryNames() {
        return this._pluginsInsideModulesDirectoryNames;
    }

    protected File getPortalDir() {
        File portalImplDir = SourceFormatterUtil.getFile(this._sourceFormatterArgs.getBaseDirName(), "portal-impl", this._sourceFormatterArgs.getMaxDirLevel());
        if (portalImplDir == null) {
            return null;
        }
        return portalImplDir.getParentFile();
    }

    protected Map<String, Properties> getPropertiesMap() {
        return this._propertiesMap;
    }

    protected Set<SourceCheck> getSourceChecks() {
        return this._sourceChecks;
    }

    protected SourceFormatterExcludes getSourceFormatterExcludes() {
        return this._sourceFormatterExcludes;
    }

    protected SourceFormatterSuppressions getSourceFormatterSuppressions() {
        return this._sourceFormatterSuppressions;
    }

    protected boolean hasGeneratedTag(String content) {
        return SourceUtil.containsUnquoted(content, "@generated") || SourceUtil.containsUnquoted(content, "$ANTLR") || SourceUtil.containsUnquoted(content, "## Autogenerated");
    }

    protected String parse(File file, String fileName, String content, Set<String> modifiedMessages) throws Exception {
        return content;
    }

    protected void postFormat() throws Exception {
    }

    protected void preFormat() throws Exception {
    }

    protected void printError(String fileName, String message) {
        if (this._sourceFormatterArgs.isPrintErrors()) {
            SourceFormatterUtil.printError(fileName, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<SourceFormatterMessage> processCheckstyle(Configuration configuration, CheckstyleLogger checkstyleLogger, Object object) throws CheckstyleException, IOException {
        Class<BaseSourceProcessor> clazz = BaseSourceProcessor.class;
        synchronized (BaseSourceProcessor.class) {
            Checker checker = new Checker(configuration, (AuditListener)checkstyleLogger, checkstyleLogger, this.getSourceFormatterSuppressions());
            if (object instanceof File[]) {
                checker.process(Arrays.asList((File[])object));
            } else if (object instanceof List) {
                checker.processFileContents((List)object);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return checker.getSourceFormatterMessages();
        }
    }

    protected File processFormattedFile(File file, String fileName, String content, String newContent, Set<String> modifiedMessages) throws IOException, URISyntaxException {
        Set<SourceFormatterMessage> sourceFormatterMessages;
        if (!content.equals(newContent)) {
            if (this._sourceFormatterArgs.isPrintErrors()) {
                for (String modifiedMessage : modifiedMessages) {
                    SourceFormatterUtil.printError(fileName, modifiedMessage);
                }
            }
            if (this._sourceFormatterArgs.isAutoFix()) {
                if (newContent != null) {
                    FileUtil.write(file, newContent);
                } else {
                    file.delete();
                }
            }
            this._sourceMismatchExceptions.add(new SourceMismatchException(fileName, content, newContent));
        }
        if (this._sourceFormatterArgs.isPrintErrors() && (sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName)) != null) {
            for (SourceFormatterMessage sourceFormatterMessage : sourceFormatterMessages) {
                SourceFormatterUtil.printError(fileName, sourceFormatterMessage.toString());
            }
        }
        this._modifiedFileNames.add(file.getAbsolutePath());
        return file;
    }

    protected void processMessage(String fileName, SourceFormatterMessage sourceFormatterMessage) {
        Set<SourceFormatterMessage> sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName);
        if (sourceFormatterMessages == null) {
            sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        }
        sourceFormatterMessages.add(sourceFormatterMessage);
        this._sourceFormatterMessagesMap.put(fileName, sourceFormatterMessages);
    }

    protected void processMessage(String fileName, String message) {
        this.processMessage(fileName, new SourceFormatterMessage(fileName, message));
    }

    private void _checkUTF8(File file, String fileName) throws Exception {
        byte[] bytes = FileUtil.getBytes(file);
        try {
            CharsetDecoder charsetDecoder = CharsetDecoderUtil.getCharsetDecoder("UTF-8", CodingErrorAction.REPORT);
            charsetDecoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            this.processMessage(fileName, "UTF-8");
        }
    }

    private boolean _containsModuleFile(List<String> fileNames) {
        if (this._subrepository) {
            return true;
        }
        if (!this._portalSource) {
            return false;
        }
        for (String fileName : fileNames) {
            if (!this._isMatchPath(fileName) || !this._isModulesFile(SourceUtil.getAbsolutePath(fileName), true)) continue;
            return true;
        }
        return false;
    }

    private void _format(String fileName) throws Exception {
        if (!this._isMatchPath(fileName)) {
            return;
        }
        fileName = StringUtil.replace(fileName, '\\', '/');
        String absolutePath = SourceUtil.getAbsolutePath(fileName);
        File file = new File(absolutePath);
        String content = FileUtil.read(file, false);
        if (!this._sourceFormatterArgs.isIncludeGeneratedFiles() && this.hasGeneratedTag(content)) {
            return;
        }
        this.format(file, fileName, absolutePath, content);
    }

    private Set<SourceCheck> _getSourceChecks(List<String> fileNames) throws Exception {
        Class<?> clazz = this.getClass();
        Set<SourceCheck> sourceChecks = SourceChecksUtil.getSourceChecks(this._sourceFormatterConfiguration, clazz.getSimpleName(), this.getPropertiesMap(), this._sourceFormatterArgs.getCheckNames(), this._sourceFormatterArgs.getCheckCategoryNames(), this._sourceFormatterArgs.getSkipCheckNames(), this._portalSource, this._subrepository, this._containsModuleFile(fileNames));
        for (SourceCheck sourceCheck : sourceChecks) {
            this._initSourceCheck(sourceCheck);
        }
        return sourceChecks;
    }

    private void _initSourceCheck(SourceCheck sourceCheck) {
        sourceCheck.setAllFileNames(this._allFileNames);
        sourceCheck.setBaseDirName(this._sourceFormatterArgs.getBaseDirName());
        sourceCheck.setFileExtensions(this._sourceFormatterArgs.getFileExtensions());
        sourceCheck.setFilterCheckNames(this._sourceFormatterArgs.getCheckNames());
        sourceCheck.setMaxDirLevel(this._sourceFormatterArgs.getMaxDirLevel());
        sourceCheck.setMaxLineLength(this._sourceFormatterArgs.getMaxLineLength());
        sourceCheck.setPluginsInsideModulesDirectoryNames(this._pluginsInsideModulesDirectoryNames);
        sourceCheck.setPortalSource(this._portalSource);
        sourceCheck.setProjectPathPrefix(this._projectPathPrefix);
        sourceCheck.setSourceFormatterExcludes(this._sourceFormatterExcludes);
        sourceCheck.setSubrepository(this._subrepository);
    }

    private boolean _isMatchPath(String fileName) {
        for (String pattern : this.getIncludes()) {
            if (!SelectorUtils.matchPath((String)this._normalizePattern(pattern), (String)fileName)) continue;
            return true;
        }
        return false;
    }

    private boolean _isModulesFile(String absolutePath) {
        return this._isModulesFile(absolutePath, false);
    }

    private boolean _isModulesFile(String absolutePath, boolean includePlugins) {
        block6: {
            if (this._subrepository || absolutePath.contains("/source/formatter/dependencies/")) {
                return true;
            }
            if (!this._portalSource) {
                return false;
            }
            if (includePlugins) {
                return absolutePath.contains("/modules/");
            }
            try {
                for (String directoryName : this._pluginsInsideModulesDirectoryNames) {
                    if (!absolutePath.contains(directoryName)) continue;
                    return false;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug(exception);
            }
        }
        return absolutePath.contains("/modules/");
    }

    private String _normalizePattern(String originalPattern) {
        String pattern = StringUtil.replace(originalPattern, '/', File.separatorChar);
        if ((pattern = StringUtil.replace(pattern, '\\', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    private void _performTask(String fileName) {
        try {
            if (!this._sourceFormatterArgs.isShowDebugInformation()) {
                this._format(fileName);
                return;
            }
            DebugUtil.startTask();
            this._format(fileName);
            DebugUtil.finishTask();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to format " + fileName, throwable);
        }
    }

    private SourceChecksResult _processSourceChecks(File file, String fileName, String absolutePath, String content, List<SourceCheck> sourceChecks, Set<String> modifiedMessages) throws Exception {
        SourceChecksResult sourceChecksResult = SourceChecksUtil.processSourceChecks(file, fileName, absolutePath, content, this, modifiedMessages, this._isModulesFile(absolutePath), sourceChecks, this._sourceFormatterSuppressions, this._sourceFormatterArgs.isShowDebugInformation());
        for (SourceFormatterMessage sourceFormatterMessage : sourceChecksResult.getSourceFormatterMessages()) {
            this.processMessage(fileName, sourceFormatterMessage);
        }
        return sourceChecksResult;
    }
}

