/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.ParseException;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CETUtil {
    public static String getJSONContent(List<String> fileNames) throws IOException, ParseException {
        List<CET> cets = CETUtil._getCETs(fileNames);
        JSONArrayImpl cetJSONArray = new JSONArrayImpl();
        for (CET cet : cets) {
            JSONObjectImpl cetJSONObject = new JSONObjectImpl();
            cetJSONObject.put("description", cet.getDescription()).put("name", cet.getName());
            JSONArrayImpl cetPropertiesJSONArray = new JSONArrayImpl();
            List<CETProperty> cetProperties = cet.getCETProperties();
            for (CETProperty cetProperty : cetProperties) {
                String type;
                String name;
                JSONObjectImpl cetPropertiesJSONObject = new JSONObjectImpl();
                String defaultValue = cetProperty.getDefaultValue();
                if (defaultValue != null) {
                    cetPropertiesJSONObject.put("default", defaultValue);
                }
                if ((name = cetProperty.getName()) != null) {
                    cetPropertiesJSONObject.put("name", name);
                }
                if ((type = cetProperty.getType()) != null) {
                    cetPropertiesJSONObject.put("type", type);
                }
                cetPropertiesJSONArray.put(cetPropertiesJSONObject);
            }
            cetJSONObject.put("properties", cetPropertiesJSONArray);
            cetJSONArray.put(cetJSONObject);
        }
        return JSONUtil.toString(cetJSONArray);
    }

    private static CET _getCET(List<CETProperty> defaultCETProperties, JavaClass javaClass) throws IOException {
        ArrayList<CETProperty> cetProperties = new ArrayList<CETProperty>(defaultCETProperties);
        String description = null;
        String name = null;
        List<String> annotationsBlocks = SourceUtil.getAnnotationsBlocks(javaClass.getContent());
        for (String annotationsBlock : annotationsBlocks) {
            List<String> annotations = SourceUtil.splitAnnotations(annotationsBlock, SourceUtil.getIndent(annotationsBlock));
            for (String annotation : annotations) {
                annotation = annotation.trim();
                Map<String, String> annotationMemberValuePair = SourceUtil.getAnnotationMemberValuePair(annotation);
                if (annotation.startsWith("@CETProperty")) {
                    cetProperties.add(new CETProperty(annotationMemberValuePair.get("defaultValue"), annotationMemberValuePair.get("name"), annotationMemberValuePair.get("type")));
                    continue;
                }
                if (!annotation.startsWith("@CETType")) continue;
                description = annotationMemberValuePair.get("description");
                name = annotationMemberValuePair.get("name");
            }
        }
        return new CET(cetProperties, description, name);
    }

    private static List<CET> _getCETs(List<String> fileNames) throws IOException, ParseException {
        JavaClass baseCETJavaClass = null;
        ArrayList<JavaClass> cetJavaClasses = new ArrayList<JavaClass>();
        for (String fileName : new LinkedHashSet<String>(fileNames)) {
            String absolutePath;
            String fileContent;
            String normalizedFileName = StringUtil.replace(fileName, '\\', '/');
            JavaClass javaClass = JavaClassParser.parseJavaClass(normalizedFileName, fileContent = FileUtil.read(new File(absolutePath = SourceUtil.getAbsolutePath(normalizedFileName)), false));
            if (Objects.equals(javaClass.getName(), "CET")) {
                baseCETJavaClass = javaClass;
                continue;
            }
            cetJavaClasses.add(javaClass);
        }
        ArrayList<CETProperty> defaultCETProperties = new ArrayList<CETProperty>();
        if (baseCETJavaClass != null) {
            CET cet = CETUtil._getCET(Collections.emptyList(), baseCETJavaClass);
            defaultCETProperties.addAll(cet.getCETProperties());
        }
        ArrayList<CET> cets = new ArrayList<CET>();
        for (JavaClass cetJavaClass : cetJavaClasses) {
            CET cet = CETUtil._getCET(defaultCETProperties, cetJavaClass);
            if (Validator.isNull(cet.getName())) continue;
            cets.add(cet);
        }
        Collections.sort(cets, new Comparator<CET>(){

            @Override
            public int compare(CET cet1, CET cet2) {
                String name1 = cet1.getName();
                String name2 = cet2.getName();
                return name1.compareTo(name2);
            }
        });
        return cets;
    }

    private static class CETProperty {
        private final String _defaultValue;
        private final String _name;
        private final String _type;

        public CETProperty(String defaultValue, String name, String type) {
            this._defaultValue = defaultValue;
            this._name = name;
            this._type = type;
        }

        public String getDefaultValue() {
            return this._defaultValue;
        }

        public String getName() {
            return this._name;
        }

        public String getType() {
            return this._type;
        }
    }

    private static class CET {
        private final List<CETProperty> _cetProperties;
        private final String _description;
        private final String _name;

        public CET(List<CETProperty> cetProperties, String description, String name) {
            this._cetProperties = cetProperties;
            this._description = description;
            this._name = name;
        }

        public List<CETProperty> getCETProperties() {
            return this._cetProperties;
        }

        public String getDescription() {
            return this._description;
        }

        public String getName() {
            return this._name;
        }
    }
}

