/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.tools.GitUtil;
import com.liferay.portal.tools.java.parser.JavaParser;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaConstructor;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.LegacyPropertiesUtil;
import com.liferay.source.formatter.util.LegacyProperty;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class PortalJSONObjectUtil {
    private static final Pattern _elementPattern = Pattern.compile("<!ELEMENT ([\\w-]+) \\(");

    public static void deleteTempPortalJSONObjectFile() throws Exception {
        File tempPortalJSONObjectFile = new File(StringBundler.concat(SystemProperties.get("java.io.tmpdir"), File.separator, GitUtil.getLatestCommitId(), ".json"));
        if (tempPortalJSONObjectFile.exists()) {
            tempPortalJSONObjectFile.delete();
        }
    }

    public static JSONObject getPortalJSONObject(String dirName) throws Exception {
        return PortalJSONObjectUtil.getPortalJSONObject(dirName, new SourceFormatterExcludes(), 80);
    }

    public static JSONObject getPortalJSONObject(String dirName, SourceFormatterExcludes sourceFormatterExcludes, final int maxLineLength) throws Exception {
        File tempPortalJSONObjectFile = new File(StringBundler.concat(SystemProperties.get("java.io.tmpdir"), File.separator, GitUtil.getLatestCommitId(), ".json"));
        if (tempPortalJSONObjectFile.exists()) {
            return new JSONObjectImpl(FileUtil.read(tempPortalJSONObjectFile));
        }
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        ArrayList<Future<Tuple>> futures = new ArrayList<Future<Tuple>>();
        JSONObjectImpl portalJSONObject = new JSONObjectImpl();
        JSONObject taglibsJSONObject = new JSONObjectImpl();
        JSONObject xmlDefinitionsJSONObject = new JSONObjectImpl();
        List<String> fileNames = SourceFormatterUtil.scanForFiles(dirName, new String[0], new String[]{"**/*.dtd", "**/*.java", "**/resources/META-INF/*.tld", "**/resources/META-INF/**/*.tld", "**/src/META-INF/*.tld", "**/src/META-INF/**/*.tld"}, sourceFormatterExcludes, true);
        for (String fileName : fileNames) {
            final String string = StringUtil.replace(fileName, '\\', '/');
            if (string.endsWith(".dtd")) {
                xmlDefinitionsJSONObject = PortalJSONObjectUtil._addXMLdefinition(xmlDefinitionsJSONObject, string);
                continue;
            }
            if (string.endsWith(".tld")) {
                taglibsJSONObject = PortalJSONObjectUtil._addTaglib(taglibsJSONObject, string);
                continue;
            }
            if (!string.contains("/com/liferay/")) continue;
            if (string.endsWith("/VerifyProperties.java")) {
                portalJSONObject.put("legacyProperties", PortalJSONObjectUtil._getLegacyPropertiesJSONObject(string));
            }
            Future<Tuple> future = executorService.submit(new Callable<Tuple>(){

                @Override
                public Tuple call() throws Exception {
                    return PortalJSONObjectUtil._getClassTuple(string, maxLineLength);
                }
            });
            futures.add(future);
        }
        JSONObject javaClassesJSONObject = new JSONObjectImpl();
        for (Future future : futures) {
            try {
                javaClassesJSONObject = PortalJSONObjectUtil._addJavaClassJSONObject(javaClassesJSONObject, (Tuple)future.get(1L, TimeUnit.MINUTES));
            }
            catch (Exception exception) {
                future.cancel(true);
            }
        }
        executorService.shutdown();
        portalJSONObject.put("javaClasses", javaClassesJSONObject).put("taglibs", taglibsJSONObject).put("xmlDefinitions", xmlDefinitionsJSONObject);
        FileUtil.write(tempPortalJSONObjectFile, JSONUtil.toString(portalJSONObject));
        return portalJSONObject;
    }

    public static JSONObject getPortalJSONObjectByVersion(String version) throws Exception {
        return new JSONObjectImpl();
    }

    private static JSONArray _addElementValues(JSONArray elementJSONArray, String s) {
        if ((s = s.replaceAll("^\\s*\\(?(.+?)[?*+]?\\)?[?*+]?\\s*$", "$1")).equals("#PCDATA")) {
            return elementJSONArray;
        }
        if (s.contains(",")) {
            String[] parts;
            for (String part : parts = StringUtil.split(s, ',')) {
                elementJSONArray = PortalJSONObjectUtil._addElementValues(elementJSONArray, part);
            }
            return elementJSONArray;
        }
        if (s.contains("|")) {
            String[] parts;
            for (String part : parts = StringUtil.split(s, '|')) {
                elementJSONArray = PortalJSONObjectUtil._addElementValues(elementJSONArray, part);
            }
            return elementJSONArray;
        }
        if (s.matches("[\\w-]+")) {
            elementJSONArray.put(s);
        }
        return elementJSONArray;
    }

    private static synchronized JSONObject _addJavaClassJSONObject(JSONObject javaClassesJSONObject, Tuple tuple) {
        String className = (String)tuple.getObject(0);
        JSONObject classJSONObject = (JSONObject)tuple.getObject(1);
        if (!javaClassesJSONObject.has(className)) {
            javaClassesJSONObject.put(className, classJSONObject);
        } else {
            javaClassesJSONObject.put(className, PortalJSONObjectUtil._mergeClassJSONObjects(classJSONObject, javaClassesJSONObject.getJSONObject(className)));
        }
        return javaClassesJSONObject;
    }

    private static JSONObject _addTaglib(JSONObject taglibsJSONObject, String fileName) {
        File tldFile = new File(fileName);
        Document document = null;
        try {
            document = SourceUtil.readXML(FileUtil.read(tldFile));
        }
        catch (Exception exception) {
            return taglibsJSONObject;
        }
        Element rootElement = document.getRootElement();
        if (!Objects.equals(rootElement.getName(), "taglib")) {
            return taglibsJSONObject;
        }
        Element shortNameElement = rootElement.element("short-name");
        if (shortNameElement == null) {
            return taglibsJSONObject;
        }
        JSONObjectImpl taglibJSONObject = new JSONObjectImpl();
        List tagElements = rootElement.elements("tag");
        for (Element tagElement : tagElements) {
            String description;
            Element tagDescriptionElement;
            Element tagClassElement = tagElement.element("tag-class");
            String tagClassName = tagClassElement.getStringValue();
            if (!tagClassName.startsWith("com.liferay")) continue;
            JSONObjectImpl tagJSONObject = new JSONObjectImpl();
            JSONArrayImpl tagAttributeNamesJSONArray = new JSONArrayImpl();
            List attributeElements = tagElement.elements("attribute");
            for (Element attributeElement : attributeElements) {
                String description2;
                JSONObjectImpl attributeJSONObject = new JSONObjectImpl();
                Element attributeDescriptionElement = attributeElement.element("description");
                if (attributeDescriptionElement != null && (description2 = attributeDescriptionElement.getStringValue()).startsWith("Deprecated")) {
                    attributeJSONObject.put("deprecated", true);
                }
                Element attributeNameElement = attributeElement.element("name");
                attributeJSONObject.put("name", attributeNameElement.getStringValue());
                tagAttributeNamesJSONArray.put(attributeJSONObject);
            }
            if (tagAttributeNamesJSONArray.length() > 0) {
                tagJSONObject.put("attributes", tagAttributeNamesJSONArray);
            }
            if ((tagDescriptionElement = tagElement.element("description")) != null && (description = tagDescriptionElement.getStringValue()).startsWith("Deprecated")) {
                tagJSONObject.put("deprecated", true);
            }
            Element tagNameElement = tagElement.element("name");
            taglibJSONObject.put(tagNameElement.getStringValue(), tagJSONObject);
        }
        taglibsJSONObject.put(shortNameElement.getStringValue(), taglibJSONObject);
        return taglibsJSONObject;
    }

    private static JSONObject _addXMLdefinition(JSONObject xmlDefinitionsJSONObject, String fileName) throws Exception {
        int x;
        if (!fileName.matches(".*_[0-9]_[0-9]_[0-9]\\.dtd")) {
            return xmlDefinitionsJSONObject;
        }
        JSONObjectImpl xmlDefinitionJSONObject = new JSONObjectImpl();
        File dtdFile = new File(fileName);
        String content = FileUtil.read(dtdFile);
        Matcher matcher = _elementPattern.matcher(content);
        while (matcher.find()) {
            x = content.indexOf(">", matcher.end());
            if (x == -1) {
                return xmlDefinitionJSONObject;
            }
            JSONArray elementJSONArray = PortalJSONObjectUtil._addElementValues(new JSONArrayImpl(), content.substring(matcher.end() - 1, x));
            if (elementJSONArray.length() <= 0) continue;
            xmlDefinitionJSONObject.put(matcher.group(1), elementJSONArray);
        }
        if (xmlDefinitionJSONObject.length() > 0) {
            x = fileName.lastIndexOf("/");
            xmlDefinitionsJSONObject.put(fileName.substring(x + 1), xmlDefinitionJSONObject);
        }
        return xmlDefinitionsJSONObject;
    }

    private static Tuple _getClassTuple(String fileName, int maxLineLength) throws Exception {
        JSONArray variablesJSONArray;
        JSONArray methodsJSONArray;
        JSONArray implementedClassesJSONArray;
        JSONArray extendedClassesJSONArray;
        String content = JavaParser.parse(new File(fileName), maxLineLength, false);
        JavaClass javaClass = null;
        try {
            javaClass = JavaClassParser.parseJavaClass(fileName, content);
        }
        catch (Exception exception) {
            return null;
        }
        String className = javaClass.getName(true);
        if (!className.startsWith("com.liferay.")) {
            return null;
        }
        JSONObjectImpl classJSONObject = new JSONObjectImpl();
        JSONArray constructorsJSONArray = PortalJSONObjectUtil._getConstructorsJSONArray(javaClass);
        if (constructorsJSONArray.length() > 0) {
            classJSONObject.put("constructors", constructorsJSONArray);
        }
        if (javaClass.hasAnnotation("Deprecated")) {
            classJSONObject.put("deprecated", true);
        }
        if ((extendedClassesJSONArray = PortalJSONObjectUtil._getExtendedClassesJSONArray(javaClass)).length() > 0) {
            classJSONObject.put("extendedClassNames", extendedClassesJSONArray);
        }
        if ((implementedClassesJSONArray = PortalJSONObjectUtil._getImplementedClassesJSONArray(javaClass)).length() > 0) {
            classJSONObject.put("implementedClassNames", implementedClassesJSONArray);
        }
        if ((methodsJSONArray = PortalJSONObjectUtil._getMethodsJSONArray(javaClass)).length() > 0) {
            classJSONObject.put("methods", methodsJSONArray);
        }
        if ((variablesJSONArray = PortalJSONObjectUtil._getVariablesJSONArray(javaClass)).length() > 0) {
            classJSONObject.put("variables", variablesJSONArray);
        }
        return new Tuple(javaClass.getName(true), classJSONObject);
    }

    private static JSONArray _getConstructorsJSONArray(JavaClass javaClass) {
        JSONArrayImpl constructorsJSONArray = new JSONArrayImpl();
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaConstructor() || childJavaTerm.isPrivate()) continue;
            JavaConstructor javaConstructor = (JavaConstructor)childJavaTerm;
            JSONObjectImpl constructorJSONObject = new JSONObjectImpl();
            constructorJSONObject.put("accessModifier", javaConstructor.getAccessModifier());
            if (javaConstructor.hasAnnotation("Deprecated")) {
                constructorJSONObject.put("deprecated", true);
            }
            constructorJSONObject.put("name", javaConstructor.getName());
            if (javaConstructor.hasAnnotation("Override")) {
                constructorJSONObject.put("override", true);
            }
            JavaSignature javaSignature = null;
            try {
                javaSignature = javaConstructor.getSignature();
            }
            catch (Exception exception) {
                continue;
            }
            List<JavaParameter> parameters = javaSignature.getParameters();
            if (!parameters.isEmpty()) {
                JSONArrayImpl parametersJSONArray = new JSONArrayImpl();
                for (JavaParameter javaParameter : parameters) {
                    parametersJSONArray.put(javaParameter.getParameterType(true));
                }
                constructorJSONObject.put("parameters", parametersJSONArray);
            }
            constructorsJSONArray.put(constructorJSONObject);
        }
        return constructorsJSONArray;
    }

    private static JSONArray _getExtendedClassesJSONArray(JavaClass javaClass) {
        JSONArrayImpl extendedClassesJSONArray = new JSONArrayImpl();
        for (String extendedClassName : javaClass.getExtendedClassNames(true)) {
            extendedClassesJSONArray.put(extendedClassName);
        }
        return extendedClassesJSONArray;
    }

    private static JSONArray _getImplementedClassesJSONArray(JavaClass javaClass) {
        JSONArrayImpl implementedClassesJSONArray = new JSONArrayImpl();
        for (String implementedClassName : javaClass.getImplementedClassNames(true)) {
            implementedClassesJSONArray.put(implementedClassName);
        }
        return implementedClassesJSONArray;
    }

    private static JSONObject _getLegacyPropertiesJSONObject(String fileName) throws Exception {
        JSONObjectImpl legacyPropertiesJSONObject = new JSONObjectImpl();
        List<LegacyProperty> legacyProperties = LegacyPropertiesUtil.getLegacyProperties(fileName, FileUtil.read(new File(fileName)));
        for (LegacyProperty legacyProperty : legacyProperties) {
            JSONObjectImpl legacyPropertyJSONObject = new JSONObjectImpl();
            legacyPropertyJSONObject.put("moduleName", legacyProperty.getModuleName()).put("newPropertyName", legacyProperty.getNewPropertyName()).put("variableName", legacyProperty.getVariableName());
            legacyPropertiesJSONObject.put(legacyProperty.getLegacyPropertyName(), legacyPropertyJSONObject);
        }
        return legacyPropertiesJSONObject;
    }

    private static JSONArray _getMethodsJSONArray(JavaClass javaClass) {
        JSONArrayImpl methodsJSONArray = new JSONArrayImpl();
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaMethod() || childJavaTerm.isPrivate()) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            JSONObjectImpl methodJSONObject = new JSONObjectImpl();
            methodJSONObject.put("accessModifier", javaMethod.getAccessModifier());
            if (javaMethod.hasAnnotation("Deprecated")) {
                methodJSONObject.put("deprecated", true);
            }
            methodJSONObject.put("name", javaMethod.getName());
            if (javaMethod.hasAnnotation("Override")) {
                methodJSONObject.put("override", true);
            }
            JavaSignature javaSignature = null;
            try {
                javaSignature = javaMethod.getSignature();
            }
            catch (Exception exception) {
                continue;
            }
            List<JavaParameter> parameters = javaSignature.getParameters();
            if (!parameters.isEmpty()) {
                JSONArrayImpl parametersJSONArray = new JSONArrayImpl();
                for (JavaParameter javaParameter : parameters) {
                    parametersJSONArray.put(javaParameter.getParameterType(true));
                }
                methodJSONObject.put("parameters", parametersJSONArray);
            }
            methodJSONObject.put("returnType", javaSignature.getReturnType(true));
            methodsJSONArray.put(methodJSONObject);
        }
        return methodsJSONArray;
    }

    private static JSONArray _getVariablesJSONArray(JavaClass javaClass) {
        JSONArrayImpl variablesJSONArray = new JSONArrayImpl();
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaVariable() || childJavaTerm.isPrivate()) continue;
            JavaVariable javaVariable = (JavaVariable)childJavaTerm;
            JSONObjectImpl variableJSONObject = new JSONObjectImpl();
            variableJSONObject.put("accessModifier", javaVariable.getAccessModifier()).put("deprecated", () -> {
                if (javaVariable.hasAnnotation("Deprecated")) {
                    return true;
                }
                return null;
            }).put("lineNumber", javaVariable.getLineNumber()).put("name", javaVariable.getName());
            variablesJSONArray.put(variableJSONObject);
        }
        return variablesJSONArray;
    }

    private static JSONObject _mergeClassJSONObjects(JSONObject classJSONObject1, JSONObject classJSONObject2) {
        JSONObject mergedJSONObject = PortalJSONObjectUtil._mergeJSONArrays(new JSONObjectImpl(), "constructors", classJSONObject1, classJSONObject2);
        if (classJSONObject1.has("deprecated") || classJSONObject2.has("deprecated")) {
            mergedJSONObject.put("deprecated", true);
        }
        mergedJSONObject = PortalJSONObjectUtil._mergeJSONArrays(mergedJSONObject, "extendedClassNames", classJSONObject1, classJSONObject2);
        mergedJSONObject = PortalJSONObjectUtil._mergeJSONArrays(mergedJSONObject, "implementedClassNames", classJSONObject1, classJSONObject2);
        mergedJSONObject = PortalJSONObjectUtil._mergeJSONArrays(mergedJSONObject, "methods", classJSONObject1, classJSONObject2);
        mergedJSONObject = PortalJSONObjectUtil._mergeJSONArrays(mergedJSONObject, "variables", classJSONObject1, classJSONObject2);
        return mergedJSONObject;
    }

    private static JSONObject _mergeJSONArrays(JSONObject mergedJSONObject, String name, JSONObject classJSONObject1, JSONObject classJSONObject2) {
        JSONArray jsonArray1 = classJSONObject1.getJSONArray(name);
        JSONArray jsonArray2 = classJSONObject2.getJSONArray(name);
        if (jsonArray1 == null && jsonArray2 == null) {
            return mergedJSONObject;
        }
        if (jsonArray1 == null) {
            return mergedJSONObject.put(name, jsonArray2);
        }
        if (jsonArray2 == null) {
            return mergedJSONObject.put(name, jsonArray1);
        }
        for (int i = 0; i < jsonArray2.length(); ++i) {
            jsonArray1.put(jsonArray2.get(i));
        }
        return mergedJSONObject.put(name, jsonArray1);
    }
}

