/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.Whitespace;

public class MetaTagAdjuster
extends ProxyReceiver {
    boolean seekingHead = true;
    int droppingMetaTags = -1;
    boolean inMetaTag = false;
    boolean foundHead = false;
    String headPrefix = null;
    String headURI = "";
    NodeName metaCode;
    String requiredURI = "";
    AttributeCollectionImpl attributes;
    List<NamespaceBinding> namespaces = new ArrayList<NamespaceBinding>();
    String encoding;
    String mediaType;
    int level = 0;
    boolean isXHTML = false;
    int htmlVersion = 4;

    public MetaTagAdjuster(Receiver next) {
        super(next);
    }

    public void setOutputProperties(Properties details) {
        String htmlVn;
        this.encoding = details.getProperty("encoding");
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        this.mediaType = details.getProperty("media-type");
        if (this.mediaType == null) {
            this.mediaType = "text/html";
        }
        if ((htmlVn = details.getProperty("html-version")) == null && !this.isXHTML) {
            htmlVn = details.getProperty("version");
        }
        if (htmlVn != null && htmlVn.startsWith("5")) {
            this.htmlVersion = 5;
        }
    }

    public void setIsXHTML(boolean xhtml) {
        this.isXHTML = xhtml;
        this.requiredURI = xhtml ? "http://www.w3.org/1999/xhtml" : "";
    }

    private boolean comparesEqual(String name1, String name2) {
        if (this.isXHTML) {
            return name1.equals(name2);
        }
        return name1.equalsIgnoreCase(name2);
    }

    private boolean matchesName(NodeName name, String local) {
        if (this.isXHTML) {
            if (!name.getLocalPart().equals(local)) {
                return false;
            }
            if (this.htmlVersion == 5) {
                return name.hasURI("") || name.hasURI("http://www.w3.org/1999/xhtml");
            }
            return name.hasURI("http://www.w3.org/1999/xhtml");
        }
        return name.getLocalPart().equalsIgnoreCase(local);
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (this.droppingMetaTags == this.level) {
            this.metaCode = nameCode;
            if (this.matchesName(nameCode, "meta")) {
                this.inMetaTag = true;
                this.attributes.clear();
                this.namespaces.clear();
                return;
            }
        }
        ++this.level;
        this.nextReceiver.startElement(nameCode, typeCode, location, properties);
        if (this.seekingHead && this.matchesName(nameCode, "head")) {
            this.foundHead = true;
            this.headPrefix = nameCode.getPrefix();
            this.headURI = nameCode.getURI();
        }
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (this.inMetaTag) {
            this.attributes.addAttribute(nameCode, typeCode, value.toString(), locationId, properties);
        } else {
            this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
        }
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        if (this.inMetaTag) {
            for (NamespaceBinding ns : namespaceBindings) {
                this.namespaces.add(ns);
            }
        } else {
            this.nextReceiver.namespace(namespaceBindings, properties);
        }
    }

    @Override
    public void startContent() throws XPathException {
        if (this.foundHead) {
            this.foundHead = false;
            this.nextReceiver.startContent();
            FingerprintedQName metaCode = new FingerprintedQName(this.headPrefix, this.headURI, "meta");
            this.nextReceiver.startElement(metaCode, Untyped.getInstance(), null, 0);
            this.nextReceiver.attribute(new NoNamespaceName("http-equiv"), BuiltInAtomicType.UNTYPED_ATOMIC, "Content-Type", null, 0);
            this.nextReceiver.attribute(new NoNamespaceName("content"), BuiltInAtomicType.UNTYPED_ATOMIC, this.mediaType + "; charset=" + this.encoding, null, 0);
            this.nextReceiver.startContent();
            this.droppingMetaTags = this.level;
            this.seekingHead = false;
            this.attributes = new AttributeCollectionImpl(this.getConfiguration());
            this.nextReceiver.endElement();
        }
        if (!this.inMetaTag) {
            this.nextReceiver.startContent();
        }
    }

    @Override
    public void endElement() throws XPathException {
        if (this.inMetaTag) {
            Object name;
            int i;
            this.inMetaTag = false;
            boolean found = false;
            for (i = 0; i < this.attributes.getLength(); ++i) {
                String value;
                name = this.attributes.getLocalName(i);
                if (!this.comparesEqual((String)name, "http-equiv") || !(value = Whitespace.trim(this.attributes.getValue(i))).equalsIgnoreCase("Content-Type")) continue;
                found = true;
                break;
            }
            if (!found) {
                this.nextReceiver.startElement(this.metaCode, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
                for (i = 0; i < this.attributes.getLength(); ++i) {
                    name = this.attributes.getNodeName(i);
                    SimpleType typeCode = this.attributes.getTypeAnnotation(i);
                    String value = this.attributes.getValue(i);
                    Location locationId = this.attributes.getLocation(i);
                    int properties = this.attributes.getProperties(i);
                    this.nextReceiver.attribute((NodeName)name, typeCode, value, locationId, properties);
                }
                for (NamespaceBinding nb : this.namespaces) {
                    this.nextReceiver.namespace(nb, 0);
                }
                this.nextReceiver.startContent();
                this.nextReceiver.endElement();
            }
        } else {
            --this.level;
            if (this.droppingMetaTags == this.level + 1) {
                this.droppingMetaTags = -1;
            }
            this.nextReceiver.endElement();
        }
    }
}

