/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BaseSourceProcessor;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.bnd"};
    private Pattern _bndDefinitionPattern = Pattern.compile("^[A-Za-z-][\\s\\S]*?([^\\\\]\n|\\Z)", 8);
    private Pattern _incorrectTabPattern = Pattern.compile("\n[^\t].*:\\\\\n(\t{2,})[^\t]");
    private Pattern _singleValueOnMultipleLinesPattern = Pattern.compile("\n.*:(\\\\\n\t).*(\n[^\t]|\\Z)");

    @Override
    public String[] getIncludes() {
        return _INCLUDES;
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith("-web/bnd.bnd") && content.contains("Require-SchemaVersion: 1.0.0")) {
            this.processErrorMessage(fileName, "Do not include the header Require-SchemaVersion in web modules: " + fileName);
        }
        Matcher matcher = this._incorrectTabPattern.matcher(content);
        while (matcher.find()) {
            content = StringUtil.replaceFirst(content, matcher.group(1), "\t", matcher.start());
        }
        matcher = this._singleValueOnMultipleLinesPattern.matcher(content);
        while (matcher.find()) {
            content = StringUtil.replaceFirst(content, matcher.group(1), " ", matcher.start());
        }
        content = this.sortDefinitions(content);
        return this.trimContent(content, false);
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    protected String sortDefinitions(String content) {
        String previousDefinition = null;
        DefinitionComparator definitionComparator = new DefinitionComparator();
        Matcher matcher = this._bndDefinitionPattern.matcher(content);
        while (matcher.find()) {
            String definition = matcher.group();
            if (Validator.isNotNull(matcher.group(1))) {
                definition = definition.substring(0, definition.length() - 1);
            }
            if (Validator.isNotNull(previousDefinition)) {
                int value = definitionComparator.compare(previousDefinition, definition);
                if (value > 0) {
                    content = StringUtil.replaceFirst(content, previousDefinition, definition);
                    content = StringUtil.replaceLast(content, definition, previousDefinition);
                    return content;
                }
                if (value == 0) {
                    return StringUtil.replaceFirst(content, previousDefinition + "\n", "");
                }
            }
            previousDefinition = definition;
        }
        return content;
    }

    private static class DefinitionComparator
    implements Comparator<String> {
        private DefinitionComparator() {
        }

        @Override
        public int compare(String definition1, String definition2) {
            if (definition1.startsWith("-") ^ definition2.startsWith("-")) {
                return -definition1.compareTo(definition2);
            }
            return definition1.compareTo(definition2);
        }
    }
}

