/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.JavaClass;
import com.liferay.source.formatter.JavaSourceProcessor;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterHelper;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.SourceProcessor;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public abstract class BaseSourceProcessor
implements SourceProcessor {
    public static final int PORTAL_MAX_DIR_LEVEL = 5;
    protected static Pattern attributeNamePattern = Pattern.compile("[a-z]+[-_a-zA-Z0-9]*");
    protected static Pattern bndContentDirPattern = Pattern.compile("\tcontent=(.*?)(,\\\\|\n)");
    protected static Pattern emptyCollectionPattern = Pattern.compile("Collections\\.EMPTY_(LIST|MAP|SET)");
    protected static Pattern javaSourceInsideJSPTagPattern = Pattern.compile("<%=(.+?)%>");
    protected static Pattern langMergerPluginPattern = Pattern.compile("^apply[ \t]+plugin[ \t]*:[ \t]+\"com.liferay.lang.merger\"$", 8);
    protected static Pattern languageKeyPattern = Pattern.compile("LanguageUtil.(?:get|format)\\([^;%]+|Liferay.Language.get\\('([^']+)");
    protected static boolean portalSource;
    protected static Pattern principalExceptionPattern;
    protected static Pattern sessionKeyPattern;
    protected static Pattern taglibSessionKeyPattern;
    protected SourceFormatterArgs sourceFormatterArgs;
    private Set<String> _annotationsExclusions;
    private Map<String, Tuple> _bndFileLocationAndContentMap = new HashMap<String, Tuple>();
    private Map<String, Properties> _bndLanguagePropertiesMap = new HashMap<String, Properties>();
    private Map<String, String> _compatClassNamesMap;
    private String _copyright;
    private Map<String, List<String>> _errorMessagesMap = new HashMap<String, List<String>>();
    private String[] _excludes;
    private SourceMismatchException _firstSourceMismatchException;
    private Set<String> _immutableFieldTypes;
    private String _mainReleaseVersion;
    private final List<String> _modifiedFileNames = new ArrayList<String>();
    private Map<String, Properties> _moduleLangLanguageProperties = new HashMap<String, Properties>();
    private Map<String, Properties> _moduleLanguageProperties = new HashMap<String, Properties>();
    private String _oldCopyright;
    private Properties _portalLanguageProperties;
    private Properties _properties;
    private List<String> _runOutsidePortalExcludes;
    private SourceFormatterHelper _sourceFormatterHelper;
    private boolean _usePortalCompatImport;

    @Override
    public final void format() throws Exception {
        for (String fileName : this.getFileNames()) {
            try {
                this.format(fileName);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to format " + fileName, e);
            }
        }
        this.postFormat();
        this._sourceFormatterHelper.close();
    }

    @Override
    public List<String> getErrorMessages() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : this._errorMessagesMap.entrySet()) {
            errorMessages.addAll((Collection<String>)entry.getValue());
        }
        return errorMessages;
    }

    public final List<String> getFileNames() throws Exception {
        List<String> fileNames = this.sourceFormatterArgs.getFileNames();
        if (fileNames != null) {
            return fileNames;
        }
        return this.doGetFileNames();
    }

    @Override
    public SourceMismatchException getFirstSourceMismatchException() {
        return this._firstSourceMismatchException;
    }

    @Override
    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    @Override
    public void setSourceFormatterArgs(SourceFormatterArgs sourceFormatterArgs) {
        this.sourceFormatterArgs = sourceFormatterArgs;
        this._init();
    }

    protected static int getLeadingTabCount(String line) {
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    protected static boolean isExcludedPath(List<String> excludes, String path) {
        return BaseSourceProcessor.isExcludedPath(excludes, path, -1);
    }

    protected static boolean isExcludedPath(List<String> excludes, String path, int lineCount) {
        return BaseSourceProcessor.isExcludedPath(excludes, path, lineCount, null);
    }

    protected static boolean isExcludedPath(List<String> excludes, String path, int lineCount, String javaTermName) {
        if (ListUtil.isEmpty(excludes)) {
            return false;
        }
        String pathWithJavaTermName = null;
        if (Validator.isNotNull(javaTermName)) {
            pathWithJavaTermName = path + "@" + javaTermName;
        }
        String pathWithLineCount = null;
        if (lineCount > 0) {
            pathWithLineCount = path + "@" + lineCount;
        }
        for (String exclude : excludes) {
            if (exclude.startsWith("**")) {
                exclude = exclude.substring(2);
            }
            if (!(exclude.endsWith("**") ? path.contains(exclude = exclude.substring(0, exclude.length() - 2)) : path.endsWith(exclude) || pathWithJavaTermName != null && pathWithJavaTermName.endsWith(exclude) || pathWithLineCount != null && pathWithLineCount.endsWith(exclude))) continue;
            return true;
        }
        return false;
    }

    protected static String stripQuotes(String s, char delimeter) {
        boolean insideQuotes = false;
        StringBundler sb = new StringBundler();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (insideQuotes) {
                if (c != delimeter) continue;
                int precedingBackSlashCount = 0;
                for (int j = i - 1; j >= 0 && s.charAt(j) == '\\'; --j) {
                    ++precedingBackSlashCount;
                }
                if (precedingBackSlashCount != 0 && precedingBackSlashCount % 2 != 0) continue;
                insideQuotes = false;
                continue;
            }
            if (c == delimeter) {
                insideQuotes = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected void checkEmptyCollection(String line, String fileName, int lineCount) {
        Matcher matcher = emptyCollectionPattern.matcher(line);
        if (matcher.find()) {
            String collectionType = TextFormatter.format(matcher.group(1), 9);
            this.processErrorMessage(fileName, "Use Collections.empty" + collectionType + "(): " + fileName + " " + lineCount);
        }
    }

    protected void checkIfClauseParentheses(String ifClause, String fileName, int lineCount) {
        int quoteCount = StringUtil.count(ifClause, "\"");
        if (quoteCount % 2 == 1) {
            return;
        }
        ifClause = BaseSourceProcessor.stripQuotes(ifClause, '\"');
        if ((ifClause = BaseSourceProcessor.stripQuotes(ifClause, '\'')).contains("//") || ifClause.contains("/*") || ifClause.contains("*/")) {
            return;
        }
        if (this.hasRedundantParentheses(ifClause, "||", "&&") || this.hasRedundantParentheses(ifClause, "&&", "||")) {
            this.processErrorMessage(fileName, "redundant parentheses: " + fileName + " " + lineCount);
        }
        ifClause = this.stripRedundantParentheses(ifClause);
        int level = 0;
        int max = StringUtil.count(ifClause, "(");
        int previousParenthesisPos = -1;
        int[] levels = new int[max];
        for (int i = 0; i < ifClause.length(); ++i) {
            String s;
            char c = ifClause.charAt(i);
            if (c != '(' && c != ')') continue;
            if (previousParenthesisPos != -1 && this.hasMissingParentheses(s = ifClause.substring(previousParenthesisPos + 1, i))) {
                this.processErrorMessage(fileName, "missing parentheses: " + fileName + " " + lineCount);
            }
            previousParenthesisPos = i;
            if (c == '(') {
                levels[level] = i;
                ++level;
                continue;
            }
            int posOpenParenthesis = levels[level - 1];
            if (level > 1) {
                String s2;
                char nextChar = ifClause.charAt(i + 1);
                char previousChar = ifClause.charAt(posOpenParenthesis - 1);
                if (!Character.isLetterOrDigit(nextChar) && nextChar != '.' && !Character.isLetterOrDigit(previousChar) && this.hasRedundantParentheses(s2 = ifClause.substring(posOpenParenthesis + 1, i))) {
                    this.processErrorMessage(fileName, "redundant parentheses: " + fileName + " " + lineCount);
                }
                if (previousChar == '(' && nextChar == ')') {
                    this.processErrorMessage(fileName, "redundant parentheses: " + fileName + " " + lineCount);
                }
            }
            --level;
        }
    }

    protected void checkInefficientStringMethods(String line, String fileName, String absolutePath, int lineCount) {
        if (BaseSourceProcessor.isExcludedPath(this.getRunOutsidePortalExcludes(), absolutePath)) {
            return;
        }
        String methodName = "toLowerCase";
        int pos = line.indexOf(".toLowerCase()");
        if (pos == -1) {
            methodName = "toUpperCase";
            pos = line.indexOf(".toUpperCase()");
        }
        if (pos == -1 && !line.contains("StringUtil.equalsIgnoreCase(")) {
            methodName = "equalsIgnoreCase";
            pos = line.indexOf(".equalsIgnoreCase(");
        }
        if (pos != -1) {
            this.processErrorMessage(fileName, "Use StringUtil." + methodName + ": " + fileName + " " + lineCount);
        }
    }

    protected void checkLanguageKeys(String fileName, String absolutePath, String content, Pattern pattern) throws Exception {
        String fileExtension = FilenameUtils.getExtension((String)fileName);
        if (!portalSource || fileExtension.equals("vm")) {
            return;
        }
        if (this._portalLanguageProperties == null) {
            this._portalLanguageProperties = new Properties();
            File portalLanguagePropertiesFile = new File(this.getFile("portal-impl", 5), "src/content/Language.properties");
            FileInputStream inputStream = new FileInputStream(portalLanguagePropertiesFile);
            this._portalLanguageProperties.load(inputStream);
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String[] languageKeys;
            for (String languageKey : languageKeys = this.getLanguageKeys(matcher)) {
                Properties bndFileLanguageProperties;
                Properties moduleLangLanguageProperties;
                Properties moduleLanguageProperties;
                if (Validator.isNumber(languageKey) || languageKey.endsWith("-") || languageKey.endsWith("[") || languageKey.endsWith(".") || languageKey.endsWith("_") || languageKey.startsWith("-") || languageKey.startsWith("[") || languageKey.startsWith("{") || languageKey.startsWith(".") || languageKey.startsWith("_") || this._portalLanguageProperties.containsKey(languageKey) || (moduleLanguageProperties = this.getModuleLanguageProperties(fileName)) != null && moduleLanguageProperties.containsKey(languageKey) || (moduleLangLanguageProperties = this.getModuleLangLanguageProperties(absolutePath)) != null && moduleLangLanguageProperties.containsKey(languageKey) || (bndFileLanguageProperties = this.getBNDFileLanguageProperties(fileName)) != null && bndFileLanguageProperties.containsKey(languageKey)) continue;
                this.processErrorMessage(fileName, "missing language key: " + languageKey + " " + fileName);
            }
        }
    }

    protected String checkPrincipalException(String content) {
        String newContent = content;
        Matcher matcher = principalExceptionPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String replacement = StringUtil.replace(match, "class.getName", "getNestedClasses");
            newContent = StringUtil.replace(newContent, match, replacement);
        }
        return newContent;
    }

    protected void checkResourceUtil(String line, String fileName, int lineCount) {
        if (!portalSource || fileName.endsWith("ResourceBundleUtil.java")) {
            return;
        }
        if (line.contains("ResourceBundle.getBundle(")) {
            this.processErrorMessage(fileName, "Use ResourceBundleUtil.getBundle instead of ResourceBundle.getBundle: " + fileName + " " + lineCount);
        }
        if (line.contains("resourceBundle.getString(")) {
            this.processErrorMessage(fileName, "Use ResourceBundleUtil.getString instead of resourceBundle.getString: " + fileName + " " + lineCount);
        }
    }

    protected void checkChaining(String line, String fileName, int lineCount) {
        if (line.startsWith("this(")) {
            return;
        }
        if (line.contains(".getClass().")) {
            this.processErrorMessage(fileName, "chaining: " + fileName + " " + lineCount);
        }
    }

    protected void checkStringBundler(String line, String fileName, int lineCount) {
        String[] lineParts;
        if (!line.startsWith("sb.append(") && !line.contains("SB.append(") || !line.endsWith(");")) {
            return;
        }
        int pos = line.indexOf(".append(");
        line = line.substring(pos + 8, line.length() - 2);
        if (!(line = BaseSourceProcessor.stripQuotes(line, '\"')).contains(" + ")) {
            return;
        }
        for (String linePart : lineParts = StringUtil.split(line, " + ")) {
            int openParenthesesCount;
            int closeParenthesesCount = StringUtil.count(linePart, ")");
            if (closeParenthesesCount != (openParenthesesCount = StringUtil.count(linePart, "("))) {
                return;
            }
            if (!Validator.isNumber(linePart)) continue;
            return;
        }
        this.processErrorMessage(fileName, "plus: " + fileName + " " + lineCount);
    }

    protected abstract String doFormat(File var1, String var2, String var3, String var4) throws Exception;

    protected abstract List<String> doGetFileNames() throws Exception;

    protected String fixCompatClassImports(String absolutePath, String content) throws Exception {
        if (portalSource || !this._usePortalCompatImport || absolutePath.contains("/ext-") || absolutePath.contains("/portal-compat-shared/")) {
            return content;
        }
        Map<String, String> compatClassNamesMap = this.getCompatClassNamesMap();
        String newContent = content;
        for (Map.Entry<String, String> entry : compatClassNamesMap.entrySet()) {
            Matcher matcher;
            String compatClassName = entry.getKey();
            String extendedClassName = entry.getValue();
            Pattern pattern = Pattern.compile(extendedClassName + "\\W");
            while ((matcher = pattern.matcher(newContent)).find()) {
                newContent = newContent.substring(0, matcher.start()) + compatClassName + newContent.substring(matcher.end() - 1);
            }
        }
        return newContent;
    }

    protected String fixCopyright(String content, String absolutePath, String fileName) throws IOException {
        int x;
        if (this._copyright == null) {
            this._copyright = this.getContent(this.sourceFormatterArgs.getCopyrightFileName(), 5);
        }
        String copyright = this._copyright;
        if (fileName.endsWith(".vm") || Validator.isNull(copyright)) {
            return content;
        }
        if (this._oldCopyright == null) {
            this._oldCopyright = this.getContent("old-copyright.txt", 5);
        }
        if (Validator.isNotNull(this._oldCopyright) && content.contains(this._oldCopyright)) {
            content = StringUtil.replace(content, this._oldCopyright, copyright);
            this.processErrorMessage(fileName, "old (c): " + fileName);
        }
        if (!content.contains(copyright)) {
            String customCopyright = this.getCustomCopyright(absolutePath);
            if (Validator.isNotNull(customCopyright)) {
                copyright = customCopyright;
            }
            if (!content.contains(copyright)) {
                this.processErrorMessage(fileName, "(c): " + fileName);
            }
        }
        if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf")) {
            content = StringUtil.replace(content, "<%\n" + copyright + "\n%>", "<%--\n" + copyright + "\n--%>");
        }
        if ((x = content.indexOf("* Copyright (c) 2000-")) == -1) {
            return content;
        }
        int y = content.indexOf("Liferay", x);
        String contentCopyrightYear = content.substring(x, y);
        x = copyright.indexOf("* Copyright (c) 2000-");
        if (x == -1) {
            return content;
        }
        y = copyright.indexOf("Liferay", x);
        String copyrightYear = copyright.substring(x, y);
        return StringUtil.replace(content, contentCopyrightYear, copyrightYear);
    }

    protected String fixIncorrectParameterTypeForLanguageUtil(String content, boolean autoFix, String fileName) {
        if (portalSource) {
            return content;
        }
        String expectedParameter = this.getProperty("languageutil.expected.parameter");
        String incorrectParameter = this.getProperty("languageutil.incorrect.parameter");
        if (!content.contains("LanguageUtil.format(" + incorrectParameter + ", ") && !content.contains("LanguageUtil.get(" + incorrectParameter + ", ")) {
            return content;
        }
        if (autoFix) {
            content = StringUtil.replace(content, new String[]{"LanguageUtil.format(" + incorrectParameter + ", ", "LanguageUtil.get(" + incorrectParameter + ", "}, new String[]{"LanguageUtil.format(" + expectedParameter + ", ", "LanguageUtil.get(" + expectedParameter + ", "});
        } else {
            this.processErrorMessage(fileName, "(Unicode)LanguageUtil.format/get methods require " + expectedParameter + " parameter instead of " + incorrectParameter + " " + fileName);
        }
        return content;
    }

    protected String fixSessionKey(String fileName, String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String newContent = content;
        do {
            String match = matcher.group();
            String s = null;
            if (pattern.equals(sessionKeyPattern)) {
                s = ",";
            } else if (pattern.equals(taglibSessionKeyPattern)) {
                s = "key=";
            }
            int x = match.indexOf(s);
            if (x == -1) continue;
            String substring = match.substring(x += s.length()).trim();
            String quote = "";
            if (substring.startsWith("'")) {
                quote = "'";
            } else {
                if (!substring.startsWith("\"")) continue;
                quote = "\"";
            }
            int y = match.indexOf(quote, x);
            int z = match.indexOf(quote, y + 1);
            if (y == -1 || z == -1) continue;
            String prefix = match.substring(0, y + 1);
            String suffix = match.substring(z);
            String oldKey = match.substring(y + 1, z);
            boolean alphaNumericKey = true;
            for (char c : oldKey.toCharArray()) {
                if (Validator.isChar(c) || Validator.isDigit(c) || c == '-' || c == '_') continue;
                alphaNumericKey = false;
            }
            if (!alphaNumericKey) continue;
            String newKey = TextFormatter.format(oldKey, 14);
            if ((newKey = TextFormatter.format(newKey, 12)).equals(oldKey)) continue;
            String oldSub = prefix.concat(oldKey).concat(suffix);
            String newSub = prefix.concat(newKey).concat(suffix);
            newContent = StringUtil.replaceFirst(newContent, oldSub, newSub);
        } while (matcher.find());
        return newContent;
    }

    protected final String format(File file, String fileName, String absolutePath, String content) throws Exception {
        this._errorMessagesMap.remove(fileName);
        String newContent = this.doFormat(file, fileName, absolutePath, content);
        newContent = StringUtil.replace(newContent, "\r", "");
        if (content.equals(newContent)) {
            return content;
        }
        return this.format(file, fileName, absolutePath, newContent);
    }

    protected final void format(String fileName) throws Exception {
        if (!this._isMatchPath(fileName)) {
            return;
        }
        fileName = StringUtil.replace(fileName, "\\", "/");
        File file = new File(fileName);
        String absolutePath = this.getAbsolutePath(file);
        String content = FileUtil.read(file);
        String newContent = this.format(file, fileName, absolutePath, content);
        this.processFormattedFile(file, fileName, content, newContent);
    }

    protected String formatEmptyArray(String line) {
        int pos = line.indexOf("[] {}");
        if (pos != -1 && !ToolsUtil.isInsideQuotes(line, pos)) {
            return StringUtil.replaceFirst(line, "[] {}", "[0]", pos - 1);
        }
        return line;
    }

    protected String formatIncorrectSyntax(String line, String incorrectSyntax, String correctSyntax, boolean lineStart) {
        if (lineStart) {
            if (line.startsWith(incorrectSyntax)) {
                line = StringUtil.replaceFirst(line, incorrectSyntax, correctSyntax);
            }
            return line;
        }
        int x = -1;
        while ((x = line.indexOf(incorrectSyntax, x + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(line, x)) continue;
            line = StringUtil.replaceFirst(line, incorrectSyntax, correctSyntax, x);
        }
        return line;
    }

    protected String formatJavaTerms(String javaClassName, String packagePath, File file, String fileName, String absolutePath, String content, String javaClassContent, int javaClassLineCount, List<String> checkJavaFieldTypesExcludes, List<String> javaTermAccessLevelModifierExcludes, List<String> javaTermSortExcludes, List<String> testAnnotationsExcludes) throws Exception {
        JavaSourceProcessor javaSourceProcessor = null;
        if (this instanceof JavaSourceProcessor) {
            javaSourceProcessor = (JavaSourceProcessor)this;
        } else {
            javaSourceProcessor = new JavaSourceProcessor();
            javaSourceProcessor.setSourceFormatterArgs(this.sourceFormatterArgs);
        }
        JavaClass javaClass = new JavaClass(javaClassName, packagePath, file, fileName, absolutePath, javaClassContent, javaClassLineCount, "\t", null, javaTermAccessLevelModifierExcludes, javaSourceProcessor);
        String newJavaClassContent = javaClass.formatJavaTerms(this.getAnnotationsExclusions(), this.getImmutableFieldTypes(), checkJavaFieldTypesExcludes, javaTermSortExcludes, testAnnotationsExcludes);
        if (!javaClassContent.equals(newJavaClassContent)) {
            return StringUtil.replaceFirst(content, javaClassContent, newJavaClassContent);
        }
        return content;
    }

    protected String formatTagAttributeType(String line, String tag, String attributeAndValue) throws Exception {
        return line;
    }

    protected String formatWhitespace(String line, boolean javaSource) {
        String trimmedLine = StringUtil.trimLeading(line);
        line = this.formatWhitespace(line, trimmedLine, javaSource);
        if (javaSource) {
            return line;
        }
        Matcher matcher = javaSourceInsideJSPTagPattern.matcher(line);
        while (matcher.find()) {
            String linePart = matcher.group(1);
            if (!linePart.startsWith(" ")) {
                return StringUtil.replace(line, matcher.group(), "<%= " + linePart + "%>");
            }
            if (!linePart.endsWith(" ")) {
                return StringUtil.replace(line, matcher.group(), "<%=" + linePart + " %>");
            }
            line = this.formatWhitespace(line, linePart, true);
        }
        return line;
    }

    protected String formatWhitespace(String line, String linePart, boolean javaSource) {
        String linePart2;
        int x;
        String originalLinePart = linePart;
        linePart = this.formatIncorrectSyntax(linePart, "catch(", "catch (", true);
        linePart = this.formatIncorrectSyntax(linePart, "else{", "else {", true);
        linePart = this.formatIncorrectSyntax(linePart, "for(", "for (", true);
        linePart = this.formatIncorrectSyntax(linePart, "if(", "if (", true);
        linePart = this.formatIncorrectSyntax(linePart, "while(", "while (", true);
        linePart = this.formatIncorrectSyntax(linePart, "List <", "List<", false);
        linePart = this.formatIncorrectSyntax(linePart, "){", ") {", false);
        linePart = this.formatIncorrectSyntax(linePart, "]{", "] {", false);
        if (javaSource) {
            linePart = this.formatIncorrectSyntax(linePart, " [", "[", false);
            linePart = this.formatIncorrectSyntax(linePart, "{ ", "{", false);
            linePart = this.formatIncorrectSyntax(linePart, " }", "}", false);
            linePart = this.formatIncorrectSyntax(linePart, " )", ")", false);
            linePart = this.formatIncorrectSyntax(linePart, "( ", "(", false);
        }
        if (!linePart.startsWith("##")) {
            x = 0;
            while ((x = linePart.indexOf("  ", x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(linePart, x)) continue;
                linePart = StringUtil.replaceFirst(linePart, "  ", " ", x);
            }
        }
        if (!javaSource) {
            line = StringUtil.replace(line, originalLinePart, linePart);
            return this.formatIncorrectSyntax(line, " \t", "\t", false);
        }
        x = 0;
        while ((x = linePart.indexOf(61, x + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(linePart, x)) continue;
            char c = linePart.charAt(x - 1);
            if (Character.isLetterOrDigit(c)) {
                linePart = StringUtil.replaceFirst(linePart, "=", " =", x);
                break;
            }
            if (x == linePart.length() - 1) break;
            c = linePart.charAt(x + 1);
            if (!Character.isLetterOrDigit(c)) continue;
            linePart = StringUtil.replaceFirst(linePart, "=", "= ", x);
            break;
        }
        if (!line.contains("//")) {
            while (linePart.contains("\t")) {
                linePart = StringUtil.replaceLast(linePart, "\t", " ");
            }
        }
        if (line.contains("//")) {
            line = StringUtil.replace(line, originalLinePart, linePart);
            return this.formatIncorrectSyntax(line, " \t", "\t", false);
        }
        int pos = linePart.indexOf(") ");
        if (!(pos == -1 || pos + 2 >= linePart.length() || linePart.contains("@") || ToolsUtil.isInsideQuotes(linePart, pos) || !Character.isLetter((linePart2 = linePart.substring(pos + 2)).charAt(0)) || linePart2.startsWith("default") || linePart2.startsWith("instanceof") || linePart2.startsWith("throws"))) {
            linePart = StringUtil.replaceFirst(linePart, " ", "", pos);
        }
        if ((pos = linePart.indexOf(" (")) != -1 && !linePart.contains("=") && !ToolsUtil.isInsideQuotes(linePart, pos) && (linePart.startsWith("private ") || linePart.startsWith("protected ") || linePart.startsWith("public "))) {
            linePart = StringUtil.replaceFirst(linePart, " (", "(", pos);
        }
        int x2 = -1;
        while (true) {
            char previousChar;
            char nextChar;
            int posComma = linePart.indexOf(44, x2 + 1);
            int posSemicolon = linePart.indexOf(59, x2 + 1);
            if (posComma == -1 && posSemicolon == -1) break;
            x2 = Math.min(posComma, posSemicolon);
            if (x2 == -1) {
                x2 = Math.max(posComma, posSemicolon);
            }
            if (ToolsUtil.isInsideQuotes(linePart, x2)) continue;
            if (linePart.length() > x2 + 1 && (nextChar = linePart.charAt(x2 + 1)) != '\'' && nextChar != ')' && nextChar != ' ' && nextChar != '*') {
                linePart = StringUtil.insert(linePart, " ", x2 + 1);
            }
            if (x2 <= 0 || (previousChar = linePart.charAt(x2 - 1)) != ' ') continue;
            linePart = linePart.substring(0, x2 - 1).concat(linePart.substring(x2));
        }
        line = StringUtil.replace(line, originalLinePart, linePart);
        return this.formatIncorrectSyntax(line, " \t", "\t", false);
    }

    protected String getAbsolutePath(File file) throws Exception {
        String absolutePath = file.getCanonicalPath();
        absolutePath = StringUtil.replace(absolutePath, '\\', '/');
        return StringUtil.replace(absolutePath, "/./", "/");
    }

    protected Set<String> getAnnotationsExclusions() {
        if (this._annotationsExclusions != null) {
            return this._annotationsExclusions;
        }
        this._annotationsExclusions = SetUtil.fromArray(new String[]{"ArquillianResource", "BeanReference", "Inject", "Mock", "ServiceReference", "SuppressWarnings"});
        return this._annotationsExclusions;
    }

    protected Properties getBNDFileLanguageProperties(String fileName) throws Exception {
        Tuple bndFileLocationAndContentTuple = this.getBNDFileLocationAndContentTuple(fileName);
        if (bndFileLocationAndContentTuple == null) {
            return null;
        }
        String bndFileLocation = (String)bndFileLocationAndContentTuple.getObject(0);
        Properties properties = this._bndLanguagePropertiesMap.get(bndFileLocation);
        if (properties != null) {
            return properties;
        }
        String bndContent = (String)bndFileLocationAndContentTuple.getObject(1);
        Matcher matcher = bndContentDirPattern.matcher(bndContent);
        if (matcher.find()) {
            File file = new File(bndFileLocation + matcher.group(1) + "/Language.properties");
            if (!file.exists()) {
                return null;
            }
            properties = new Properties();
            FileInputStream inputStream = new FileInputStream(file);
            properties.load(inputStream);
            this._bndLanguagePropertiesMap.put(bndFileLocation, properties);
            return properties;
        }
        return null;
    }

    protected Tuple getBNDFileLocationAndContentTuple(String fileName) throws Exception {
        Tuple bndFileLocationAndContentTuple = this._bndFileLocationAndContentMap.get(fileName);
        if (bndFileLocationAndContentTuple != null) {
            return bndFileLocationAndContentTuple;
        }
        String bndFileLocation = fileName;
        int pos;
        while ((pos = bndFileLocation.lastIndexOf("/")) != -1) {
            File file = new File((bndFileLocation = bndFileLocation.substring(0, pos + 1)) + "bnd.bnd");
            if (file.exists()) {
                String bndContent = FileUtil.read(file);
                bndFileLocationAndContentTuple = new Tuple(bndFileLocation, bndContent);
                this._bndFileLocationAndContentMap.put(fileName, bndFileLocationAndContentTuple);
                return bndFileLocationAndContentTuple;
            }
            bndFileLocation = StringUtil.replaceLast(bndFileLocation, "/", "");
        }
        return null;
    }

    protected Map<String, String> getCompatClassNamesMap() throws Exception {
        String fileName;
        if (this._compatClassNamesMap != null) {
            return this._compatClassNamesMap;
        }
        HashMap<String, String> compatClassNamesMap = new HashMap<String, String>();
        String[] includes = new String[]{"**/portal-compat-shared/src/com/liferay/compat/**/*.java"};
        String basedir = this.sourceFormatterArgs.getBaseDirName();
        List<Object> fileNames = new ArrayList();
        for (int i = 0; i < 3 && (fileNames = this.getFileNames(basedir, new String[0], includes)).isEmpty(); ++i) {
            basedir = "../" + basedir;
        }
        Iterator i$ = fileNames.iterator();
        while (i$.hasNext() && (fileName = (String)i$.next()).startsWith(this.sourceFormatterArgs.getBaseDirName() + "shared")) {
            File file = new File(basedir + fileName);
            String content = FileUtil.read(file);
            fileName = StringUtil.replace(fileName, "\\", "/");
            fileName = StringUtil.replace(fileName, "/", ".");
            int pos = fileName.indexOf("com.");
            String compatClassName = fileName.substring(pos);
            compatClassName = compatClassName.substring(0, compatClassName.length() - 5);
            String extendedClassName = StringUtil.replace(compatClassName, "compat.", "");
            if (!content.contains("extends " + extendedClassName)) continue;
            compatClassNamesMap.put(compatClassName, extendedClassName);
        }
        this._compatClassNamesMap = compatClassNamesMap;
        return this._compatClassNamesMap;
    }

    protected String getContent(String fileName, int level) throws IOException {
        String content;
        File file = this.getFile(fileName, level);
        if (file != null && Validator.isNotNull(content = FileUtil.read(file))) {
            return content;
        }
        return "";
    }

    protected String getCustomCopyright(String absolutePath) throws IOException {
        int x = absolutePath.length();
        while ((x = absolutePath.lastIndexOf(47, x)) != -1) {
            String copyright = FileUtil.read(new File(absolutePath.substring(0, x + 1) + "copyright.txt"));
            if (Validator.isNotNull(copyright)) {
                return copyright;
            }
            --x;
        }
        return null;
    }

    protected File getFile(String fileName, int level) {
        for (int i = 0; i < level; ++i) {
            File file = new File(this.sourceFormatterArgs.getBaseDirName() + fileName);
            if (file.exists()) {
                return file;
            }
            fileName = "../" + fileName;
        }
        return null;
    }

    protected List<String> getFileNames(String basedir, List<String> recentChangesFileNames, String[] excludes, String[] includes) throws Exception {
        if (this._excludes != null) {
            excludes = ArrayUtil.append(excludes, this._excludes);
        }
        return this._sourceFormatterHelper.getFileNames(basedir, recentChangesFileNames, excludes, includes);
    }

    protected List<String> getFileNames(String basedir, String[] excludes, String[] includes) throws Exception {
        return this.getFileNames(basedir, this.sourceFormatterArgs.getRecentChangesFileNames(), excludes, includes);
    }

    protected List<String> getFileNames(String[] excludes, String[] includes) throws Exception {
        return this.getFileNames(this.sourceFormatterArgs.getBaseDirName(), excludes, includes);
    }

    protected Set<String> getImmutableFieldTypes() {
        if (this._immutableFieldTypes != null) {
            return this._immutableFieldTypes;
        }
        Set<String> immutableFieldTypes = SetUtil.fromArray(new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "Boolean", "Byte", "Character", "Class", "Double", "Float", "Int", "Long", "Number", "Short", "String"});
        immutableFieldTypes.addAll(this.getPropertyList("immutable.field.types"));
        this._immutableFieldTypes = immutableFieldTypes;
        return this._immutableFieldTypes;
    }

    protected String[] getLanguageKeys(Matcher matcher) {
        int groupCount = matcher.groupCount();
        if (groupCount == 1) {
            String languageKey = matcher.group(1);
            if (Validator.isNotNull(languageKey)) {
                return new String[]{languageKey};
            }
        } else if (groupCount == 2) {
            String languageKey = matcher.group(2);
            languageKey = TextFormatter.format(languageKey, 15);
            return new String[]{languageKey};
        }
        StringBundler sb = new StringBundler();
        String match = matcher.group();
        int count = 0;
        block5: for (int i = 0; i < match.length(); ++i) {
            char c = match.charAt(i);
            switch (c) {
                case ')': {
                    if (count <= 1) {
                        return new String[0];
                    }
                    --count;
                    continue block5;
                }
                case '(': {
                    ++count;
                    continue block5;
                }
                case '\"': {
                    if (count > 1) continue block5;
                    while (i < match.length()) {
                        if (match.charAt(++i) == '\"') {
                            String languageKey = sb.toString();
                            if (match.startsWith("names")) {
                                return StringUtil.split(languageKey);
                            }
                            return new String[]{languageKey};
                        }
                        sb.append(match.charAt(i));
                    }
                    continue block5;
                }
            }
        }
        return new String[0];
    }

    protected int getLineCount(String content, int pos) {
        String beforePos = content.substring(0, pos);
        return StringUtil.count(beforePos, "\n") + 1;
    }

    protected String getMainReleaseVersion() {
        if (this._mainReleaseVersion != null) {
            return this._mainReleaseVersion;
        }
        String releaseVersion = ReleaseInfo.getVersion();
        int pos = releaseVersion.lastIndexOf(46);
        this._mainReleaseVersion = releaseVersion.substring(0, pos) + ".0";
        return this._mainReleaseVersion;
    }

    protected String getModuleLangDir(String moduleLocation) {
        int x = moduleLocation.lastIndexOf("/");
        String baseModuleName = moduleLocation.substring(0, x);
        int y = baseModuleName.lastIndexOf("/");
        baseModuleName = baseModuleName.substring(y + 1, baseModuleName.length());
        return moduleLocation.substring(0, x + 1) + baseModuleName + "-lang";
    }

    protected Properties getModuleLangLanguageProperties(String absolutePath) throws Exception {
        File file;
        Properties properties = this._moduleLangLanguageProperties.get(absolutePath);
        if (properties != null) {
            return properties;
        }
        String buildGradleContent = null;
        String buildGradleFileLocation = absolutePath;
        while (true) {
            int pos;
            if ((pos = buildGradleFileLocation.lastIndexOf("/")) == -1) {
                return null;
            }
            file = new File((buildGradleFileLocation = buildGradleFileLocation.substring(0, pos + 1)) + "build.gradle");
            if (file.exists()) break;
            buildGradleFileLocation = StringUtil.replaceLast(buildGradleFileLocation, "/", "");
        }
        buildGradleContent = FileUtil.read(file);
        Matcher matcher = langMergerPluginPattern.matcher(buildGradleContent);
        if (!matcher.find()) {
            return null;
        }
        String moduleLocation = StringUtil.replaceLast(buildGradleFileLocation, "/", "");
        String moduleLangDir = this.getModuleLangDir(moduleLocation);
        String moduleLangLanguagePropertiesFileName = moduleLangDir + "/src/main/resources/content/Language.properties";
        File file2 = new File(moduleLangLanguagePropertiesFileName);
        if (!file2.exists()) {
            return null;
        }
        properties = new Properties();
        FileInputStream inputStream = new FileInputStream(file2);
        properties.load(inputStream);
        this._moduleLangLanguageProperties.put(absolutePath, properties);
        return properties;
    }

    protected Properties getModuleLanguageProperties(String fileName) {
        Properties properties = this._moduleLanguageProperties.get(fileName);
        if (properties != null) {
            return properties;
        }
        StringBundler sb = new StringBundler(3);
        int pos = fileName.indexOf("/docroot/");
        if (pos != -1) {
            sb.append(fileName.substring(0, pos + 9));
            sb.append("WEB-INF/src/");
        } else {
            pos = fileName.indexOf("src/");
            if (pos == -1) {
                return null;
            }
            sb.append(fileName.substring(0, pos + 4));
            if (fileName.contains("src/main/")) {
                sb.append("main/resources/");
            }
        }
        sb.append("content/Language.properties");
        try {
            properties = new Properties();
            FileInputStream inputStream = new FileInputStream(sb.toString());
            properties.load(inputStream);
            this._moduleLanguageProperties.put(fileName, properties);
            return properties;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    protected List<String> getPropertyList(String key) {
        return ListUtil.fromString(GetterUtil.getString(this.getProperty(key)), ",");
    }

    protected List<String> getRunOutsidePortalExcludes() {
        if (this._runOutsidePortalExcludes != null) {
            return this._runOutsidePortalExcludes;
        }
        List<String> runOutsidePortalExcludes = this.getPropertyList("run.outside.portal.excludes");
        this._runOutsidePortalExcludes = runOutsidePortalExcludes;
        return this._runOutsidePortalExcludes;
    }

    protected boolean hasMissingParentheses(String s) {
        boolean containsMathOperator;
        if (Validator.isNull(s)) {
            return false;
        }
        boolean containsAndOperator = s.contains("&&");
        boolean containsOrOperator = s.contains("||");
        if (containsAndOperator && containsOrOperator) {
            return true;
        }
        boolean containsCompareOperator = s.contains(" == ") || s.contains(" != ") || s.contains(" < ") || s.contains(" > ") || s.contains(" =< ") || s.contains(" => ") || s.contains(" <= ") || s.contains(" >= ");
        boolean bl = containsMathOperator = s.contains(" = ") || s.contains(" - ") || s.contains(" + ") || s.contains(" & ") || s.contains(" % ") || s.contains(" * ") || s.contains(" / ");
        return containsCompareOperator && (containsAndOperator || containsOrOperator || containsMathOperator && !s.contains("["));
    }

    protected boolean hasRedundantParentheses(String s) {
        if (!s.contains("&&") && !s.contains("||")) {
            int y;
            int x = 0;
            while ((x = s.indexOf(41)) != -1 && (y = s.substring(0, x).lastIndexOf(40)) != -1) {
                s = s.substring(0, y) + s.substring(x + 1);
            }
        }
        return Validator.isNotNull(s) && !s.contains(" ");
    }

    protected boolean hasRedundantParentheses(String s, String operator1, String operator2) {
        String[] parts = StringUtil.split(s, operator1);
        if (parts.length < 3) {
            return false;
        }
        for (int i = 1; i < parts.length - 1; ++i) {
            int openParenthesesCount;
            int closeParenthesesCount;
            String part = parts[i];
            if (part.contains(operator2) || part.contains("!(") || Math.abs((closeParenthesesCount = StringUtil.count(part, ")")) - (openParenthesesCount = StringUtil.count(part, "("))) != 1) continue;
            return true;
        }
        return false;
    }

    protected boolean isAttributName(String attributeName) {
        if (Validator.isNull(attributeName)) {
            return false;
        }
        Matcher matcher = attributeNamePattern.matcher(attributeName);
        return matcher.matches();
    }

    protected boolean isModulesFile(String absolutePath) {
        return absolutePath.contains("/modules/");
    }

    protected void postFormat() throws Exception {
    }

    protected void printError(String fileName, String message) {
        this._sourceFormatterHelper.printError(fileName, message);
    }

    protected void processErrorMessage(String fileName, String message) {
        List<String> errorMessages = this._errorMessagesMap.get(fileName);
        if (errorMessages == null) {
            errorMessages = new ArrayList<String>();
        }
        errorMessages.add(message);
        this._errorMessagesMap.put(fileName, errorMessages);
    }

    protected void processFormattedFile(File file, String fileName, String content, String newContent) throws IOException {
        List<String> errorMessages;
        if (this.sourceFormatterArgs.isPrintErrors() && (errorMessages = this._errorMessagesMap.get(fileName)) != null) {
            for (String errorMessage : errorMessages) {
                this._sourceFormatterHelper.printError(fileName, errorMessage);
            }
        }
        this._modifiedFileNames.add(file.getAbsolutePath());
        if (content.equals(newContent)) {
            return;
        }
        if (this.sourceFormatterArgs.isAutoFix()) {
            FileUtil.write(file, newContent);
        } else if (this._firstSourceMismatchException == null) {
            this._firstSourceMismatchException = new SourceMismatchException(fileName, content, newContent);
        }
        if (this.sourceFormatterArgs.isPrintErrors()) {
            this._sourceFormatterHelper.printError(fileName, file);
        }
    }

    protected String replacePrimitiveWrapperInstantiation(String line) {
        return StringUtil.replace(line, new String[]{"new Boolean(", "new Byte(", "new Character(", "new Double(", "new Float(", "new Integer(", "new Long(", "new Short("}, new String[]{"Boolean.valueOf(", "Byte.valueOf(", "Character.valueOf(", "Double.valueOf(", "Float.valueOf(", "Integer.valueOf(", "Long.valueOf(", "Short.valueOf("});
    }

    protected String sortAttributes(String fileName, String line, int lineCount, boolean allowApostropheDelimeter) throws Exception {
        String s = line;
        int x = s.indexOf(60);
        int y = s.indexOf(32);
        if (x == -1 || x >= y) {
            return line;
        }
        String tag = s.substring(x + 1, y);
        s = s.substring(y + 1);
        String previousAttribute = null;
        String previousAttributeAndValue = null;
        boolean wrongOrder = false;
        x = 0;
        while ((x = s.indexOf(61)) != -1 && s.length() > x + 1) {
            int lessThanCount;
            int greaterThanCount;
            int startJavaCodeSignCount;
            int endJavaCodeSignCount;
            char delimeter;
            String attribute = s.substring(0, x);
            if (!this.isAttributName(attribute)) {
                return line;
            }
            if (Validator.isNotNull(previousAttribute) && previousAttribute.compareToIgnoreCase(attribute) > 0) {
                wrongOrder = true;
            }
            if ((delimeter = (s = s.substring(x + 1)).charAt(0)) != '\'' && delimeter != '\"') {
                if (delimeter != '&') {
                    this.processErrorMessage(fileName, "delimeter: " + fileName + " " + lineCount);
                }
                return line;
            }
            s = s.substring(1);
            String value = null;
            y = -1;
            do {
                if ((y = s.indexOf(delimeter, y + 1)) != -1 && s.length() > y + 1) continue;
                return line;
            } while (!((value = s.substring(0, y)).startsWith("<%") ? (endJavaCodeSignCount = StringUtil.count(value, "%>")) == (startJavaCodeSignCount = StringUtil.count(value, "<%")) : (greaterThanCount = StringUtil.count(value, ">")) == (lessThanCount = StringUtil.count(value, "<"))));
            if (delimeter == '\'') {
                if (!value.contains("\"")) {
                    line = StringUtil.replace(line, "'" + value + "'", "\"" + value + "\"");
                    return this.sortAttributes(fileName, line, lineCount, allowApostropheDelimeter);
                }
                if (!allowApostropheDelimeter) {
                    String newValue = StringUtil.replace(value, "\"", "&quot;");
                    line = StringUtil.replace(line, "'" + value + "'", "\"" + newValue + "\"");
                    return this.sortAttributes(fileName, line, lineCount, allowApostropheDelimeter);
                }
            }
            StringBundler sb = new StringBundler(5);
            sb.append(attribute);
            sb.append("=");
            sb.append(delimeter);
            sb.append(value);
            sb.append(delimeter);
            String currentAttributeAndValue = sb.toString();
            String newLine = this.sortHTMLAttributes(line, value, currentAttributeAndValue);
            if (!newLine.equals(line)) {
                return this.sortAttributes(fileName, newLine, lineCount, allowApostropheDelimeter);
            }
            newLine = this.formatTagAttributeType(line, tag, currentAttributeAndValue);
            if (!newLine.equals(line)) {
                return this.sortAttributes(fileName, newLine, lineCount, allowApostropheDelimeter);
            }
            if (wrongOrder) {
                if (StringUtil.count(line, currentAttributeAndValue) == 1 && StringUtil.count(line, previousAttributeAndValue) == 1) {
                    line = StringUtil.replaceFirst(line, previousAttributeAndValue, currentAttributeAndValue);
                    line = StringUtil.replaceLast(line, currentAttributeAndValue, previousAttributeAndValue);
                    return this.sortAttributes(fileName, line, lineCount, allowApostropheDelimeter);
                }
                return line;
            }
            if ((s = s.substring(y + 1)).startsWith(">")) {
                x = s.indexOf(32);
                if (x == -1) {
                    return line;
                }
                s = s.substring(x + 1);
                previousAttribute = null;
                previousAttributeAndValue = null;
                continue;
            }
            s = StringUtil.trimLeading(s);
            previousAttribute = attribute;
            previousAttributeAndValue = currentAttributeAndValue;
        }
        return line;
    }

    protected String sortHTMLAttributes(String line, String value, String attributeAndValue) {
        return line;
    }

    protected String stripRedundantParentheses(String s) {
        int x = 0;
        while (true) {
            x = s.indexOf(40, x + 1);
            int y = s.indexOf(41, x);
            if (x == -1 || y == -1) {
                return s;
            }
            String linePart = s.substring(x + 1, y);
            if (!Validator.isAlphanumericName(linePart = StringUtil.replace(linePart, ",", "")) && !Validator.isNull(linePart)) continue;
            s = s.substring(0, x) + s.substring(y + 1);
        }
    }

    protected String trimContent(String content, boolean allowLeadingSpaces) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                sb.append(this.trimLine(line, allowLeadingSpaces));
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    protected String trimLine(String line, boolean allowLeadingSpaces) {
        if (line.trim().length() == 0) {
            return "";
        }
        line = StringUtil.trimTrailing(line);
        if (allowLeadingSpaces || !line.startsWith(" ") || line.startsWith(" *")) {
            return line;
        }
        if (!line.startsWith("    ")) {
            while (line.startsWith(" ")) {
                line = StringUtil.replaceFirst(line, " ", "");
            }
        } else {
            int pos = 0;
            String temp = line;
            while (temp.startsWith("    ")) {
                line = StringUtil.replaceFirst(line, "    ", "\t");
                temp = line.substring(++pos);
            }
        }
        return line;
    }

    private String[] _getExcludes() {
        if (this.sourceFormatterArgs.getFileNames() != null) {
            return new String[0];
        }
        List<String> excludesList = ListUtil.fromString(GetterUtil.getString(System.getProperty("source.formatter.excludes")));
        excludesList.addAll(this.getPropertyList("source.formatter.excludes"));
        return excludesList.toArray(new String[excludesList.size()]);
    }

    private Properties _getProperties() throws Exception {
        int i;
        String fileName = "source-formatter.properties";
        Properties properties = new Properties();
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        int level = 2;
        if (portalSource) {
            level = 5;
        }
        for (i = 0; i <= level; ++i) {
            try {
                FileInputStream inputStream = new FileInputStream(this.sourceFormatterArgs.getBaseDirName() + fileName);
                Properties props = new Properties();
                props.load(inputStream);
                propertiesList.add(props);
                break;
            }
            catch (FileNotFoundException fnfe) {
                fileName = "../" + fileName;
                continue;
            }
        }
        if (propertiesList.isEmpty()) {
            return properties;
        }
        properties = (Properties)propertiesList.get(0);
        if (propertiesList.size() == 1) {
            return properties;
        }
        for (i = 1; i < propertiesList.size(); ++i) {
            Properties props = (Properties)propertiesList.get(i);
            Enumeration<?> enu = props.propertyNames();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                String value = props.getProperty(key);
                if (Validator.isNull(value)) continue;
                if (key.contains("excludes")) {
                    String existingValue = properties.getProperty(key);
                    if (Validator.isNotNull(existingValue)) {
                        value = existingValue + "," + value;
                    }
                    properties.put(key, value);
                    continue;
                }
                if (properties.containsKey(key)) continue;
                properties.put(key, value);
            }
        }
        return properties;
    }

    private void _init() {
        portalSource = this._isPortalSource();
        this._errorMessagesMap = new HashMap<String, List<String>>();
        try {
            this._properties = this._getProperties();
            this._sourceFormatterHelper = new SourceFormatterHelper(this.sourceFormatterArgs.isUseProperties());
            this._sourceFormatterHelper.init();
        }
        catch (Exception e) {
            ReflectionUtil.throwException(e);
        }
        this._excludes = this._getExcludes();
        this._usePortalCompatImport = GetterUtil.getBoolean(this.getProperty("use.portal.compat.import"));
    }

    private boolean _isMatchPath(String fileName) {
        for (String pattern : this.getIncludes()) {
            if (!SelectorUtils.matchPath((String)this._normalizePattern(pattern), (String)fileName)) continue;
            return true;
        }
        return false;
    }

    private boolean _isPortalSource() {
        return this.getFile("portal-impl", 5) != null;
    }

    private String _normalizePattern(String originalPattern) {
        String pattern = originalPattern.replace('/', File.separatorChar);
        if ((pattern = pattern.replace('\\', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    static {
        principalExceptionPattern = Pattern.compile("SessionErrors\\.contains\\(\n?\t*(renderR|r)equest, PrincipalException\\.class\\.getName\\(\\)");
        sessionKeyPattern = Pattern.compile("SessionErrors.(?:add|contains|get)\\([^;%&|!]+|".concat("SessionMessages.(?:add|contains|get)\\([^;%&|!]+"), 8);
        taglibSessionKeyPattern = Pattern.compile("<liferay-ui:error [^>]+>|<liferay-ui:success [^>]+>", 8);
    }
}

