/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core;

import com.liferay.poshi.core.util.ListUtil;
import com.liferay.poshi.core.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiVariablesContext {
    private static final Pattern _pattern = Pattern.compile("\\$\\{([^}]*)\\}");
    private static final Map<String, PoshiVariablesContext> _poshiVariablesContexts = new HashMap<String, PoshiVariablesContext>();
    private Map<String, Object> _commandMap = new HashMap<String, Object>();
    private final Stack<Map<String, Object>> _commandMapStack = new Stack();
    private Map<String, Object> _executeMap = new HashMap<String, Object>();
    private final Map<String, Object> _staticMap = new HashMap<String, Object>();

    public static void clear(String classCommandName) {
        if (_poshiVariablesContexts.containsKey(classCommandName)) {
            _poshiVariablesContexts.remove(classCommandName);
        }
    }

    public static synchronized PoshiVariablesContext getPoshiVariablesContext(String classCommandName) {
        if (!_poshiVariablesContexts.containsKey(classCommandName)) {
            _poshiVariablesContexts.put(classCommandName, new PoshiVariablesContext());
        }
        return _poshiVariablesContexts.get(classCommandName);
    }

    public boolean containsKeyInCommandMap(String key) {
        return this._commandMap.containsKey(this.replaceCommandVars(key));
    }

    public boolean containsKeyInExecuteMap(String key) {
        return this._executeMap.containsKey(this.replaceCommandVars(key));
    }

    public boolean containsKeyInStaticMap(String key) {
        return this._staticMap.containsKey(this.replaceCommandVars(key));
    }

    public String getReplacedCommandVarsString(String token) {
        if (token == null) {
            return null;
        }
        Object tokenObject = this.replaceCommandVars(token);
        if (tokenObject instanceof List) {
            return ListUtil.toString((List)tokenObject);
        }
        return tokenObject.toString();
    }

    public String getStringFromCommandMap(String key) {
        if (this.containsKeyInCommandMap((String)this.replaceCommandVars(key))) {
            Object object = this.getValueFromCommandMap(key);
            return object.toString();
        }
        return null;
    }

    public String getStringFromExecuteMap(String key) {
        if (this.containsKeyInExecuteMap((String)this.replaceCommandVars(key))) {
            Object object = this.getValueFromExecuteMap(key);
            return object.toString();
        }
        return null;
    }

    public String getStringFromStaticMap(String key) {
        if (this.containsKeyInStaticMap((String)this.replaceStaticVars(key))) {
            Object object = this.getValueFromExecuteMap(key);
            return object.toString();
        }
        return null;
    }

    public Object getValueFromCommandMap(String key) {
        return this._commandMap.get(this.replaceCommandVars(key));
    }

    public Object getValueFromExecuteMap(String key) {
        return this._executeMap.get(this.replaceCommandVars(key));
    }

    public Object getValueFromStaticMap(String key) {
        return this._staticMap.get(this.replaceCommandVars(key));
    }

    public void popCommandMap() {
        this._commandMap = this._commandMapStack.pop();
        this._commandMap.putAll(this._staticMap);
        this._executeMap = new HashMap<String, Object>();
    }

    public void pushCommandMap() {
        this._commandMapStack.push(this._commandMap);
        this._commandMap = this._executeMap;
        this._commandMap.putAll(this._staticMap);
        this._executeMap = new HashMap<String, Object>();
    }

    public void pushStaticVarsIntoCommandMap() {
        this._commandMap.putAll(this._staticMap);
        this._commandMapStack.push(this._commandMap);
    }

    public void putIntoCommandMap(String key, Object value) {
        if (value instanceof String) {
            this._commandMap.put((String)this.replaceCommandVars(key), this.replaceCommandVars((String)value));
        } else {
            this._commandMap.put((String)this.replaceCommandVars(key), value);
        }
        if (this.containsKeyInStaticMap(key)) {
            this.putIntoStaticMap(key, value);
        }
    }

    public void putIntoExecuteMap(String key, Object value) {
        if (value instanceof String) {
            this._executeMap.put((String)this.replaceCommandVars(key), this.replaceCommandVars((String)value));
        } else {
            this._executeMap.put((String)this.replaceCommandVars(key), value);
        }
    }

    public void putIntoStaticMap(String key, Object value) {
        if (value instanceof String) {
            this._staticMap.put((String)this.replaceCommandVars(key), this.replaceCommandVars((String)value));
        } else {
            this._staticMap.put((String)this.replaceCommandVars(key), value);
        }
    }

    public Object replaceCommandVars(String token) {
        Matcher matcher = _pattern.matcher(token);
        if (matcher.matches() && this._commandMap.containsKey(matcher.group(1))) {
            return this.getValueFromCommandMap(matcher.group(1));
        }
        matcher.reset();
        while (matcher.find() && this._commandMap.containsKey(matcher.group(1))) {
            String varValue = this.getStringFromCommandMap(matcher.group(1));
            token = StringUtil.replace(token, matcher.group(), varValue);
        }
        return token;
    }

    public Object replaceExecuteVars(String token) {
        Matcher matcher = _pattern.matcher(token);
        if (matcher.matches() && this._executeMap.containsKey(matcher.group(1))) {
            return this.getValueFromExecuteMap(matcher.group(1));
        }
        matcher.reset();
        while (matcher.find() && this._executeMap.containsKey(matcher.group(1))) {
            String varValue = this.getStringFromExecuteMap(matcher.group(1));
            token = StringUtil.replace(token, matcher.group(), varValue);
        }
        return token;
    }

    public Object replaceStaticVars(String token) {
        Matcher matcher = _pattern.matcher(token);
        if (matcher.matches() && this._staticMap.containsKey(matcher.group(1))) {
            return this.getValueFromStaticMap(matcher.group(1));
        }
        matcher.reset();
        while (matcher.find() && this._staticMap.containsKey(matcher.group(1))) {
            String varValue = this.getStringFromStaticMap(matcher.group(1));
            token = StringUtil.replace(token, matcher.group(), varValue);
        }
        return token;
    }

    private PoshiVariablesContext() {
    }
}

