/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaMultiVMPoolUtilCheck
extends BaseFileCheck {
    private static final String _MULTI_VM_POOL_UTIL_IMPORT = "import com.liferay.portal.kernel.cache.MultiVMPoolUtil;";
    private static final String _WARNING_CASE_TYPE = "(PortalCache<TO_BE_REPLACED, TO_BE_REPLACED>)";
    private static final Pattern _getPortalCachePattern = Pattern.compile("PortalCache\\s*(<.+, +?.+>)\\s*\\w+\\s*=\\s*MultiVMPoolUtil\\.getPortalCache\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".java")) {
            return content;
        }
        if (content.contains(_MULTI_VM_POOL_UTIL_IMPORT)) {
            content = StringUtil.replace(content, _MULTI_VM_POOL_UTIL_IMPORT, "import com.liferay.portal.kernel.cache.MultiVMPool;");
            content = this._replaceGetPortalCache(content);
        }
        if (content.contains(_WARNING_CASE_TYPE)) {
            this.addMessage(fileName, "Could not resolve types for MultiVMPool.getPortalCache(). Replace 'TO_BE_REPLACED' with the correct type");
        }
        return content;
    }

    private String _replaceGetPortalCache(String content) {
        content = JavaSourceUtil.addImports(content, "org.osgi.service.component.annotations.Reference");
        Matcher portalCacheMatcher = _getPortalCachePattern.matcher(content);
        while (portalCacheMatcher.find()) {
            String newDeclaration = StringUtil.replace(portalCacheMatcher.group(0), "MultiVMPoolUtil.getPortalCache(", "(PortalCache" + portalCacheMatcher.group(1) + ") _multiVMPool.getPortalCache(");
            content = StringUtil.replace(content, portalCacheMatcher.group(0), newDeclaration);
        }
        content = StringUtil.replace(content, "MultiVMPoolUtil.getPortalCache(", "(PortalCache<TO_BE_REPLACED, TO_BE_REPLACED>) _multiVMPool.getPortalCache(");
        content = StringUtil.replaceLast(content, '}', "\n\t@Reference\n\tprivate MultiVMPool _multiVMPool;\n\n}");
        return content;
    }
}

