/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class InstanceInitializerCheck
extends BaseCheck {
    private static final String _MSG_ASSIGN_ORDER_INCORRECT = "assign.incorrect.order";
    private static final String _MSG_METHOD_CALL_ORDER_INCORRECT = "method.call.incorrect.order";
    private static final String _MSG_MOVE_ASSIGN_BEFORE_METHOD_CALL = "assign.move.before.method.call";

    public int[] getDefaultTokens() {
        return new int[]{11};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 6) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 136) {
            return;
        }
        DetailAST childDetailAST = detailAST.getFirstChild();
        if (childDetailAST.getType() != 7) {
            return;
        }
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(childDetailAST, false, 28);
        if (exprDetailASTList.size() < 2) {
            return;
        }
        this._checkAttributeOrder(exprDetailASTList);
    }

    private void _checkAttributeOrder(List<DetailAST> exprDetailASTList) {
        String previousVariableName = null;
        String previousMethodName = null;
        for (DetailAST exprDetailAST : exprDetailASTList) {
            String methodName;
            DetailAST childDetailAST = exprDetailAST.getFirstChild();
            if (childDetailAST.getType() == 80) {
                String variableName = this.getName(childDetailAST);
                if (Validator.isNotNull(this.getTypeName(this.getVariableTypeDetailAST(childDetailAST, variableName, false), false))) continue;
                if (previousVariableName != null && previousVariableName.compareToIgnoreCase(variableName) > 0) {
                    this.log(exprDetailAST, _MSG_ASSIGN_ORDER_INCORRECT, new Object[]{variableName, previousVariableName, childDetailAST.getLineNo()});
                } else if (Validator.isNotNull(previousMethodName)) {
                    this.log(exprDetailAST, _MSG_MOVE_ASSIGN_BEFORE_METHOD_CALL, new Object[]{variableName, previousMethodName, childDetailAST.getLineNo()});
                }
                previousVariableName = variableName;
                continue;
            }
            if (childDetailAST.getType() != 27 || Validator.isNull(methodName = this.getName(childDetailAST)) || !methodName.matches("set[A-Z].+")) continue;
            if (previousMethodName != null && previousMethodName.compareToIgnoreCase(methodName) > 0) {
                this.log(exprDetailAST, _MSG_METHOD_CALL_ORDER_INCORRECT, new Object[]{methodName, previousMethodName, childDetailAST.getLineNo()});
            }
            previousMethodName = methodName;
        }
    }
}

