/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.processor.SourceProcessor;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CopyrightCheck
extends BaseFileCheck {
    private static final String _XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".tpl") && !fileName.endsWith(".vm")) {
            content = this._fixCopyright(fileName, absolutePath, content);
        }
        return content;
    }

    private String _fixCopyright(String fileName, String absolutePath, String content) throws Exception {
        int x = content.indexOf("/**\n * SPDX-FileCopyrightText: (c) ");
        if (x == -1) {
            this.addMessage(fileName, "Missing copyright");
            return content;
        }
        String s = content.substring(x + 35, content.indexOf("\n", x + 35));
        if (!s.matches("\\d{4} Liferay, Inc\\. https://liferay\\.com")) {
            this.addMessage(fileName, "Missing copyright");
            return content;
        }
        if (!(content.startsWith("/**\n * SPDX-FileCopyrightText: (c) ") || content.startsWith("<%--\n/**\n * SPDX-FileCopyrightText: (c) ") || content.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--\n/**\n * SPDX-FileCopyrightText: (c) "))) {
            this.addMessage(fileName, "File must start with copyright");
            return content;
        }
        SourceProcessor sourceProcessor = this.getSourceProcessor();
        SourceFormatterArgs sourceFormatterArgs = sourceProcessor.getSourceFormatterArgs();
        if (sourceFormatterArgs.isFormatCurrentBranch()) {
            for (String currentBranchRenamedFileName : GitUtil.getCurrentBranchRenamedFileNames(sourceFormatterArgs.getBaseDirName(), sourceFormatterArgs.getGitWorkingBranchName())) {
                if (!absolutePath.endsWith(currentBranchRenamedFileName)) continue;
                return content;
            }
            String rootDirName = SourceUtil.getRootDirName(absolutePath);
            if (Validator.isNull(rootDirName)) {
                return content;
            }
            String portalBranchName = this.getAttributeValue("git.liferay.portal.branch", absolutePath);
            URL url = SourceFormatterUtil.getPortalGitURL(absolutePath.substring(rootDirName.length()), portalBranchName);
            try {
                HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
                httpURLConnection.setConnectTimeout(5000);
                httpURLConnection.setReadTimeout(5000);
                httpURLConnection.setRequestMethod("HEAD");
                if (httpURLConnection.getResponseCode() != 200) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
                    String currentYear = simpleDateFormat.format(new Date());
                    String year = s.substring(0, 4);
                    if (!year.equals(currentYear)) {
                        content = StringUtil.replaceFirst(content, year, currentYear, x + 35);
                    }
                }
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                this.addMessage(fileName, exception.getMessage());
            }
        }
        return content;
    }
}

