/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaOSGiReferenceCheck
extends BaseFileCheck {
    private static final String _SERVICE_REFERENCE_UTIL_CLASS_NAMES_KEY = "serviceReferenceUtilClassNames";
    private static final Pattern _referenceMethodContentPattern = Pattern.compile("^(\\w+) =\\s+\\w+;$");
    private static final Pattern _referenceMethodPattern = Pattern.compile("\n\t@Reference([\\s\\S]*?)\\s+((protected|public) void (\\w+?))\\(\\s*([ ,<>?\\w]+)\\s+\\w+\\) \\{\\s+([\\s\\S]*?)\\s*?\n\t\\}\n");
    private static final Pattern _serviceUtilImportPattern = Pattern.compile("\nimport ([A-Za-z1-9\\.]*)\\.([A-Za-z1-9]*ServiceUtil);");
    private final Set<String> _bndFileNames = new CopyOnWriteArraySet<String>();
    private final Map<String, String> _moduleFileContentsMap = new ConcurrentHashMap<String, String>();
    private Map<String, String> _moduleFileNamesMap;
    private List<String> _serviceProxyFactoryUtilClassNames;

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!content.contains("@Component")) {
            return content;
        }
        String packageName = JavaSourceUtil.getPackageName(content);
        if (!packageName.startsWith("com.liferay")) {
            return content;
        }
        this._checkMissingReference(fileName, content);
        String moduleSuperClassContent = this._getModuleSuperClassContent(content, JavaSourceUtil.getClassName(fileName), packageName);
        content = this._formatDuplicateReferenceMethods(fileName, content, moduleSuperClassContent);
        if (!this.isExcludedPath("service.reference.util.excludes", absolutePath)) {
            for (String serviceProxyFactoryUtilClassName : this._getServiceProxyFactoryUtilClassNames()) {
                this._checkUtilUsage(fileName, content, serviceProxyFactoryUtilClassName, moduleSuperClassContent);
            }
        }
        List<String> serviceReferenceUtilClassNames = this.getAttributeValues(_SERVICE_REFERENCE_UTIL_CLASS_NAMES_KEY, absolutePath);
        for (String serviceReferenceUtilClassName : serviceReferenceUtilClassNames) {
            this._checkUtilUsage(fileName, content, serviceReferenceUtilClassName, moduleSuperClassContent);
        }
        this._checkUnnecessaryVariableInjection(fileName, absolutePath, content);
        return content;
    }

    private void _checkMissingReference(String fileName, String content) {
        String moduleServicePackageName = null;
        Matcher matcher = _serviceUtilImportPattern.matcher(content);
        while (matcher.find()) {
            String serviceUtilClassPackageName;
            String serviceUtilClassName = matcher.group(2);
            if (serviceUtilClassName.equals("IdentifiableOSGiServiceUtil") || serviceUtilClassName.equals("SystemExecutorServiceUtil")) continue;
            if (moduleServicePackageName == null) {
                moduleServicePackageName = this._getModuleServicePackageName(fileName);
            }
            if (Validator.isNotNull(moduleServicePackageName) && (serviceUtilClassPackageName = matcher.group(1)).startsWith(moduleServicePackageName)) continue;
            this.addMessage(fileName, "Use @Reference instead of calling " + serviceUtilClassName + " directly");
        }
    }

    private void _checkUnnecessaryVariableInjection(String fileName, String absolutePath, String content) throws Exception {
        if (!(absolutePath.contains("-service/") && absolutePath.contains("/service/impl/") && fileName.endsWith("ServiceImpl.java"))) {
            return;
        }
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        String bndSettingsContent = bndSettings.getContent();
        if (!bndSettingsContent.contains("-dsannotations-options: inherit")) {
            return;
        }
        String serviceBaseClassPath = StringUtil.replace(absolutePath, new String[]{"/service/impl/", "Impl.java"}, new String[]{"/service/base/", "BaseImpl.java"});
        File file = new File(serviceBaseClassPath);
        if (!file.exists()) {
            return;
        }
        JavaClass serviceBaseJavaClass = JavaClassParser.parseJavaClass(serviceBaseClassPath, FileUtil.read(file));
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            String fieldTypeClassName;
            if (!javaTerm.hasAnnotation() || !javaTerm.isJavaVariable() || !javaTerm.isPrivate() || Validator.isNull(fieldTypeClassName = this._getFieldTypeClassName(javaTerm, "private", javaClass))) continue;
            for (JavaTerm serviceBaseJavaTerm : serviceBaseJavaClass.getChildJavaTerms()) {
                String serviceBaseFieldTypeClassName;
                if (!serviceBaseJavaTerm.hasAnnotation() || !serviceBaseJavaTerm.isJavaVariable() || !serviceBaseJavaTerm.isProtected() || !Validator.isNotNull(serviceBaseFieldTypeClassName = this._getFieldTypeClassName(serviceBaseJavaTerm, "protected", serviceBaseJavaClass)) || !fieldTypeClassName.equals(serviceBaseFieldTypeClassName)) continue;
                this.addMessage(fileName, "Use super class variable '" + serviceBaseJavaTerm.getName() + "' instead of injection", javaTerm.getLineNumber());
            }
        }
    }

    private void _checkUtilUsage(String fileName, String content, String serviceReferenceUtilClassName, String moduleSuperClassContent) throws Exception {
        if (!content.contains(serviceReferenceUtilClassName) || Validator.isNotNull(moduleSuperClassContent) && moduleSuperClassContent.contains("@Component")) {
            return;
        }
        int pos = serviceReferenceUtilClassName.lastIndexOf(".");
        String shortClassName = serviceReferenceUtilClassName.substring(pos + 1);
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            String javaTermContent;
            if (javaTerm.isStatic() || !javaTerm.isJavaConstructor() && !javaTerm.isJavaMethod() || javaTerm.hasAnnotation("Reference") || !(javaTermContent = javaTerm.getContent()).matches(StringBundler.concat("(?s).*", shortClassName, "\\.(?!class).*"))) continue;
            this.addMessage(fileName, "Use portal service reference instead of '" + serviceReferenceUtilClassName + "' in modules");
            return;
        }
    }

    private String _formatDuplicateReferenceMethods(String fileName, String content, String moduleSuperClassContent) throws Exception {
        BNDSettings bndSettings;
        String bndSettingsContent;
        if (Validator.isNull(moduleSuperClassContent) || !moduleSuperClassContent.contains("@Component") || !moduleSuperClassContent.contains("@Reference")) {
            return content;
        }
        Matcher matcher = _referenceMethodPattern.matcher(moduleSuperClassContent);
        boolean bndInheritRequired = false;
        while (matcher.find()) {
            String referenceMethod = matcher.group();
            int pos = content.indexOf(referenceMethod);
            if (pos != -1) {
                String variableName;
                String referenceMethodContent = matcher.group(6);
                Matcher referenceMethodContentMatcher = _referenceMethodContentPattern.matcher(referenceMethodContent);
                if (referenceMethodContentMatcher.find() && StringUtil.count(content, variableName = referenceMethodContentMatcher.group(1)) > 1) continue;
                int x = content.lastIndexOf("\n\n", pos);
                int y = pos + referenceMethod.length();
                String entireMethod = content.substring(x + 1, y);
                content = StringUtil.removeSubstring(content, entireMethod);
                bndInheritRequired = true;
                continue;
            }
            String referenceMethodModifierAndName = matcher.group(2);
            Pattern duplicateReferenceMethodPattern = Pattern.compile(referenceMethodModifierAndName + "\\(\\s*([ ,<>\\w]+)\\s+\\w+\\) \\{\\s+([\\s\\S]*?)\\s*?\n\t\\}\n");
            Matcher duplicateReferenceMethodMatcher = duplicateReferenceMethodPattern.matcher(content);
            if (!duplicateReferenceMethodMatcher.find()) {
                bndInheritRequired = true;
                continue;
            }
            String methodContent = duplicateReferenceMethodMatcher.group(2);
            String referenceMethodName = matcher.group(4);
            if (!methodContent.startsWith("super." + referenceMethodName)) continue;
            int x = content.lastIndexOf("\n\n", duplicateReferenceMethodMatcher.start());
            int y = duplicateReferenceMethodMatcher.end();
            String entireMethod = content.substring(x + 1, y);
            content = StringUtil.removeSubstring(content, entireMethod);
            bndInheritRequired = true;
        }
        if (bndInheritRequired && !(bndSettingsContent = (bndSettings = this.getBNDSettings(fileName)).getContent()).contains("-dsannotations-options: inherit") && this._bndFileNames.add(bndSettings.getFileName())) {
            this.addMessage(fileName, "Add '-dsannotations-options: inherit' to '" + bndSettings.getFileName());
        }
        return content;
    }

    private String _getFieldTypeClassName(JavaTerm javaTerm, String accessModifier, JavaClass javaClass) {
        Pattern pattern = Pattern.compile("@Reference\n\t+" + accessModifier + "\\s(\\S+)\\s+(\\S+\\.)?\\w+");
        Matcher matcher = pattern.matcher(javaTerm.getContent());
        if (!matcher.find()) {
            return null;
        }
        String fieldTypeClassName = matcher.group(1);
        if (!fieldTypeClassName.contains(".")) {
            fieldTypeClassName = this._getFullyQualifiedName(fieldTypeClassName, javaClass);
        }
        return fieldTypeClassName;
    }

    private String _getFullyQualifiedName(String className, JavaClass javaClass) {
        for (String importName : javaClass.getImportNames()) {
            if (!importName.endsWith("." + className)) continue;
            return importName;
        }
        return javaClass.getPackageName() + "." + className;
    }

    private String _getModuleClassContent(String fullClassName) throws Exception {
        String classContent = this._moduleFileContentsMap.get(fullClassName);
        if (classContent != null) {
            return classContent;
        }
        Map<String, String> moduleFileNamesMap = this._getModuleFileNamesMap();
        String moduleFileName = moduleFileNamesMap.get(fullClassName);
        if (moduleFileName == null) {
            this._moduleFileContentsMap.put(fullClassName, "");
            return "";
        }
        File file = new File(moduleFileName);
        classContent = FileUtil.read(file);
        if (classContent != null) {
            this._moduleFileContentsMap.put(fullClassName, classContent);
        }
        return classContent;
    }

    private synchronized Map<String, String> _getModuleFileNamesMap() throws Exception {
        if (this._moduleFileNamesMap != null) {
            return this._moduleFileNamesMap;
        }
        this._moduleFileNamesMap = new HashMap<String, String>();
        List<Object> fileNames = new ArrayList();
        String moduleRootDirLocation = "modules/";
        for (int i = 0; i < 6; ++i) {
            File file = new File(this.getBaseDirName() + moduleRootDirLocation);
            if (file.exists()) {
                fileNames = this.getFileNames(this.getBaseDirName() + moduleRootDirLocation, new String[0], new String[]{"**/*.java"});
                break;
            }
            moduleRootDirLocation = "../" + moduleRootDirLocation;
        }
        for (String fileName : fileNames) {
            fileName = StringUtil.replace(fileName, '\\', '/');
            String className = StringUtil.replace(fileName, '/', '.');
            int pos = className.lastIndexOf(".com.liferay.");
            className = className.substring(pos + 1, fileName.length() - 5);
            this._moduleFileNamesMap.put(className, fileName);
        }
        return this._moduleFileNamesMap;
    }

    private String _getModuleServicePackageName(String fileName) {
        int pos;
        String serviceDirLocation = fileName;
        while (true) {
            if ((pos = serviceDirLocation.lastIndexOf("/")) == -1) {
                return "";
            }
            File file = new File((serviceDirLocation = serviceDirLocation.substring(0, pos + 1)) + "service");
            if (file.exists()) break;
            file = new File(serviceDirLocation + "liferay");
            if (file.exists()) {
                return "";
            }
            serviceDirLocation = StringUtil.replaceLast(serviceDirLocation, '/', "");
        }
        serviceDirLocation = serviceDirLocation + "service";
        serviceDirLocation = StringUtil.replace(serviceDirLocation, '/', '.');
        pos = serviceDirLocation.lastIndexOf(".com.");
        return serviceDirLocation.substring(pos + 1);
    }

    private String _getModuleSuperClassContent(String content, String className, String packageName) throws Exception {
        Pattern pattern = Pattern.compile(" class " + className + "\\s+extends\\s+([\\w.]+) ");
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        String superClassName = matcher.group(1);
        if (superClassName.contains(".")) {
            if (!superClassName.startsWith("com.liferay")) {
                return null;
            }
            return this._getModuleClassContent(superClassName);
        }
        String superClassPackageName = packageName;
        pattern = Pattern.compile("\nimport (.+?)\\." + superClassName + ";");
        matcher = pattern.matcher(content);
        if (matcher.find()) {
            superClassPackageName = matcher.group(1);
        }
        if (!superClassPackageName.startsWith("com.liferay")) {
            return null;
        }
        String superClassFullClassName = superClassPackageName + "." + superClassName;
        return this._getModuleClassContent(superClassFullClassName);
    }

    private synchronized List<String> _getServiceProxyFactoryUtilClassNames() throws Exception {
        if (this._serviceProxyFactoryUtilClassNames != null) {
            return this._serviceProxyFactoryUtilClassNames;
        }
        if (!this.isPortalSource()) {
            this._serviceProxyFactoryUtilClassNames = Collections.emptyList();
            return this._serviceProxyFactoryUtilClassNames;
        }
        String portalKernelLocation = "portal-kernel/";
        for (int i = 0; i < this.getMaxDirLevel() - 1; ++i) {
            File file = new File(this.getBaseDirName() + portalKernelLocation);
            if (file.exists()) {
                this._serviceProxyFactoryUtilClassNames = new ArrayList<String>();
                List<String> utilFileNames = this.getFileNames(this.getBaseDirName() + portalKernelLocation, new String[0], new String[]{"**/*Util.java"});
                for (String fileName : utilFileNames) {
                    String content = FileUtil.read(new File(fileName = StringUtil.replace(fileName, '\\', '/')));
                    if (!content.contains("com.liferay.portal.kernel.util.ServiceProxyFactory")) continue;
                    this._serviceProxyFactoryUtilClassNames.add(JavaSourceUtil.getPackageName(content) + "." + JavaSourceUtil.getClassName(fileName));
                }
                return this._serviceProxyFactoryUtilClassNames;
            }
            portalKernelLocation = "../" + portalKernelLocation;
        }
        this._serviceProxyFactoryUtilClassNames = Collections.emptyList();
        return this._serviceProxyFactoryUtilClassNames;
    }
}

