/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesLanguageKeysContextCheck
extends BaseFileCheck {
    private static final String _ALLOWED_SINGLE_WORD_LANGUAGE_KEYS_KEY = "allowedSingleWordLanguageKeys";
    private static final String _CONTEXT_DEPTH_KEY = "contextDepth";
    private static final String _FORBIDDEN_CONTEXT_NAMES_KEY = "forbiddenContextNames";
    private static final Pattern _languageKeyPattern = Pattern.compile("([\\s\\S]+)\\[([\\s\\S]*)\\]");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("/content/Language.properties")) {
            return content;
        }
        List<String> allowedSingleWordLanguageKeys = this.getAttributeValues(_ALLOWED_SINGLE_WORD_LANGUAGE_KEYS_KEY, absolutePath);
        int contextDepth = GetterUtil.getInteger(this.getAttributeValue(_CONTEXT_DEPTH_KEY, absolutePath));
        List<String> forbiddenContextNames = this.getAttributeValues(_FORBIDDEN_CONTEXT_NAMES_KEY, absolutePath);
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String bracketsContent;
            Matcher matcher;
            String key = (String)enumeration.nextElement();
            if (key.matches("\\w+") && StringUtil.equalsIgnoreCase(key, properties.getProperty(key)) && !allowedSingleWordLanguageKeys.contains(key)) {
                this.addMessage(fileName, StringBundler.concat("The single-word key '", key, "' should include a word of context at the end, ", "within a [], to indicate specific meaning"));
                continue;
            }
            if (contextDepth != 0 && StringUtil.count(key, "-") + 1 != contextDepth || !(matcher = _languageKeyPattern.matcher(key)).matches()) continue;
            if (properties.containsKey(matcher.group(1))) {
                this.addMessage(fileName, StringBundler.concat("The key '", matcher.group(1), "' should include a ", "word of context at the end, within a [], to indicate ", "specific meaning"));
            }
            if (!((bracketsContent = matcher.group(2)).length() == 0 || bracketsContent.length() == 1 && !bracketsContent.equals("n") && !bracketsContent.equals("v") || bracketsContent.matches("\\d+") && !key.contains("code") && !key.contains("status")) && !forbiddenContextNames.contains(bracketsContent)) continue;
            this.addMessage(fileName, StringBundler.concat("The context '", bracketsContent, "' is invalid in the key '", key, "'"));
        }
        return content;
    }
}

