/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaFDSDataProviderCheck
extends BaseFileCheck {
    private static final Pattern _methodCallGetItemsCountPattern = Pattern.compile("\\w+\\.getItemsCount\\((\\s*.+,\\s*.+)\\s*\\)");
    private static final Pattern _methodCallGetItemsPattern = Pattern.compile("\\w+\\.getItems\\((\\s*.+,\\s*.+,\\s*.+,\\s*.+)\\s*\\)");
    private static final Pattern _methodGetItemsCountPattern = Pattern.compile("getItemsCount\\((\\s*HttpServletRequest\\s*.+,\\s*.+)\\s*\\)");
    private static final Pattern _methodGetItemsPattern = Pattern.compile("getItems\\((\\s*HttpServletRequest\\s*.+,\\s*.+,\\s*.+,\\s*.+)\\s*\\)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".java")) {
            return content;
        }
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        List<String> importNames = javaClass.getImportNames();
        if (!importNames.contains("com.liferay.frontend.data.set.provider.FDSDataProvider")) {
            return content;
        }
        return this._formatMethodDefinitions(content, javaClass);
    }

    private String _formatMethodCalls(String content, String javaMethodContent) {
        Matcher methodCallGetItemsMatcher = _methodCallGetItemsPattern.matcher(javaMethodContent);
        while (methodCallGetItemsMatcher.find()) {
            String methodCall = JavaSourceUtil.getMethodCall(javaMethodContent, methodCallGetItemsMatcher.start());
            List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
            if (!this._hasClassNameHttpServletRequest(javaMethodContent, content, parameterList.get(0)) || !this._isFDSDataProviderMethodCall(javaMethodContent, content, methodCall)) continue;
            javaMethodContent = StringUtil.replace(javaMethodContent, methodCall, this._reorderParametersGetItems(methodCall, methodCallGetItemsMatcher.group(1)));
        }
        Matcher methodCallGetItemsCountMatcher = _methodCallGetItemsCountPattern.matcher(javaMethodContent);
        while (methodCallGetItemsCountMatcher.find()) {
            String methodCall = JavaSourceUtil.getMethodCall(javaMethodContent, methodCallGetItemsCountMatcher.start());
            List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
            if (!this._hasClassNameHttpServletRequest(javaMethodContent, content, parameterList.get(0)) || !this._isFDSDataProviderMethodCall(javaMethodContent, content, methodCall)) continue;
            javaMethodContent = StringUtil.replace(javaMethodContent, methodCall, this._reorderParametersGetItemsCount(methodCall, methodCallGetItemsCountMatcher.group(1)));
        }
        return javaMethodContent;
    }

    private String _formatMethodDefinition(String javaMethodContent) {
        Matcher matcher = _methodGetItemsPattern.matcher(javaMethodContent);
        boolean matchedGetItems = matcher.find();
        if (!matchedGetItems && !(matcher = _methodGetItemsCountPattern.matcher(javaMethodContent)).find()) {
            return javaMethodContent;
        }
        String methodCall = JavaSourceUtil.getMethodCall(javaMethodContent, matcher.start());
        String newMethodCall = matchedGetItems ? this._reorderParametersGetItems(methodCall, matcher.group(1)) : this._reorderParametersGetItemsCount(methodCall, matcher.group(1));
        return StringUtil.replace(javaMethodContent, methodCall, newMethodCall);
    }

    private String _formatMethodDefinitions(String content, JavaClass javaClass) {
        List<String> implementedClassNames = javaClass.getImplementedClassNames();
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaMethod()) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            String javaMethodContent = javaMethod.getContent();
            if (implementedClassNames.contains("FDSDataProvider")) {
                javaMethodContent = this._formatMethodDefinition(javaMethodContent);
            }
            javaMethodContent = this._formatMethodCalls(javaClass.getContent(), javaMethodContent);
            content = StringUtil.replace(content, javaMethod.getContent(), javaMethodContent);
        }
        return content;
    }

    private boolean _hasClassNameHttpServletRequest(String content, String fileContent, String variableName) {
        return Objects.equals(this.getVariableTypeName(content, fileContent, variableName), "HttpServletRequest");
    }

    private boolean _isFDSDataProviderMethodCall(String content, String fileContent, String methodCall) {
        String variableTypeName = this.getVariableTypeName(content, fileContent, methodCall.substring(0, methodCall.indexOf(".")), true);
        return variableTypeName.contains("FDSDataProvider");
    }

    private String _reorderParametersGetItems(String methodCall, String parameters) {
        List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
        return StringUtil.replace(methodCall, parameters, StringBundler.concat(parameterList.get(1), ", ", parameterList.get(2), ", ", parameterList.get(0), ", ", parameterList.get(3)));
    }

    private String _reorderParametersGetItemsCount(String methodCall, String parameters) {
        List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
        return StringUtil.replace(methodCall, parameters, StringBundler.concat(parameterList.get(1), ", ", parameterList.get(0)));
    }
}

